/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.atom.pojo;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.tencent.bk.devops.atom.common.Status;
import com.tencent.bk.devops.atom.pojo.DataField;
import com.tencent.bk.devops.atom.pojo.MonitorData;
import com.tencent.bk.devops.atom.pojo.quality.QualityValue;
import com.tencent.bk.devops.atom.utils.I18nUtil;
import com.tencent.bk.devops.atom.utils.MessageUtil;
import com.tencent.bk.devops.plugin.pojo.ErrorType;
import java.util.Map;

public class AtomResult {
    @JsonProperty(value="status")
    private Status status = Status.success;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="type")
    private String type = "default";
    @JsonProperty(value="data")
    private Map<String, DataField> data = Maps.newHashMap();
    @JsonProperty(value="qualityData")
    private Map<String, QualityValue> qualityData = Maps.newHashMap();
    @JsonProperty(value="errorType")
    private Integer errorType;
    @JsonProperty(value="errorCode")
    private Integer errorCode;
    @JsonProperty(value="monitorData")
    private MonitorData monitorData;

    public void setErrorInfo(Status status, Integer errorCode, ErrorType errorType, String[] params) {
        this.status = status;
        this.errorCode = errorCode;
        this.errorType = errorType.getNum();
        this.message = MessageUtil.getMessageByLocale(errorCode.toString(), I18nUtil.getLanguage(), params);
    }

    public Status getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, DataField> getData() {
        return this.data;
    }

    public Map<String, QualityValue> getQualityData() {
        return this.qualityData;
    }

    public Integer getErrorType() {
        return this.errorType;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public MonitorData getMonitorData() {
        return this.monitorData;
    }

    @JsonProperty(value="status")
    public void setStatus(Status status) {
        this.status = status;
    }

    @JsonProperty(value="message")
    public void setMessage(String message) {
        this.message = message;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="data")
    public void setData(Map<String, DataField> data) {
        this.data = data;
    }

    @JsonProperty(value="qualityData")
    public void setQualityData(Map<String, QualityValue> qualityData) {
        this.qualityData = qualityData;
    }

    @JsonProperty(value="errorType")
    public void setErrorType(Integer errorType) {
        this.errorType = errorType;
    }

    @JsonProperty(value="errorCode")
    public void setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
    }

    @JsonProperty(value="monitorData")
    public void setMonitorData(MonitorData monitorData) {
        this.monitorData = monitorData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtomResult)) {
            return false;
        }
        AtomResult other = (AtomResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$errorType = this.getErrorType();
        Integer other$errorType = other.getErrorType();
        if (this$errorType == null ? other$errorType != null : !((Object)this$errorType).equals(other$errorType)) {
            return false;
        }
        Integer this$errorCode = this.getErrorCode();
        Integer other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !((Object)this$errorCode).equals(other$errorCode)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Map<String, DataField> this$data = this.getData();
        Map<String, DataField> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        Map<String, QualityValue> this$qualityData = this.getQualityData();
        Map<String, QualityValue> other$qualityData = other.getQualityData();
        if (this$qualityData == null ? other$qualityData != null : !((Object)this$qualityData).equals(other$qualityData)) {
            return false;
        }
        MonitorData this$monitorData = this.getMonitorData();
        MonitorData other$monitorData = other.getMonitorData();
        return !(this$monitorData == null ? other$monitorData != null : !((Object)this$monitorData).equals(other$monitorData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AtomResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $errorType = this.getErrorType();
        result = result * 59 + ($errorType == null ? 43 : ((Object)$errorType).hashCode());
        Integer $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : ((Object)$errorCode).hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Map<String, DataField> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        Map<String, QualityValue> $qualityData = this.getQualityData();
        result = result * 59 + ($qualityData == null ? 43 : ((Object)$qualityData).hashCode());
        MonitorData $monitorData = this.getMonitorData();
        result = result * 59 + ($monitorData == null ? 43 : ((Object)$monitorData).hashCode());
        return result;
    }

    public String toString() {
        return "AtomResult(status=" + String.valueOf((Object)this.getStatus()) + ", message=" + this.getMessage() + ", type=" + this.getType() + ", data=" + String.valueOf(this.getData()) + ", qualityData=" + String.valueOf(this.getQualityData()) + ", errorType=" + this.getErrorType() + ", errorCode=" + this.getErrorCode() + ", monitorData=" + String.valueOf(this.getMonitorData()) + ")";
    }
}

