/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.atom.utils;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageUtil {
    private static final Logger logger = LoggerFactory.getLogger(MessageUtil.class);
    private static final String DEFAULT_BASE_NAME = "i18n/message";

    public static String getMessageByLocale(String messageCode, String language) {
        return MessageUtil.getMessageByLocale(messageCode, language, null, DEFAULT_BASE_NAME, null);
    }

    public static String getMessageByLocale(String messageCode, String language, String defaultMessage) {
        return MessageUtil.getMessageByLocale(messageCode, language, null, DEFAULT_BASE_NAME, defaultMessage);
    }

    public static String getMessageByLocale(String messageCode, String language, String[] params) {
        return MessageUtil.getMessageByLocale(messageCode, language, params, DEFAULT_BASE_NAME, null);
    }

    public static String getMessageByLocale(String messageCode, String language, String[] params, String defaultMessage) {
        return MessageUtil.getMessageByLocale(messageCode, language, params, DEFAULT_BASE_NAME, defaultMessage);
    }

    public static String getMessageByLocale(String messageCode, String language, String[] params, String baseName, String defaultMessage) {
        String message = null;
        try {
            String[] arrs = language.split("_");
            Locale localeObj = new Locale(arrs[0], arrs[1]);
            ResourceBundle resourceBundle = ResourceBundle.getBundle(baseName, localeObj);
            message = resourceBundle.getString(messageCode);
        }
        catch (Throwable ignored) {
            logger.warn("Fail to get i18nMessage of messageCode[" + messageCode + "]", ignored);
        }
        if (null != params && null != message) {
            MessageFormat mf = new MessageFormat(message);
            message = mf.format(params);
        }
        if (message == null) {
            message = defaultMessage;
        }
        return message;
    }
}

