/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.atom.utils.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMapper {
    private ObjectMapper mapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(JsonMapper.class);

    private JsonMapper(JsonInclude.Include include) {
        if (include != null) {
            this.mapper.setSerializationInclusion(include);
        }
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.mapper.registerModule((Module)new KotlinModule());
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public static JsonMapper nonEmptyMapper() {
        return JsonMapper.build(JsonInclude.Include.NON_EMPTY);
    }

    public static JsonMapper allOutPutMapper() {
        return JsonMapper.build(JsonInclude.Include.ALWAYS);
    }

    public static JsonMapper build(JsonInclude.Include include) {
        return new JsonMapper(include);
    }

    public String toJson(Object object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            logger.info("toJson error:", e);
            return null;
        }
    }

    public <T> T fromJson(String jsonString, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(jsonString, clazz);
        }
        catch (IOException e) {
            logger.info("fromJson error:", e);
            return null;
        }
    }

    public <T> T fromJson(String jsonString, TypeReference<T> typeReference) {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(jsonString, typeReference);
        }
        catch (IOException e) {
            logger.info("fromJson error:", e);
            return null;
        }
    }
}

