/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.plugin.api.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.tencent.bk.devops.atom.api.BaseApi;
import com.tencent.bk.devops.atom.utils.http.SdkUtils;
import com.tencent.bk.devops.atom.utils.json.JsonUtil;
import com.tencent.bk.devops.plugin.docker.utils.EnvUtils;
import com.tencent.bk.devops.plugin.pojo.Result;
import com.tencent.bk.devops.plugin.pojo.kubernetes.DispatchBuildImageReq;
import com.tencent.bk.devops.plugin.pojo.kubernetes.DispatchBuildStatusResp;
import com.tencent.bk.devops.plugin.pojo.kubernetes.DispatchJobLogResp;
import com.tencent.bk.devops.plugin.pojo.kubernetes.DispatchJobReq;
import com.tencent.bk.devops.plugin.pojo.kubernetes.DispatchTaskResp;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u0012\u001a\u00020\fJ\u0016\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\fH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/tencent/bk/devops/plugin/api/impl/KubernetesBuildApi;", "Lcom/tencent/bk/devops/atom/api/BaseApi;", "<init>", "()V", "createJob", "Lcom/tencent/bk/devops/plugin/pojo/Result;", "Lcom/tencent/bk/devops/plugin/pojo/kubernetes/DispatchTaskResp;", "dispatchJobReq", "Lcom/tencent/bk/devops/plugin/pojo/kubernetes/DispatchJobReq;", "getJobStatus", "Lcom/tencent/bk/devops/plugin/pojo/kubernetes/DispatchBuildStatusResp;", "jobName", "", "getJobLogs", "Lcom/tencent/bk/devops/plugin/pojo/kubernetes/DispatchJobLogResp;", "sinceTime", "", "getTask", "taskId", "dockerBuildAndPush", "dispatchBuildImageReq", "Lcom/tencent/bk/devops/plugin/pojo/kubernetes/DispatchBuildImageReq;", "getUserId", "Companion", "java-plugin-sdk"})
public final class KubernetesBuildApi
extends BaseApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger logger = LoggerFactory.getLogger(KubernetesBuildApi.class);

    @NotNull
    public final Result<DispatchTaskResp> createJob(@NotNull DispatchJobReq dispatchJobReq) {
        Intrinsics.checkNotNullParameter((Object)dispatchJobReq, (String)"dispatchJobReq");
        String path = "/dispatch-kubernetes/api/build/job/create";
        DispatchJobReq.copy$default(dispatchJobReq, null, null, null, null, null, EnvUtils.INSTANCE.getHostName(), null, 95, null);
        String string = JsonUtil.toJson(dispatchJobReq);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        RequestBody requestBody = RequestBody.Companion.create(BaseApi.JSON_CONTENT_TYPE, string);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"X-DEVOPS-UID", (Object)this.getUserId())};
        Request request = this.buildPost(path, requestBody, MapsKt.mutableMapOf((Pair[])pairArray));
        String responseContent = this.request(request, "kubernetes job fail");
        logger.debug("create kubernetes job response: " + responseContent);
        Object t = JsonUtil.fromJson(responseContent, (TypeReference)new TypeReference<Result<? extends DispatchTaskResp>>(){});
        Intrinsics.checkNotNullExpressionValue(t, (String)"fromJson(...)");
        return (Result)t;
    }

    @NotNull
    public final Result<DispatchBuildStatusResp> getJobStatus(@NotNull String jobName) {
        Intrinsics.checkNotNullParameter((Object)jobName, (String)"jobName");
        String path = "/dispatch-kubernetes/api/build/job/" + jobName + "/status";
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"X-DEVOPS-UID", (Object)this.getUserId())};
        Request request = this.buildGet(path, MapsKt.mutableMapOf((Pair[])pairArray));
        String responseContent = this.request(request, "failed to get job status");
        logger.debug("get kubernetes job status response: " + responseContent);
        Object t = JsonUtil.fromJson(responseContent, (TypeReference)new TypeReference<Result<? extends DispatchBuildStatusResp>>(){});
        Intrinsics.checkNotNullExpressionValue(t, (String)"fromJson(...)");
        return (Result)t;
    }

    @NotNull
    public final Result<DispatchJobLogResp> getJobLogs(@NotNull String jobName, int sinceTime) {
        Intrinsics.checkNotNullParameter((Object)jobName, (String)"jobName");
        String path = "/dispatch-kubernetes/api/build/job/" + jobName + "/logs?sinceTime=" + sinceTime;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"X-DEVOPS-UID", (Object)this.getUserId())};
        Request request = this.buildGet(path, MapsKt.mutableMapOf((Pair[])pairArray));
        String responseContent = this.request(request, "failed to get job log");
        logger.debug("get kubernetes job logs response: " + responseContent);
        Object t = JsonUtil.fromJson(responseContent, (TypeReference)new TypeReference<Result<? extends DispatchJobLogResp>>(){});
        Intrinsics.checkNotNullExpressionValue(t, (String)"fromJson(...)");
        return (Result)t;
    }

    @NotNull
    public final Result<DispatchBuildStatusResp> getTask(@NotNull String taskId) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        String path = "/dispatch-kubernetes/api/build/task/status?taskId=" + taskId;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"X-DEVOPS-UID", (Object)this.getUserId())};
        Request request = this.buildGet(path, MapsKt.mutableMapOf((Pair[])pairArray));
        String responseContent = this.request(request, "get task info fail");
        logger.debug("get kubernetes task response: " + responseContent);
        Object t = JsonUtil.fromJson(responseContent, (TypeReference)new TypeReference<Result<? extends DispatchBuildStatusResp>>(){});
        Intrinsics.checkNotNullExpressionValue(t, (String)"fromJson(...)");
        return (Result)t;
    }

    @NotNull
    public final Result<DispatchTaskResp> dockerBuildAndPush(@NotNull DispatchBuildImageReq dispatchBuildImageReq) {
        Intrinsics.checkNotNullParameter((Object)dispatchBuildImageReq, (String)"dispatchBuildImageReq");
        String path = "/dispatch-kubernetes/api/build/image/buildPush";
        DispatchBuildImageReq.copy$default(dispatchBuildImageReq, null, null, null, null, null, null, null, EnvUtils.INSTANCE.getHostName(), 127, null);
        String string = JsonUtil.toJson(dispatchBuildImageReq);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        RequestBody requestBody = RequestBody.Companion.create(BaseApi.JSON_CONTENT_TYPE, string);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"X-DEVOPS-UID", (Object)this.getUserId())};
        Request request = this.buildPost(path, requestBody, MapsKt.mutableMapOf((Pair[])pairArray));
        String responseContent = this.request(request, "kubernetes docker build fail");
        logger.debug("docker build response: " + responseContent);
        Object t = JsonUtil.fromJson(responseContent, (TypeReference)new TypeReference<Result<? extends DispatchTaskResp>>(){});
        Intrinsics.checkNotNullExpressionValue(t, (String)"fromJson(...)");
        return (Result)t;
    }

    private final String getUserId() {
        String inputJson = null;
        try {
            inputJson = FileUtils.readFileToString((File)new File(SdkUtils.getDataDir() + '/' + SdkUtils.getInputFile()), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            logger.error("parse inputJson throw Exception", e);
            return "";
        }
        Object t = JsonUtil.fromJson(inputJson, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Intrinsics.checkNotNullExpressionValue(t, (String)"fromJson(...)");
        Map inputMap2 = (Map)t;
        Object v = inputMap2.get("BK_CI_START_USER_ID");
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)v;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/tencent/bk/devops/plugin/api/impl/KubernetesBuildApi$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "java-plugin-sdk"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

