/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.plugin.docker;

import com.fasterxml.jackson.core.type.TypeReference;
import com.tencent.bk.devops.atom.api.SdkEnv;
import com.tencent.bk.devops.atom.pojo.Result;
import com.tencent.bk.devops.atom.utils.http.OkHttpUtils;
import com.tencent.bk.devops.atom.utils.json.JsonUtil;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunLogRequest;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunLogResponse;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunRequest;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.tools.ant.types.Commandline;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0007J&\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J \u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00192\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0019H\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/tencent/bk/devops/plugin/docker/CommonExecutor;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "ONE_MILL_SECONDS", "", "execute", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunResponse;", "projectId", "", "pipelineId", "buildId", "request", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunRequest;", "taskId", "getLogs", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunLogResponse;", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunLogRequest;", "getRunParamJson", "param", "trimLogs", "", "list", "DockerRunParam", "LogParam", "java-plugin-sdk"})
@SourceDebugExtension(value={"SMAP\nCommonExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonExecutor.kt\ncom/tencent/bk/devops/plugin/docker/CommonExecutor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,168:1\n1863#2,2:169\n1557#2:171\n1628#2,2:172\n1630#2:176\n37#3,2:174\n*S KotlinDebug\n*F\n+ 1 CommonExecutor.kt\ncom/tencent/bk/devops/plugin/docker/CommonExecutor\n*L\n111#1:169,2\n137#1:171\n137#1:172,2\n137#1:176\n138#1:174,2\n*E\n"})
public final class CommonExecutor {
    @NotNull
    public static final CommonExecutor INSTANCE = new CommonExecutor();
    private static final Logger logger = LoggerFactory.getLogger(CommonExecutor.class);
    private static final int ONE_MILL_SECONDS = 1000;

    private CommonExecutor() {
    }

    @JvmOverloads
    @NotNull
    public final DockerRunResponse execute(@NotNull String projectId, @NotNull String pipelineId, @NotNull String buildId, @NotNull DockerRunRequest request, @Nullable String taskId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)pipelineId, (String)"pipelineId");
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String runParam = this.getRunParamJson(request);
        String dockerHostIP = System.getenv("docker_host_ip");
        String string = System.getenv("docker_host_port");
        if (string == null) {
            string = "80";
        }
        String dockerHostPort = string;
        String vmSeqId = SdkEnv.getVmSeqId();
        String dockerRunUrl = taskId == null ? "http://" + dockerHostIP + ':' + dockerHostPort + "/api/docker/run/" + projectId + '/' + pipelineId + '/' + vmSeqId + '/' + buildId : "http://" + dockerHostIP + ':' + dockerHostPort + "/api/docker/run/" + projectId + '/' + pipelineId + '/' + vmSeqId + '/' + buildId + "?taskId=" + taskId;
        logger.info("execute docker run url: " + dockerRunUrl);
        String responseContent = OkHttpUtils.doPost(dockerRunUrl, runParam);
        logger.info("execute docker run response: " + responseContent);
        Map extraOptions2 = (Map)((Result)JsonUtil.fromJson((String)responseContent, (TypeReference)new TypeReference<Result<Map<String, ? extends Object>>>(){})).data;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"containerId", (Object)String.valueOf(extraOptions2.get("containerId"))), TuplesKt.to((Object)"startTimeStamp", (Object)String.valueOf(extraOptions2.get("startTimeStamp")))};
        return new DockerRunResponse(MapsKt.mapOf((Pair[])pairArray));
    }

    public static /* synthetic */ DockerRunResponse execute$default(CommonExecutor commonExecutor, String string, String string2, String string3, DockerRunRequest dockerRunRequest, String string4, int n, Object object) {
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        return commonExecutor.execute(string, string2, string3, dockerRunRequest, string4);
    }

    @NotNull
    public final DockerRunLogResponse getLogs(@NotNull String projectId, @NotNull String pipelineId, @NotNull String buildId, @NotNull DockerRunLogRequest request) {
        DockerRunLogResponse dockerRunLogResponse;
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)pipelineId, (String)"pipelineId");
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String containerId = (String)MapsKt.getValue(request.getExtraOptions(), (Object)"containerId");
        String startTimeStamp = (String)MapsKt.getValue(request.getExtraOptions(), (Object)"startTimeStamp");
        String dockerHostIP = System.getenv("docker_host_ip");
        String string = System.getenv("docker_host_port");
        if (string == null) {
            string = "80";
        }
        String dockerHostPort = string;
        String vmSeqId = SdkEnv.getVmSeqId();
        String dockerGetLogUrl = "http://" + dockerHostIP + ':' + dockerHostPort + "/api/docker/runlog/" + projectId + '/' + pipelineId + '/' + vmSeqId + '/' + buildId + '/' + containerId + '/' + startTimeStamp;
        String logResponse = OkHttpUtils.doGet(dockerGetLogUrl);
        LogParam logParam = (LogParam)((Result)JsonUtil.fromJson((String)logResponse, (TypeReference)new TypeReference<Result<LogParam>>(){})).data;
        if (logParam == null) {
            return new DockerRunLogResponse(null, "failure", "the log data is null with get http: " + dockerGetLogUrl, request.getExtraOptions(), 1, null);
        }
        LogParam logResult2 = logParam;
        if (!Intrinsics.areEqual((Object)logResult2.getRunning(), (Object)true)) {
            Integer n = logResult2.getExitCode();
            dockerRunLogResponse = n != null && n == 0 ? new DockerRunLogResponse(this.trimLogs(logResult2.getLogs()), "success", "the Docker Run Log is listed as follows:", request.getExtraOptions()) : new DockerRunLogResponse(this.trimLogs(logResult2.getLogs()), "failure", "the Docker Run Log is listed as follows:", request.getExtraOptions());
        } else {
            dockerRunLogResponse = new DockerRunLogResponse(logResult2.getLogs(), "running", "get log...", MapsKt.plus(request.getExtraOptions(), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"startTimeStamp", (Object)String.valueOf(Long.parseLong(startTimeStamp) + request.getTimeGap() / (long)1000)))));
        }
        return dockerRunLogResponse;
    }

    private final String getRunParamJson(DockerRunRequest param) {
        List list;
        DockerRunRequest $this$getRunParamJson_u24lambda_u241 = param;
        boolean bl = false;
        List cmdTmp = new ArrayList();
        Iterable $this$forEach$iv = $this$getRunParamJson_u24lambda_u241.getCommand();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            cmdTmp.add(StringsKt.removeSuffix((String)StringsKt.removePrefix((String)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)it, (CharSequence)"\""), (CharSequence)"\""), (CharSequence)"'"), (CharSequence)"'"));
        }
        if (cmdTmp.size() == 1) {
            String[] stringArray = Commandline.translateCommandline((String)((String)CollectionsKt.first((List)cmdTmp)));
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"translateCommandline(...)");
            list = ArraysKt.toList((Object[])stringArray);
        } else {
            list = cmdTmp;
        }
        List cmd = list;
        String string = $this$getRunParamJson_u24lambda_u241.getImageName();
        String string2 = param.getDockerLoginUsername();
        String string3 = param.getDockerLoginPassword();
        Map map = $this$getRunParamJson_u24lambda_u241.getEnvMap();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        DockerRunParam runParam = new DockerRunParam(string, string2, string3, cmd, map, System.getenv("pool_no"));
        logger.info("execute docker run image: " + runParam);
        String string4 = JsonUtil.toJson(runParam);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toJson(...)");
        return string4;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> trimLogs(List<String> list) {
        List list2;
        List<String> list3 = list;
        if (list3 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                void $this$toTypedArray$iv;
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object object = (CharSequence)it;
                Regex regex = new Regex("\\s+");
                int n = 0;
                object = regex.split((CharSequence)object, n);
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] split = thisCollection$iv.toArray(new String[0]);
                if (split.length >= 3) {
                    String string3 = it.substring(StringsKt.indexOf$default((CharSequence)((CharSequence)it), (String)split[2], (int)0, (boolean)false, (int)6, null));
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                } else {
                    string = it;
                }
                void log = string;
                collection.add(log);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }

    @JvmOverloads
    @NotNull
    public final DockerRunResponse execute(@NotNull String projectId, @NotNull String pipelineId, @NotNull String buildId, @NotNull DockerRunRequest request) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)pipelineId, (String)"pipelineId");
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return CommonExecutor.execute$default(this, projectId, pipelineId, buildId, request, null, 16, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001BQ\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0016\u001a\u00020\u0003H\u0016J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J\u0015\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J_\u0010\u001d\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000e\u00a8\u0006#"}, d2={"Lcom/tencent/bk/devops/plugin/docker/CommonExecutor$DockerRunParam;", "", "imageName", "", "registryUser", "registryPwd", "command", "", "env", "", "poolNo", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/Map;Ljava/lang/String;)V", "getImageName", "()Ljava/lang/String;", "getRegistryUser", "getRegistryPwd", "getCommand", "()Ljava/util/List;", "getEnv", "()Ljava/util/Map;", "getPoolNo", "toString", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "java-plugin-sdk"})
    private static final class DockerRunParam {
        @Nullable
        private final String imageName;
        @Nullable
        private final String registryUser;
        @Nullable
        private final String registryPwd;
        @NotNull
        private final List<String> command;
        @NotNull
        private final Map<String, String> env;
        @Nullable
        private final String poolNo;

        public DockerRunParam(@Nullable String imageName, @Nullable String registryUser, @Nullable String registryPwd, @NotNull List<String> command, @NotNull Map<String, String> env, @Nullable String poolNo) {
            Intrinsics.checkNotNullParameter(command, (String)"command");
            Intrinsics.checkNotNullParameter(env, (String)"env");
            this.imageName = imageName;
            this.registryUser = registryUser;
            this.registryPwd = registryPwd;
            this.command = command;
            this.env = env;
            this.poolNo = poolNo;
        }

        @Nullable
        public final String getImageName() {
            return this.imageName;
        }

        @Nullable
        public final String getRegistryUser() {
            return this.registryUser;
        }

        @Nullable
        public final String getRegistryPwd() {
            return this.registryPwd;
        }

        @NotNull
        public final List<String> getCommand() {
            return this.command;
        }

        @NotNull
        public final Map<String, String> getEnv() {
            return this.env;
        }

        @Nullable
        public final String getPoolNo() {
            return this.poolNo;
        }

        @NotNull
        public String toString() {
            return "image name: " + this.imageName + ", registry user: " + this.registryUser + ", command: " + this.command + ", env: " + this.env + ", pool no: " + this.poolNo;
        }

        @Nullable
        public final String component1() {
            return this.imageName;
        }

        @Nullable
        public final String component2() {
            return this.registryUser;
        }

        @Nullable
        public final String component3() {
            return this.registryPwd;
        }

        @NotNull
        public final List<String> component4() {
            return this.command;
        }

        @NotNull
        public final Map<String, String> component5() {
            return this.env;
        }

        @Nullable
        public final String component6() {
            return this.poolNo;
        }

        @NotNull
        public final DockerRunParam copy(@Nullable String imageName, @Nullable String registryUser, @Nullable String registryPwd, @NotNull List<String> command, @NotNull Map<String, String> env, @Nullable String poolNo) {
            Intrinsics.checkNotNullParameter(command, (String)"command");
            Intrinsics.checkNotNullParameter(env, (String)"env");
            return new DockerRunParam(imageName, registryUser, registryPwd, command, env, poolNo);
        }

        public static /* synthetic */ DockerRunParam copy$default(DockerRunParam dockerRunParam, String string, String string2, String string3, List list, Map map, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = dockerRunParam.imageName;
            }
            if ((n & 2) != 0) {
                string2 = dockerRunParam.registryUser;
            }
            if ((n & 4) != 0) {
                string3 = dockerRunParam.registryPwd;
            }
            if ((n & 8) != 0) {
                list = dockerRunParam.command;
            }
            if ((n & 0x10) != 0) {
                map = dockerRunParam.env;
            }
            if ((n & 0x20) != 0) {
                string4 = dockerRunParam.poolNo;
            }
            return dockerRunParam.copy(string, string2, string3, list, map, string4);
        }

        public int hashCode() {
            int result = this.imageName == null ? 0 : this.imageName.hashCode();
            result = result * 31 + (this.registryUser == null ? 0 : this.registryUser.hashCode());
            result = result * 31 + (this.registryPwd == null ? 0 : this.registryPwd.hashCode());
            result = result * 31 + ((Object)this.command).hashCode();
            result = result * 31 + ((Object)this.env).hashCode();
            result = result * 31 + (this.poolNo == null ? 0 : this.poolNo.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DockerRunParam)) {
                return false;
            }
            DockerRunParam dockerRunParam = (DockerRunParam)other;
            if (!Intrinsics.areEqual((Object)this.imageName, (Object)dockerRunParam.imageName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.registryUser, (Object)dockerRunParam.registryUser)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.registryPwd, (Object)dockerRunParam.registryPwd)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.command, dockerRunParam.command)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.env, dockerRunParam.env)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.poolNo, (Object)dockerRunParam.poolNo);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0014\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\u0011\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0011J8\u0010\u0016\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0006H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/tencent/bk/devops/plugin/docker/CommonExecutor$LogParam;", "", "exitCode", "", "logs", "", "", "running", "", "<init>", "(Ljava/lang/Integer;Ljava/util/List;Ljava/lang/Boolean;)V", "getExitCode", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getLogs", "()Ljava/util/List;", "getRunning", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "component1", "component2", "component3", "copy", "(Ljava/lang/Integer;Ljava/util/List;Ljava/lang/Boolean;)Lcom/tencent/bk/devops/plugin/docker/CommonExecutor$LogParam;", "equals", "other", "hashCode", "toString", "java-plugin-sdk"})
    public static final class LogParam {
        @Nullable
        private final Integer exitCode;
        @Nullable
        private final List<String> logs;
        @Nullable
        private final Boolean running;

        public LogParam(@Nullable Integer exitCode, @Nullable List<String> logs, @Nullable Boolean running) {
            this.exitCode = exitCode;
            this.logs = logs;
            this.running = running;
        }

        public /* synthetic */ LogParam(Integer n, List list, Boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = null;
            }
            if ((n2 & 2) != 0) {
                list = null;
            }
            if ((n2 & 4) != 0) {
                bl = null;
            }
            this(n, list, bl);
        }

        @Nullable
        public final Integer getExitCode() {
            return this.exitCode;
        }

        @Nullable
        public final List<String> getLogs() {
            return this.logs;
        }

        @Nullable
        public final Boolean getRunning() {
            return this.running;
        }

        @Nullable
        public final Integer component1() {
            return this.exitCode;
        }

        @Nullable
        public final List<String> component2() {
            return this.logs;
        }

        @Nullable
        public final Boolean component3() {
            return this.running;
        }

        @NotNull
        public final LogParam copy(@Nullable Integer exitCode, @Nullable List<String> logs, @Nullable Boolean running) {
            return new LogParam(exitCode, logs, running);
        }

        public static /* synthetic */ LogParam copy$default(LogParam logParam, Integer n, List list, Boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = logParam.exitCode;
            }
            if ((n2 & 2) != 0) {
                list = logParam.logs;
            }
            if ((n2 & 4) != 0) {
                bl = logParam.running;
            }
            return logParam.copy(n, list, bl);
        }

        @NotNull
        public String toString() {
            return "LogParam(exitCode=" + this.exitCode + ", logs=" + this.logs + ", running=" + this.running + ')';
        }

        public int hashCode() {
            int result = this.exitCode == null ? 0 : ((Object)this.exitCode).hashCode();
            result = result * 31 + (this.logs == null ? 0 : ((Object)this.logs).hashCode());
            result = result * 31 + (this.running == null ? 0 : ((Object)this.running).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LogParam)) {
                return false;
            }
            LogParam logParam = (LogParam)other;
            if (!Intrinsics.areEqual((Object)this.exitCode, (Object)logParam.exitCode)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.logs, logParam.logs)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.running, (Object)logParam.running);
        }

        public LogParam() {
            this(null, null, null, 7, null);
        }
    }
}

