/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.plugin.docker;

import com.tencent.bk.devops.atom.api.BaseApi;
import com.tencent.bk.devops.atom.pojo.Result;
import com.tencent.bk.devops.plugin.docker.CommonExecutor;
import com.tencent.bk.devops.plugin.docker.KubernetesExecutor;
import com.tencent.bk.devops.plugin.docker.ThirdPartExecutor;
import com.tencent.bk.devops.plugin.docker.exception.DockerRunException;
import com.tencent.bk.devops.plugin.docker.exception.DockerRunLogException;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunLogRequest;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunLogResponse;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunRequest;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunResponse;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\bH\u0007J*\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J,\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0011J*\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0011H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/tencent/bk/devops/plugin/docker/DockerApi;", "Lcom/tencent/bk/devops/atom/api/BaseApi;", "<init>", "()V", "dockerRunCommand", "Lcom/tencent/bk/devops/atom/pojo/Result;", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunResponse;", "projectId", "", "pipelineId", "buildId", "param", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunRequest;", "taskId", "dockerRunCustomize", "dockerRunGetLog", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunLogResponse;", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunLogRequest;", "dockerRunGetLogCustomize", "Companion", "java-plugin-sdk"})
public class DockerApi
extends BaseApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger logger = LoggerFactory.getLogger(DockerApi.class);

    @JvmOverloads
    @NotNull
    public final Result<DockerRunResponse> dockerRunCommand(@NotNull String projectId, @NotNull String pipelineId, @NotNull String buildId, @NotNull DockerRunRequest param, @Nullable String taskId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)pipelineId, (String)"pipelineId");
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        try {
            String property = System.getenv("devops_slave_model");
            String jobPoolType = System.getenv("JOB_POOL");
            DockerRunResponse response = this.dockerRunCustomize(projectId, pipelineId, buildId, param);
            if (response == null) {
                response = Intrinsics.areEqual((Object)"docker", (Object)property) ? CommonExecutor.INSTANCE.execute(projectId, pipelineId, buildId, param, taskId) : (Intrinsics.areEqual((Object)"KUBERNETES", (Object)jobPoolType) ? KubernetesExecutor.INSTANCE.execute(param) : ThirdPartExecutor.INSTANCE.execute(param));
            }
            return new Result<DockerRunResponse>(response);
        }
        catch (Exception ignore) {
            logger.error("Failed to create job. " + param.getImageName(), ignore);
            String string = ignore.getMessage();
            if (string == null) {
                string = "";
            }
            throw new DockerRunException(string, 0, 2, null);
        }
    }

    public static /* synthetic */ Result dockerRunCommand$default(DockerApi dockerApi, String string, String string2, String string3, DockerRunRequest dockerRunRequest, String string4, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: dockerRunCommand");
        }
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        return dockerApi.dockerRunCommand(string, string2, string3, dockerRunRequest, string4);
    }

    @Nullable
    public DockerRunResponse dockerRunCustomize(@NotNull String projectId, @NotNull String pipelineId, @NotNull String buildId, @NotNull DockerRunRequest param) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)pipelineId, (String)"pipelineId");
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        return null;
    }

    @NotNull
    public final Result<DockerRunLogResponse> dockerRunGetLog(@NotNull String projectId, @NotNull String pipelineId, @NotNull String buildId, @NotNull DockerRunLogRequest param) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)pipelineId, (String)"pipelineId");
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        try {
            String property = System.getenv("devops_slave_model");
            String jobPoolType = System.getenv("JOB_POOL");
            DockerRunLogResponse response = this.dockerRunGetLogCustomize(projectId, pipelineId, buildId, param);
            if (response == null) {
                response = Intrinsics.areEqual((Object)"docker", (Object)property) ? CommonExecutor.INSTANCE.getLogs(projectId, pipelineId, buildId, param) : (Intrinsics.areEqual((Object)"KUBERNETES", (Object)jobPoolType) ? KubernetesExecutor.INSTANCE.getLogs(param) : ThirdPartExecutor.INSTANCE.getLogs(param));
            }
            return new Result<DockerRunLogResponse>(response);
        }
        catch (Exception ignore) {
            String string = ignore.getMessage();
            if (string == null) {
                string = "";
            }
            throw new DockerRunLogException(string, 0, 2, null);
        }
    }

    @Nullable
    public DockerRunLogResponse dockerRunGetLogCustomize(@NotNull String projectId, @NotNull String pipelineId, @NotNull String buildId, @NotNull DockerRunLogRequest param) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)pipelineId, (String)"pipelineId");
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        return null;
    }

    @JvmOverloads
    @NotNull
    public final Result<DockerRunResponse> dockerRunCommand(@NotNull String projectId, @NotNull String pipelineId, @NotNull String buildId, @NotNull DockerRunRequest param) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)pipelineId, (String)"pipelineId");
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        return DockerApi.dockerRunCommand$default(this, projectId, pipelineId, buildId, param, null, 16, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/tencent/bk/devops/plugin/docker/DockerApi$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "java-plugin-sdk"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

