/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.plugin.docker;

import com.tencent.bk.devops.plugin.api.impl.KubernetesBuildApi;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunLogRequest;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunLogResponse;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunRequest;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunResponse;
import com.tencent.bk.devops.plugin.docker.utils.EnvUtils;
import com.tencent.bk.devops.plugin.pojo.kubernetes.DispatchBuildStatusResp;
import com.tencent.bk.devops.plugin.pojo.kubernetes.DispatchJobLogResp;
import com.tencent.bk.devops.plugin.pojo.kubernetes.DispatchJobReq;
import com.tencent.bk.devops.plugin.pojo.kubernetes.DispatchTaskResp;
import com.tencent.bk.devops.plugin.pojo.kubernetes.DockerRegistry;
import com.tencent.bk.devops.plugin.pojo.kubernetes.JobParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.tools.ant.types.Commandline;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/tencent/bk/devops/plugin/docker/KubernetesExecutor;", "", "<init>", "()V", "VOLUME_SERVER", "", "VOLUME_PATH", "VOLUME_MOUNT_PATH", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "execute", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunResponse;", "request", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunRequest;", "getLogs", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunLogResponse;", "param", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunLogRequest;", "getJobRequest", "Lcom/tencent/bk/devops/plugin/pojo/kubernetes/DispatchJobReq;", "getImagePair", "Lkotlin/Pair;", "imageName", "java-plugin-sdk"})
@SourceDebugExtension(value={"SMAP\nKubernetesExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesExecutor.kt\ncom/tencent/bk/devops/plugin/docker/KubernetesExecutor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,195:1\n1863#2,2:196\n*S KotlinDebug\n*F\n+ 1 KubernetesExecutor.kt\ncom/tencent/bk/devops/plugin/docker/KubernetesExecutor\n*L\n139#1:196,2\n*E\n"})
public final class KubernetesExecutor {
    @NotNull
    public static final KubernetesExecutor INSTANCE = new KubernetesExecutor();
    @NotNull
    private static final String VOLUME_SERVER = "volume_server";
    @NotNull
    private static final String VOLUME_PATH = "volume_path";
    @NotNull
    private static final String VOLUME_MOUNT_PATH = "volume_mount_path";
    private static final Logger logger = LoggerFactory.getLogger(KubernetesExecutor.class);

    private KubernetesExecutor() {
    }

    @NotNull
    public final DockerRunResponse execute(@NotNull DockerRunRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        long startTimeStamp = System.currentTimeMillis() / (long)1000;
        DispatchJobReq jobRequest = this.getJobRequest(request);
        DispatchTaskResp task = new KubernetesBuildApi().createJob(jobRequest).getData();
        Pair[] pairArray = new Pair[3];
        DispatchTaskResp dispatchTaskResp = task;
        pairArray[0] = TuplesKt.to((Object)"kubernetesTaskId", (Object)String.valueOf(dispatchTaskResp != null ? dispatchTaskResp.getTaskId() : null));
        pairArray[1] = TuplesKt.to((Object)"bcsJobName", (Object)jobRequest.getAlias());
        pairArray[2] = TuplesKt.to((Object)"startTimeStamp", (Object)String.valueOf(startTimeStamp));
        Map extraOptionMap = MapsKt.mapOf((Pair[])pairArray);
        Map map = request.getExtraOptions();
        if (map == null || (map = MapsKt.plus(map, (Map)extraOptionMap)) == null) {
            map = extraOptionMap;
        }
        return new DockerRunResponse(map);
    }

    @NotNull
    public final DockerRunLogResponse getLogs(@NotNull DockerRunLogRequest param) {
        Object[] it;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        Map extraOptions2 = MapsKt.toMutableMap(param.getExtraOptions());
        String string = param.getExtraOptions().get("kubernetesTaskId");
        if (string == null) {
            throw new RuntimeException("kubernetesTaskId is null");
        }
        String taskId = string;
        String taskStatusFlag = param.getExtraOptions().get("taskStatusFlag");
        CharSequence charSequence2 = taskStatusFlag;
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2) || Intrinsics.areEqual((Object)taskStatusFlag, (Object)"running")) {
            DispatchBuildStatusResp taskStatus;
            DispatchBuildStatusResp it2 = taskStatus = new KubernetesBuildApi().getTask(taskId).getData();
            boolean bl = false;
            DispatchBuildStatusResp dispatchBuildStatusResp = taskStatus;
            Intrinsics.checkNotNull((Object)dispatchBuildStatusResp);
            if (Intrinsics.areEqual((Object)dispatchBuildStatusResp.getStatus(), (Object)"failed")) {
                return new DockerRunLogResponse(null, "failure", "get task status fail", extraOptions2, 1, null);
            }
            if (!Intrinsics.areEqual((Object)taskStatus.getStatus(), (Object)"succeeded")) {
                return new DockerRunLogResponse(null, "running", "get task status...", extraOptions2, 1, null);
            }
        }
        extraOptions2.put("taskStatusFlag", "success");
        String jobStatusFlag = param.getExtraOptions().get("jobStatusFlag");
        String string2 = param.getExtraOptions().get("bcsJobName");
        if (string2 == null) {
            throw new RuntimeException("bcsJobName is null");
        }
        String jobName = string2;
        DispatchBuildStatusResp jobStatusResp = null;
        CharSequence bl = jobStatusFlag;
        if (bl == null || StringsKt.isBlank((CharSequence)bl) || Intrinsics.areEqual((Object)jobStatusFlag, (Object)"running")) {
            DispatchBuildStatusResp dispatchBuildStatusResp = new KubernetesBuildApi().getJobStatus(jobName).getData();
            Intrinsics.checkNotNull((Object)dispatchBuildStatusResp);
            jobStatusResp = dispatchBuildStatusResp;
            String jobStatus = jobStatusResp.getStatus();
            if (!(Intrinsics.areEqual((Object)"failed", (Object)jobStatus) || Intrinsics.areEqual((Object)"succeeded", (Object)jobStatus) || Intrinsics.areEqual((Object)"running", (Object)jobStatus))) {
                return new DockerRunLogResponse(null, "running", "get job status...", extraOptions2, 1, null);
            }
        }
        extraOptions2.put("jobStatusFlag", "success");
        String string3 = (String)extraOptions2.get("startTimeStamp");
        int startTimeStamp = string3 != null ? Integer.parseInt(string3) : (int)(System.currentTimeMillis() / (long)1000);
        List logs = new ArrayList();
        DispatchJobLogResp dispatchJobLogResp = new KubernetesBuildApi().getJobLogs(jobName, startTimeStamp).getData();
        Intrinsics.checkNotNull((Object)dispatchJobLogResp);
        DispatchJobLogResp logResult2 = dispatchJobLogResp;
        if (logResult2.getLog() != null && !((Collection)logResult2.getLog()).isEmpty() || !((charSequence = (CharSequence)logResult2.getErrorMsg()) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            extraOptions2.put("startTimeStamp", String.valueOf((long)startTimeStamp + param.getTimeGap()));
            it = logResult2.getLog();
            boolean bl2 = false;
            List<String> list = logResult2.getLog();
            logs.addAll(list != null ? (Collection)list : (Collection)CollectionsKt.emptyList());
            String string4 = logResult2.getErrorMsg();
            if (string4 != null) {
                String it3 = string4;
                boolean bl3 = false;
                logs.add(logResult2.getErrorMsg());
            }
        }
        if (jobStatusResp == null) {
            jobStatusResp = new KubernetesBuildApi().getJobStatus(jobName).getData();
        }
        DispatchBuildStatusResp finalStatus = jobStatusResp;
        it = new String[]{"failed", "succeeded"};
        List list = CollectionsKt.listOf((Object[])it);
        DispatchBuildStatusResp dispatchBuildStatusResp = finalStatus;
        Intrinsics.checkNotNull((Object)dispatchBuildStatusResp);
        if (list.contains(dispatchBuildStatusResp.getStatus())) {
            logger.info("final job status data: " + jobStatusResp);
            Thread.sleep(6000L);
            DispatchJobLogResp dispatchJobLogResp2 = new KubernetesBuildApi().getJobLogs(jobName, startTimeStamp + 6).getData();
            Intrinsics.checkNotNull((Object)dispatchJobLogResp2);
            DispatchJobLogResp finalLogs = dispatchJobLogResp2;
            if (Intrinsics.areEqual((Object)finalStatus.getStatus(), (Object)"failed")) {
                Collection collection = logs;
                String string5 = finalLogs.getErrorMsg();
                if (string5 == null) {
                    string5 = "";
                }
                return new DockerRunLogResponse(CollectionsKt.plus((Collection)collection, (Object)string5), "failure", "docker run fail...", extraOptions2);
            }
            Object object = finalLogs;
            return new DockerRunLogResponse(CollectionsKt.plus((Collection)logs, (Iterable)(object != null && (object = ((DispatchJobLogResp)object).getLog()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList())), "success", "docker run success...", extraOptions2);
        }
        return new DockerRunLogResponse(logs, "running", "get log...", extraOptions2);
    }

    private final DispatchJobReq getJobRequest(DockerRunRequest param) {
        String volumeServer;
        List list;
        Object element$iv2;
        DockerRunRequest $this$getJobRequest_u24lambda_u244 = param;
        boolean bl = false;
        List cmdTmp = new ArrayList();
        Iterable $this$forEach$iv = $this$getJobRequest_u24lambda_u244.getCommand();
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            String it = (String)element$iv2;
            boolean bl2 = false;
            cmdTmp.add(StringsKt.removeSuffix((String)StringsKt.removePrefix((String)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)it, (CharSequence)"\""), (CharSequence)"\""), (CharSequence)"'"), (CharSequence)"'"));
        }
        if (cmdTmp.size() == 1) {
            String[] stringArray = Commandline.translateCommandline((String)((String)CollectionsKt.first((List)cmdTmp)));
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"translateCommandline(...)");
            list = ArraysKt.toList((Object[])stringArray);
        } else {
            list = cmdTmp;
        }
        List cmd = list;
        JobParam jobParam = new JobParam($this$getJobRequest_u24lambda_u244.getEnvMap(), cmd, null, null, $this$getJobRequest_u24lambda_u244.getLabels(), $this$getJobRequest_u24lambda_u244.getIpEnabled(), 12, null);
        if (jobParam.getNfsVolume() == null && !((element$iv2 = (CharSequence)(volumeServer = System.getenv(VOLUME_SERVER))) == null || StringsKt.isBlank(element$iv2))) {
            String string = System.getenv(VOLUME_SERVER);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getenv(...)");
            jobParam.setNfsVolume(CollectionsKt.listOf((Object)new JobParam.NfsVolume(string, System.getenv(VOLUME_PATH), System.getenv(VOLUME_MOUNT_PATH))));
        }
        Pair<String, String> imagePair = INSTANCE.getImagePair(param.getImageName());
        DockerRegistry registry = new DockerRegistry((String)imagePair.getFirst(), param.getDockerLoginUsername(), param.getDockerLoginPassword());
        StringBuilder stringBuilder = new StringBuilder().append("job-").append(System.currentTimeMillis()).append('-');
        String string = RandomStringUtils.randomAlphabetic((int)8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomAlphabetic(...)");
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return new DispatchJobReq(stringBuilder.append(string2).toString(), 86400, $this$getJobRequest_u24lambda_u244.getImageName(), registry, jobParam, EnvUtils.INSTANCE.getHostName(), null, 64, null);
    }

    private final Pair<String, String> getImagePair(String imageName) {
        String[] stringArray = new String[]{"/"};
        String targetImageRepo = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)imageName, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        String targetImageName = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)imageName, (CharSequence)targetImageRepo), (CharSequence)"/");
        return new Pair((Object)targetImageRepo, (Object)targetImageName);
    }
}

