/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.plugin.docker;

import com.tencent.bk.devops.atom.utils.json.JsonUtil;
import com.tencent.bk.devops.plugin.docker.exception.DockerPullException;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunLogRequest;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunLogResponse;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunRequest;
import com.tencent.bk.devops.plugin.docker.pojo.DockerRunResponse;
import com.tencent.bk.devops.plugin.docker.utils.ParamUtils;
import com.tencent.bk.devops.plugin.script.ScriptUtils;
import com.tencent.bk.devops.plugin.utils.MachineEnvUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\u0010\u001a\u00020\r2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0015J$\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00172\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lcom/tencent/bk/devops/plugin/docker/ThirdPartExecutor;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "execute", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunResponse;", "param", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunRequest;", "doDockerRun", "", "doDockerPull", "", "getEnvVar", "envMap", "", "getLogs", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunLogResponse;", "Lcom/tencent/bk/devops/plugin/docker/pojo/DockerRunLogRequest;", "getContainerStatus", "Lkotlin/Pair;", "containerId", "workspace", "Ljava/io/File;", "dockerRm", "dockerLogin", "dockerLogout", "java-plugin-sdk"})
@SourceDebugExtension(value={"SMAP\nThirdPartExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThirdPartExecutor.kt\ncom/tencent/bk/devops/plugin/docker/ThirdPartExecutor\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,159:1\n216#2,2:160\n*S KotlinDebug\n*F\n+ 1 ThirdPartExecutor.kt\ncom/tencent/bk/devops/plugin/docker/ThirdPartExecutor\n*L\n65#1:160,2\n*E\n"})
public final class ThirdPartExecutor {
    @NotNull
    public static final ThirdPartExecutor INSTANCE = new ThirdPartExecutor();
    private static final Logger logger = LoggerFactory.getLogger(ThirdPartExecutor.class);

    private ThirdPartExecutor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final DockerRunResponse execute(@NotNull DockerRunRequest param) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        DockerRunRequest $this$execute_u24lambda_u240 = param;
        boolean bl = false;
        try {
            INSTANCE.dockerLogin($this$execute_u24lambda_u240);
            INSTANCE.doDockerPull($this$execute_u24lambda_u240);
            String containerId = INSTANCE.doDockerRun($this$execute_u24lambda_u240);
            Object object = new Pair[]{TuplesKt.to((Object)"startTimestamp", (Object)String.valueOf(System.currentTimeMillis())), TuplesKt.to((Object)"dockerContainerId", (Object)containerId)};
            object = new DockerRunResponse(MapsKt.mapOf((Pair[])object));
            return object;
        }
        finally {
            INSTANCE.dockerLogout($this$execute_u24lambda_u240);
        }
    }

    private final String doDockerRun(DockerRunRequest param) {
        String string;
        if (Intrinsics.areEqual((Object)MachineEnvUtils.INSTANCE.getOS(), (Object)"WINDOWS")) {
            StringBuilder stringBuilder = new StringBuilder().append('/');
            String string2 = param.getWorkspace().getCanonicalPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalPath(...)");
            string = stringBuilder.append(StringsKt.replace$default((String)StringsKt.replace$default((String)string2, (String)"\\", (String)"/", (boolean)false, (int)4, null), (String)":", (String)"", (boolean)false, (int)4, null)).toString();
        } else {
            string = param.getWorkspace().getCanonicalPath();
        }
        String dockerWorkspace = string;
        String command = "docker run -d -v " + dockerWorkspace + ':' + dockerWorkspace + ' ' + this.getEnvVar(param.getEnvMap()) + ' ' + param.getImageName() + ' ' + CollectionsKt.joinToString$default((Iterable)param.getCommand(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        logger.info("execute command: " + command);
        return ScriptUtils.execute$default(ScriptUtils.INSTANCE, command, param.getWorkspace(), null, null, false, false, 60, null);
    }

    private final synchronized void doDockerPull(DockerRunRequest param) {
        try {
            String pullCmd = "docker pull " + param.getImageName();
            ScriptUtils.execute$default(ScriptUtils.INSTANCE, pullCmd, param.getWorkspace(), null, null, false, false, 60, null);
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            throw new DockerPullException(string, 0, 2, null);
        }
    }

    private final String getEnvVar(Map<String, String> envMap) {
        StringBuilder command = new StringBuilder();
        Map<String, String> map = envMap;
        if (map != null) {
            Map<String, String> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> it = element$iv = iterator.next();
                boolean bl = false;
                command.append("--env " + it.getKey() + '=' + it.getValue() + ' ');
            }
        }
        String string = command.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final DockerRunLogResponse getLogs(@NotNull DockerRunLogRequest param) {
        String command;
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        String string = param.getExtraOptions().get("startTimestamp");
        if (string == null) {
            throw new RuntimeException("startTimestamp is null");
        }
        long startTimestamp = Long.parseLong(string);
        String string2 = param.getExtraOptions().get("dockerContainerId");
        if (string2 == null) {
            throw new RuntimeException("dockerContainerId is null");
        }
        String containerId = string2;
        Pair<String, String> statusPair = this.getContainerStatus(containerId, param.getWorkspace());
        String status = (String)statusPair.getFirst();
        String startTime = Intrinsics.areEqual((Object)status, (Object)"running") ? ParamUtils.INSTANCE.beiJ2UTC(startTimestamp) : (String)statusPair.getSecond();
        String preStartTime = ParamUtils.INSTANCE.beiJ2UTC(startTimestamp - param.getTimeGap());
        boolean failToGetLog = false;
        String errorMessage = "";
        try {
            command = "docker logs --until=\"" + startTime + "\" --since=\"" + preStartTime + "\" " + containerId;
            command = ScriptUtils.execute$default(ScriptUtils.INSTANCE, command, param.getWorkspace(), null, null, false, false, 44, null);
        }
        catch (Exception e) {
            String string3 = e.getMessage();
            if (string3 == null) {
                string3 = "";
            }
            errorMessage = string3;
            failToGetLog = true;
            command = "";
        }
        String log = command;
        if (!Intrinsics.areEqual((Object)status, (Object)"running")) {
            if (failToGetLog) {
                logger.error("fail to get log: " + errorMessage);
                command = "docker logs " + containerId;
                log = ScriptUtils.execute$default(ScriptUtils.INSTANCE, command, param.getWorkspace(), null, null, false, false, 12, null);
            }
            this.dockerRm(containerId, param.getWorkspace());
        }
        return new DockerRunLogResponse(CollectionsKt.listOf((Object)log), status, "get log...", MapsKt.plus(param.getExtraOptions(), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"startTimestamp", (Object)String.valueOf(startTimestamp + param.getTimeGap())))));
    }

    private final Pair<String, String> getContainerStatus(String containerId, File workspace) {
        String inspectResult = ScriptUtils.execute$default(ScriptUtils.INSTANCE, "docker inspect " + containerId, workspace, null, null, false, false, 44, null);
        Object t = JsonUtil.fromJson(inspectResult);
        Intrinsics.checkNotNullExpressionValue(t, (String)"fromJson(...)");
        Map inspectMap = (Map)CollectionsKt.first((List)((List)t));
        Object v = inspectMap.get("State");
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
        Map state = (Map)v;
        Object v2 = state.get("Status");
        Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.String");
        String status = (String)v2;
        if (Intrinsics.areEqual((Object)status, (Object)"running")) {
            return new Pair((Object)"running", (Object)"");
        }
        Object v3 = state.get("ExitCode");
        Intrinsics.checkNotNull(v3, (String)"null cannot be cast to non-null type kotlin.Int");
        int exitCode = (Integer)v3;
        Object v4 = state.get("FinishedAt");
        Intrinsics.checkNotNull(v4, (String)"null cannot be cast to non-null type kotlin.String");
        String finishedAt = (String)v4;
        return exitCode != 0 ? new Pair((Object)"failure", (Object)finishedAt) : new Pair((Object)"success", (Object)finishedAt);
    }

    private final void dockerRm(String containerId, File workspace) {
        String cmd = "docker rm " + containerId;
        logger.info("[execute script]: " + cmd);
        ScriptUtils.execute$default(ScriptUtils.INSTANCE, cmd, workspace, null, null, false, false, 28, null);
    }

    private final synchronized void dockerLogin(DockerRunRequest param) {
        CharSequence charSequence = param.getDockerLoginUsername();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        String username = param.getDockerLoginUsername();
        String password = param.getDockerLoginPassword();
        String[] stringArray = new String[]{"/"};
        String loginHost = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)param.getImageName(), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        String commandStr = "docker login " + loginHost + " --username " + username + " --password " + password;
        StringBuilder stringBuilder = new StringBuilder().append("[execute script]: ");
        String string = "docker login %s --username %s  --password ***";
        Object[] objectArray = new Object[]{loginHost, username};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        logger.info(stringBuilder.append(string2).toString());
        ScriptUtils.execute$default(ScriptUtils.INSTANCE, commandStr, param.getWorkspace(), null, null, false, false, 60, null);
    }

    private final synchronized void dockerLogout(DockerRunRequest param) {
        CharSequence charSequence = param.getDockerLoginUsername();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        String[] stringArray = new String[]{"/"};
        String loginHost = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)param.getImageName(), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        String commandStr = "docker logout " + loginHost;
        logger.info("[execute script]: " + commandStr);
        ScriptUtils.execute$default(ScriptUtils.INSTANCE, commandStr, param.getWorkspace(), null, null, false, false, 60, null);
    }
}

