/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.plugin.script;

import com.tencent.bk.devops.plugin.script.CommandLineUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JH\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00052\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0017J*\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/tencent/bk/devops/plugin/script/BatScriptUtil;", "", "<init>", "()V", "setEnv", "", "setGateValue", "GATEWAY_FILE", "WORKSPACE_ENV", "specialVariableKey", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "execute", "script", "runtimeVariables", "", "dir", "Ljava/io/File;", "prefix", "printLog", "", "failExit", "getCommandFile", "java-plugin-sdk"})
@SourceDebugExtension(value={"SMAP\nBatScriptUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BatScriptUtil.kt\ncom/tencent/bk/devops/plugin/script/BatScriptUtil\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,98:1\n216#2,2:99\n*S KotlinDebug\n*F\n+ 1 BatScriptUtil.kt\ncom/tencent/bk/devops/plugin/script/BatScriptUtil\n*L\n70#1:99,2\n*E\n"})
public final class BatScriptUtil {
    @NotNull
    public static final BatScriptUtil INSTANCE = new BatScriptUtil();
    @NotNull
    private static final String setEnv = ":setEnv\r\n    set file_save_dir=\"##resultFile##\"\r\n    echo %~1=%~2 >>%file_save_dir%\r\n    set %~1=%~2\r\n    goto:eof\r\n";
    @NotNull
    private static final String setGateValue = ":setGateValue\r\n    set file_save_dir=\"##gateValueFile##\"\r\n    echo %~1=%~2 >>%file_save_dir%\r\n    set %~1=%~2\r\n    goto:eof\r\n";
    @NotNull
    private static final String GATEWAY_FILE = "gatewayValueFile.ini";
    @NotNull
    private static final String WORKSPACE_ENV = "WORKSPACE";
    @NotNull
    private static final Set<String> specialVariableKey;
    private static final Logger logger;

    private BatScriptUtil() {
    }

    @NotNull
    public final String execute(@NotNull String script, @NotNull Map<String, String> runtimeVariables, @NotNull File dir, @NotNull String prefix, boolean printLog, boolean failExit) {
        String string;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter(runtimeVariables, (String)"runtimeVariables");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        File file = this.getCommandFile(script, dir, runtimeVariables);
        try {
            string = CommandLineUtils.execute$default(CommandLineUtils.INSTANCE, "cmd.exe /C \"" + file.getCanonicalPath() + '\"', dir, printLog, prefix, false, 16, null);
        }
        catch (Throwable e) {
            if (failExit) {
                throw e;
            }
            String string2 = e.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            string = string2;
        }
        return string;
    }

    public static /* synthetic */ String execute$default(BatScriptUtil batScriptUtil, String string, Map map, File file, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = "";
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        return batScriptUtil.execute(string, map, file, string2, bl, bl2);
    }

    @NotNull
    public final File getCommandFile(@NotNull String script, @NotNull File dir, @NotNull Map<String, String> runtimeVariables) {
        File file;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(runtimeVariables, (String)"runtimeVariables");
        String tmpDir = System.getProperty("java.io.tmpdir");
        CharSequence charSequence = tmpDir;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            file = File.createTempFile("paas_build_script_", ".bat");
        } else {
            new File(tmpDir).mkdirs();
            file = File.createTempFile("paas_build_script_", ".bat", new File(tmpDir));
        }
        File file2 = file;
        file2.deleteOnExit();
        StringBuilder command = new StringBuilder();
        command.append("@echo off").append("\r\n").append("set WORKSPACE=" + dir.getAbsolutePath() + "\r\n").append("set DEVOPS_BUILD_SCRIPT_FILE=" + file2.getAbsolutePath() + "\r\n").append("\r\n");
        Map<String, String> $this$forEach$iv = runtimeVariables;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String name = entry.getKey();
            String value = entry.getValue();
            if (specialVariableKey.contains(name)) continue;
            String clean = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)value, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null), (String)"&", (String)"^&", (boolean)false, (int)4, null), (String)"<", (String)"^<", (boolean)false, (int)4, null), (String)">", (String)"^>", (boolean)false, (int)4, null), (String)"|", (String)"^|", (boolean)false, (int)4, null);
            command.append("set " + name + "=\"" + clean + "\"\r\n");
            command.append("set " + name + "=%" + name + ":~1,-1%\r\n");
        }
        StringBuilder stringBuilder = command.append(StringsKt.replace$default((String)script, (String)"\n", (String)"\r\n", (boolean)false, (int)4, null)).append("\r\n").append("exit").append("\r\n");
        String string = new File(dir, "result.log").getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        StringBuilder stringBuilder2 = stringBuilder.append(StringsKt.replace$default((String)setEnv, (String)"##resultFile##", (String)string, (boolean)false, (int)4, null));
        String string2 = new File(dir, GATEWAY_FILE).getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalPath(...)");
        stringBuilder2.append(StringsKt.replace$default((String)setGateValue, (String)"##gateValueFile##", (String)string2, (boolean)false, (int)4, null));
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkNotNull((Object)file2);
        String string3 = command.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        Intrinsics.checkNotNull((Object)charset);
        FilesKt.writeText((File)file2, (String)string3, (Charset)charset);
        return file2;
    }

    static {
        Object[] objectArray = new String[]{"languageRuleSetMap", "script", "tools"};
        specialVariableKey = SetsKt.setOf((Object[])objectArray);
        logger = LoggerFactory.getLogger(BatScriptUtil.class);
    }
}

