/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.plugin.script;

import com.tencent.bk.devops.plugin.script.CommandLineExecutor;
import com.tencent.bk.devops.plugin.script.SensitiveLineParser;
import java.io.File;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.PumpStreamHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\t2\b\b\u0002\u0010\u0010\u001a\u00020\u000eR\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/tencent/bk/devops/plugin/script/CommandLineUtils;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "execute", "", "command", "workspace", "Ljava/io/File;", "print2Logger", "", "prefix", "printException", "java-plugin-sdk"})
public final class CommandLineUtils {
    @NotNull
    public static final CommandLineUtils INSTANCE = new CommandLineUtils();
    private static final Logger logger = LoggerFactory.getLogger(CommandLineUtils.class);

    private CommandLineUtils() {
    }

    @NotNull
    public final String execute(@NotNull String command, @Nullable File workspace, boolean print2Logger, @NotNull String prefix, boolean printException) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        StringBuffer result = new StringBuffer();
        CommandLine cmdLine = CommandLine.parse((String)command);
        CommandLineExecutor executor = new CommandLineExecutor();
        if (workspace != null) {
            executor.setWorkingDirectory(workspace);
        }
        LogOutputStream outputStream2 = new LogOutputStream(prefix, print2Logger, result){
            final /* synthetic */ String $prefix;
            final /* synthetic */ boolean $print2Logger;
            final /* synthetic */ StringBuffer $result;
            {
                this.$prefix = $prefix;
                this.$print2Logger = $print2Logger;
                this.$result = $result;
            }

            protected void processLine(String line, int level) {
                if (line == null) {
                    return;
                }
                String tmpLine = SensitiveLineParser.INSTANCE.onParseLine(this.$prefix + line);
                if (this.$print2Logger) {
                    CommandLineUtils.access$getLogger$p().info(tmpLine);
                }
                this.$result.append(tmpLine).append("\n");
            }
        };
        LogOutputStream errorStream2 = new LogOutputStream(prefix, print2Logger, result){
            final /* synthetic */ String $prefix;
            final /* synthetic */ boolean $print2Logger;
            final /* synthetic */ StringBuffer $result;
            {
                this.$prefix = $prefix;
                this.$print2Logger = $print2Logger;
                this.$result = $result;
            }

            protected void processLine(String line, int level) {
                if (line == null) {
                    return;
                }
                String tmpLine = SensitiveLineParser.INSTANCE.onParseLine(this.$prefix + line);
                if (this.$print2Logger) {
                    CommandLineUtils.access$getLogger$p().error(tmpLine);
                }
                this.$result.append(tmpLine).append("\n");
            }
        };
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)outputStream2, (OutputStream)errorStream2));
        try {
            int exitCode = executor.execute(cmdLine);
            if (exitCode != 0) {
                throw new RuntimeException(prefix + " Script command execution failed with exit code(" + exitCode + ')');
            }
        }
        catch (Throwable t) {
            if (printException) {
                logger.warn("Fail to execute the command(" + command + ')', t);
            }
            if (print2Logger) {
                logger.error(prefix + " Fail to execute the command(" + command + "): " + t.getMessage());
            }
            throw t;
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String execute$default(CommandLineUtils commandLineUtils, String string, File file, boolean bl, String string2, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = "";
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return commandLineUtils.execute(string, file, bl, string2, bl2);
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }
}

