/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.plugin.script;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nR\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\b\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\f\u001a\n \u0006*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/tencent/bk/devops/plugin/script/SensitiveLineParser;", "", "<init>", "()V", "pattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "patternPassword", "onParseLine", "", "line", "logger", "Lorg/slf4j/Logger;", "Lorg/slf4j/Logger;", "java-plugin-sdk"})
public final class SensitiveLineParser {
    @NotNull
    public static final SensitiveLineParser INSTANCE = new SensitiveLineParser();
    private static final Pattern pattern = Pattern.compile("oauth2:(\\w+)@");
    private static final Pattern patternPassword = Pattern.compile("http://.*:.*@");
    private static final Logger logger = LoggerFactory.getLogger(SensitiveLineParser.class);

    private SensitiveLineParser() {
    }

    @NotNull
    public final String onParseLine(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (StringsKt.contains$default((CharSequence)line, (CharSequence)"http://oauth2:", (boolean)false, (int)2, null)) {
            Matcher matcher = pattern.matcher(line);
            String replace = matcher.replaceAll("oauth2:***@");
            logger.info("Parse the line from " + line + " to " + replace);
            Intrinsics.checkNotNull((Object)replace);
            return replace;
        }
        if (StringsKt.contains$default((CharSequence)line, (CharSequence)"http://", (boolean)false, (int)2, null)) {
            String string = patternPassword.matcher(line).replaceAll("http://***:***@");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replaceAll(...)");
            return string;
        }
        return line;
    }
}

