/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.plugin.script;

import com.tencent.bk.devops.plugin.script.CommandLineUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JD\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ4\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00172\b\b\u0002\u0010\u001b\u001a\u00020\u001aJ6\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00152\b\b\u0002\u0010\u0018\u001a\u00020\u00052\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001aH\u0002J\u0018\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006#"}, d2={"Lcom/tencent/bk/devops/plugin/script/ShellUtil;", "", "<init>", "()V", "setEnv", "", "setGateValue", "GATEWAY_FILE", "specialKey", "", "specialValue", "specialCharToReplace", "Lkotlin/text/Regex;", "WORKSPACE_ENV", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "execute", "script", "dir", "Ljava/io/File;", "runtimeVariables", "", "prefix", "printLog", "", "failExit", "getCommandFile", "executeUnixCommand", "command", "sourceDir", "specialEnv", "key", "value", "java-plugin-sdk"})
@SourceDebugExtension(value={"SMAP\nShellUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellUtil.kt\ncom/tencent/bk/devops/plugin/script/ShellUtil\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n535#2:137\n520#2,6:138\n216#3,2:144\n1863#4,2:146\n1863#4,2:148\n*S KotlinDebug\n*F\n+ 1 ShellUtil.kt\ncom/tencent/bk/devops/plugin/script/ShellUtil\n*L\n84#1:137\n84#1:138,6\n88#1:144,2\n122#1:146,2\n128#1:148,2\n*E\n"})
public final class ShellUtil {
    @NotNull
    public static final ShellUtil INSTANCE = new ShellUtil();
    @NotNull
    private static final String setEnv = "setEnv(){\n        local key=$1\n        local val=$2\n\n        if [[ -z \"$@\" ]]; then\n            return 0\n        fi\n\n        if ! echo \"$key\" | grep -qE \"^[a-zA-Z_][a-zA-Z0-9_]*$\"; then\n            echo \"[$key] is invalid\" >&2\n            return 1\n        fi\n\n        echo $key=$val  >> ##resultFile##\n        export $key=\"$val\"\n    }\n";
    @NotNull
    private static final String setGateValue = "setGateValue(){\n        local key=$1\n        local val=$2\n\n        if [[ -z \"$@\" ]]; then\n            return 0\n        fi\n\n        if ! echo \"$key\" | grep -qE \"^[a-zA-Z_][a-zA-Z0-9_]*$\"; then\n            echo \"[$key] is invalid\" >&2\n            return 1\n        fi\n\n        echo $key=$val  >> ##gateValueFile##\n    }\n";
    @NotNull
    public static final String GATEWAY_FILE = "gatewayValueFile.ini";
    @NotNull
    private static final List<String> specialKey;
    @NotNull
    private static final List<String> specialValue;
    @NotNull
    private static final Regex specialCharToReplace;
    @NotNull
    private static final String WORKSPACE_ENV = "WORKSPACE";
    private static final Logger logger;

    private ShellUtil() {
    }

    @NotNull
    public final String execute(@NotNull String script, @NotNull File dir, @NotNull Map<String, String> runtimeVariables, @NotNull String prefix, boolean printLog, boolean failExit) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(runtimeVariables, (String)"runtimeVariables");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        String string = ShellUtil.getCommandFile$default(this, script, dir, runtimeVariables, false, 8, null).getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalPath(...)");
        return this.executeUnixCommand(string, dir, prefix, printLog, failExit);
    }

    public static /* synthetic */ String execute$default(ShellUtil shellUtil, String string, File file, Map map, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = "";
        }
        return shellUtil.execute(string, file, map, string2, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final File getCommandFile(@NotNull String script, @NotNull File dir, @NotNull Map<String, String> runtimeVariables, boolean failExit) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(runtimeVariables, (String)"runtimeVariables");
        File file = Files.createTempFile("devops_script", ".sh", new FileAttribute[0]).toFile();
        file.deleteOnExit();
        StringBuilder command = new StringBuilder();
        String[] stringArray = new String[]{"\n"};
        String bashStr = (String)StringsKt.split$default((CharSequence)script, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
        if (StringsKt.startsWith$default((String)bashStr, (String)"#!/", (boolean)false, (int)2, null)) {
            command.append(bashStr).append("\n");
        }
        command.append("export WORKSPACE=" + dir.getAbsolutePath() + '\n').append("export DEVOPS_BUILD_SCRIPT_FILE=" + file.getAbsolutePath() + '\n');
        Map<String, String> $this$filter$iv = runtimeVariables;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(!INSTANCE.specialEnv((String)it.getKey(), (String)it.getValue()))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map commonEnv = destination$iv$iv;
        if (!commonEnv.isEmpty()) {
            Map $this$forEach$iv = commonEnv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = (Map.Entry)object.next();
                boolean bl = false;
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                CharSequence charSequence = value;
                Regex regex = specialCharToReplace;
                String string = "";
                String clean = regex.replace(charSequence, string);
                command.append("export " + name + "='" + clean + "'\n");
            }
        }
        String string = new File(dir, "result.log").getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        command.append(StringsKt.replace$default((String)setEnv, (String)"##resultFile##", (String)string, (boolean)false, (int)4, null));
        String string2 = new File(dir, GATEWAY_FILE).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        command.append(StringsKt.replace$default((String)setGateValue, (String)"##gateValueFile##", (String)string2, (boolean)false, (int)4, null));
        command.append(script);
        Intrinsics.checkNotNull((Object)file);
        String string3 = command.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        FilesKt.writeText$default((File)file, (String)string3, null, (int)2, null);
        ShellUtil.executeUnixCommand$default(this, "chmod +x " + file.getAbsolutePath(), dir, null, false, failExit, 12, null);
        return file;
    }

    public static /* synthetic */ File getCommandFile$default(ShellUtil shellUtil, String string, File file, Map map, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return shellUtil.getCommandFile(string, file, map, bl);
    }

    private final String executeUnixCommand(String command, File sourceDir, String prefix, boolean printLog, boolean failExit) {
        String string;
        try {
            string = CommandLineUtils.execute$default(CommandLineUtils.INSTANCE, command, sourceDir, printLog, prefix, false, 16, null);
        }
        catch (Throwable ignored) {
            logger.error("Fail to run the command " + command + " because of error(" + ignored.getMessage() + ')');
            if (failExit) {
                throw ignored;
            }
            String string2 = ignored.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            string = string2;
        }
        return string;
    }

    static /* synthetic */ String executeUnixCommand$default(ShellUtil shellUtil, String string, File file, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        return shellUtil.executeUnixCommand(string, file, string2, bl, bl2);
    }

    private final boolean specialEnv(String key, String value) {
        String it;
        Iterable $this$forEach$iv = specialKey;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)key, (CharSequence)it, (boolean)false, (int)2, null)) continue;
            return true;
        }
        $this$forEach$iv = specialValue;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)value, (CharSequence)it, (boolean)false, (int)2, null)) continue;
            return true;
        }
        return false;
    }

    static {
        Object[] objectArray = new String[]{".", "-"};
        specialKey = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"|", "&", "(", ")"};
        specialValue = CollectionsKt.listOf((Object[])objectArray);
        specialCharToReplace = new Regex("['\n]");
        logger = LoggerFactory.getLogger(ShellUtil.class);
    }
}

