/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.plugin.utils;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.google.common.collect.Maps;
import com.tencent.bk.devops.atom.utils.json.annotation.SkipLogField;
import com.tencent.bk.devops.plugin.utils.ReflectUtil;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\u0005J\u001f\u0010\u000b\u001a\u0004\u0018\u00010\n\"\b\b\u0000\u0010\f*\u00020\u00012\u0006\u0010\r\u001a\u0002H\f\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0001J\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\r\u001a\u00020\u0001J\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u0010\r\u001a\u00020\u0001J\u0019\u0010\u0013\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\u0014\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0015J'\u0010\u0013\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\u0014\u001a\u00020\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\f0\u0017\u00a2\u0006\u0002\u0010\u0018J'\u0010\u0013\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\u0014\u001a\u00020\n2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\f0\u001a\u00a2\u0006\u0002\u0010\u001bJ+\u0010\u001c\u001a\u0004\u0018\u0001H\f\"\u0004\b\u0000\u0010\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\n2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\f0\u001a\u00a2\u0006\u0002\u0010\u001bJ3\u0010\u001d\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\f0\u001a\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/tencent/bk/devops/plugin/utils/JsonUtil;", "", "<init>", "()V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "skipEmptyObjectMapper", "getObjectMapper", "jsonMappers", "", "", "skipLogFields", "T", "bean", "(Ljava/lang/Object;)Ljava/lang/String;", "toJson", "toMutableMapSkipEmpty", "toMap", "", "to", "json", "(Ljava/lang/String;)Ljava/lang/Object;", "typeReference", "Lcom/fasterxml/jackson/core/type/TypeReference;", "(Ljava/lang/String;Lcom/fasterxml/jackson/core/type/TypeReference;)Ljava/lang/Object;", "type", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "toOrNull", "mapTo", "map", "(Ljava/util/Map;Ljava/lang/Class;)Ljava/lang/Object;", "java-plugin-sdk"})
public final class JsonUtil {
    @NotNull
    public static final JsonUtil INSTANCE;
    @NotNull
    private static final ObjectMapper objectMapper;
    @NotNull
    private static final ObjectMapper skipEmptyObjectMapper;
    @NotNull
    private static final Map<String, ObjectMapper> jsonMappers;

    private JsonUtil() {
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    @Nullable
    public final <T> String skipLogFields(@NotNull T bean) {
        Intrinsics.checkNotNullParameter(bean, (String)"bean");
        return jsonMappers.computeIfAbsent("__skipLogFields__" + bean.getClass().getName(), arg_0 -> JsonUtil.skipLogFields$lambda$3(arg_0 -> JsonUtil.skipLogFields$lambda$2(bean, arg_0), arg_0)).writeValueAsString(bean);
    }

    @NotNull
    public final String toJson(@NotNull Object bean) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        if (ReflectUtil.INSTANCE.isNativeType(bean) || bean instanceof String) {
            return bean.toString();
        }
        String string = this.getObjectMapper().writeValueAsString(bean);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public final Map<String, Object> toMutableMapSkipEmpty(@NotNull Object bean) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        if (ReflectUtil.INSTANCE.isNativeType(bean)) {
            return new LinkedHashMap();
        }
        if (bean instanceof String) {
            Object object = skipEmptyObjectMapper.readValue(((String)bean).toString(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
            map = (Map)object;
        } else {
            Object object = skipEmptyObjectMapper.readValue(skipEmptyObjectMapper.writeValueAsString(bean), (TypeReference)new TypeReference<Map<String, Object>>(){});
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
            map = (Map)object;
        }
        return map;
    }

    @NotNull
    public final Map<String, Object> toMap(@NotNull Object bean) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        if (ReflectUtil.INSTANCE.isNativeType(bean)) {
            map = MapsKt.emptyMap();
        } else if (bean instanceof String) {
            map = (Map)this.to((String)bean);
        } else {
            String string = this.getObjectMapper().writeValueAsString(bean);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
            map = (Map)this.to(string);
        }
        return map;
    }

    public final <T> T to(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return (T)this.getObjectMapper().readValue(json, new TypeReference<T>(){});
    }

    public final <T> T to(@NotNull String json, @NotNull TypeReference<T> typeReference) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(typeReference, (String)"typeReference");
        return (T)this.getObjectMapper().readValue(json, typeReference);
    }

    public final <T> T to(@NotNull String json, @NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return (T)this.getObjectMapper().readValue(json, type);
    }

    @Nullable
    public final <T> T toOrNull(@Nullable String json, @NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        CharSequence charSequence = json;
        return (T)(charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : this.getObjectMapper().readValue(json, type));
    }

    public final <T> T mapTo(@NotNull Map<String, ? extends Object> map, @NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return (T)this.getObjectMapper().readValue(this.getObjectMapper().writeValueAsString(map), type);
    }

    private static final ObjectMapper skipLogFields$lambda$2(Object $bean, String s) {
        Intrinsics.checkNotNullParameter((Object)$bean, (String)"$bean");
        ObjectMapper nonEmptyMapper = new ObjectMapper();
        Set skipFields = new HashSet();
        for (Class<?> aClass = $bean.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            Object[] fields = aClass.getDeclaredFields();
            Iterator iterator = ArrayIteratorKt.iterator((Object[])fields);
            while (iterator.hasNext()) {
                boolean bl;
                SkipLogField fieldAnnotation;
                Field field = (Field)iterator.next();
                if (field.getAnnotation(SkipLogField.class) == null) continue;
                if (((CharSequence)((Object)StringsKt.trim((CharSequence)fieldAnnotation.value())).toString()).length() > 0) {
                    bl = skipFields.add(fieldAnnotation.value());
                    continue;
                }
                String string = field.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                bl = skipFields.add(string);
            }
        }
        if (!((Collection)skipFields).isEmpty()) {
            nonEmptyMapper.addMixIn($bean.getClass(), SkipLogField.class);
            SimpleFilterProvider simpleFilterProvider = new SimpleFilterProvider().addFilter(SkipLogField.class.getAnnotation(JsonFilter.class).value(), SimpleBeanPropertyFilter.serializeAllExcept((Set)skipFields));
            Intrinsics.checkNotNullExpressionValue((Object)simpleFilterProvider, (String)"addFilter(...)");
            FilterProvider filterProvider = (FilterProvider)simpleFilterProvider;
            nonEmptyMapper.setFilterProvider(filterProvider);
        }
        return nonEmptyMapper;
    }

    private static final ObjectMapper skipLogFields$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ObjectMapper)$tmp0.invoke(p0);
    }

    static {
        ObjectMapper objectMapper;
        INSTANCE = new JsonUtil();
        ObjectMapper $this$objectMapper_u24lambda_u240 = objectMapper = new ObjectMapper();
        boolean bl = false;
        $this$objectMapper_u24lambda_u240.registerModule((Module)new KotlinModule(0, false, false, false, null, false, 63, null));
        $this$objectMapper_u24lambda_u240.configure(SerializationFeature.INDENT_OUTPUT, true);
        $this$objectMapper_u24lambda_u240.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        $this$objectMapper_u24lambda_u240.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        $this$objectMapper_u24lambda_u240.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        $this$objectMapper_u24lambda_u240.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        $this$objectMapper_u24lambda_u240.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        JsonUtil.objectMapper = objectMapper;
        ObjectMapper $this$skipEmptyObjectMapper_u24lambda_u241 = objectMapper = new ObjectMapper();
        boolean bl2 = false;
        $this$skipEmptyObjectMapper_u24lambda_u241.registerModule((Module)new KotlinModule(0, false, false, false, null, false, 63, null));
        $this$skipEmptyObjectMapper_u24lambda_u241.configure(SerializationFeature.INDENT_OUTPUT, true);
        $this$skipEmptyObjectMapper_u24lambda_u241.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        $this$skipEmptyObjectMapper_u24lambda_u241.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        $this$skipEmptyObjectMapper_u24lambda_u241.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        $this$skipEmptyObjectMapper_u24lambda_u241.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        $this$skipEmptyObjectMapper_u24lambda_u241.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        skipEmptyObjectMapper = objectMapper;
        ConcurrentMap concurrentMap = Maps.newConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"newConcurrentMap(...)");
        jsonMappers = concurrentMap;
    }
}

