/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bk.devops.plugin.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ConnectionPool;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0013J$\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0013J,\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000e2\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0013J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fJ,\u0010!\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000e2\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0013J&\u0010#\u001a\u00020$2\u0006\u0010\u0011\u001a\u00020\u000e2\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0013H\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/tencent/bk/devops/plugin/utils/OkhttpUtils;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "okHttpClient", "Lokhttp3/OkHttpClient;", "shortOkHttpClient", "noRetryShortOkHttpClient", "noRetryOkHttpClient", "CONTENT_TYPE_JSON", "", "doShortGet", "Lokhttp3/Response;", "url", "headers", "", "doGet", "client", "doShortHttp", "request", "Lokhttp3/Request;", "doShortHttpNoRetry", "doHttp", "doHttpNoRetry", "downloadFile", "", "destPath", "Ljava/io/File;", "response", "doPost", "jsonParam", "getBuilder", "Lokhttp3/Request$Builder;", "java-plugin-sdk"})
public final class OkhttpUtils {
    @NotNull
    public static final OkhttpUtils INSTANCE = new OkhttpUtils();
    private static final Logger logger = LoggerFactory.getLogger(OkhttpUtils.class);
    @NotNull
    private static final OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.MINUTES).writeTimeout(30L, TimeUnit.MINUTES).connectionPool(new ConnectionPool(64, 5L, TimeUnit.MINUTES)).build();
    @NotNull
    private static final OkHttpClient shortOkHttpClient = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).connectionPool(new ConnectionPool(64, 5L, TimeUnit.MINUTES)).build();
    @NotNull
    private static final OkHttpClient noRetryShortOkHttpClient = new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).connectionPool(new ConnectionPool(64, 5L, TimeUnit.MINUTES)).retryOnConnectionFailure(false).build();
    @NotNull
    private static final OkHttpClient noRetryOkHttpClient = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.MINUTES).writeTimeout(30L, TimeUnit.MINUTES).connectionPool(new ConnectionPool(64, 5L, TimeUnit.MINUTES)).retryOnConnectionFailure(false).build();
    @NotNull
    private static final String CONTENT_TYPE_JSON = "application/json; charset=utf-8";

    private OkhttpUtils() {
    }

    @NotNull
    public final Response doShortGet(@NotNull String url, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        return this.doGet(shortOkHttpClient, url, headers);
    }

    public static /* synthetic */ Response doShortGet$default(OkhttpUtils okhttpUtils, String string, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        return okhttpUtils.doShortGet(string, map);
    }

    @NotNull
    public final Response doGet(@NotNull String url, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        return this.doGet(okHttpClient, url, headers);
    }

    public static /* synthetic */ Response doGet$default(OkhttpUtils okhttpUtils, String string, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        return okhttpUtils.doGet(string, map);
    }

    @NotNull
    public final Response doGet(@NotNull OkHttpClient client, @NotNull String url, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Request.Builder requestBuilder = new Request.Builder().url(url).get();
        if (!headers.isEmpty()) {
            headers.forEach((arg_0, arg_1) -> OkhttpUtils.doGet$lambda$1((arg_0, arg_1) -> OkhttpUtils.doGet$lambda$0(requestBuilder, arg_0, arg_1), arg_0, arg_1));
        }
        Request request = requestBuilder.build();
        return client.newCall(request).execute();
    }

    public static /* synthetic */ Response doGet$default(OkhttpUtils okhttpUtils, OkHttpClient okHttpClient, String string, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return okhttpUtils.doGet(okHttpClient, string, map);
    }

    @NotNull
    public final Response doShortHttp(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return shortOkHttpClient.newCall(request).execute();
    }

    @NotNull
    public final Response doShortHttpNoRetry(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return noRetryShortOkHttpClient.newCall(request).execute();
    }

    @NotNull
    public final Response doHttp(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return okHttpClient.newCall(request).execute();
    }

    @NotNull
    public final Response doHttpNoRetry(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return noRetryOkHttpClient.newCall(request).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void downloadFile(@NotNull String url, @NotNull File destPath) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)destPath, (String)"destPath");
        Request request = new Request.Builder().url(url).get().build();
        Closeable closeable = (Closeable)okHttpClient.newCall(request).execute();
        Throwable throwable = null;
        try {
            Response response = (Response)closeable;
            boolean bl = false;
            if (response.code() == 404) {
                logger.warn("The file " + url + " is not exist");
                throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            if (!response.isSuccessful()) {
                logger.warn("fail to download the file from " + url + " because of " + response.message() + " and code " + response.code());
                throw new RuntimeException("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25");
            }
            if (!destPath.getParentFile().exists()) {
                destPath.getParentFile().mkdirs();
            }
            byte[] buf = new byte[4096];
            ResponseBody responseBody = response.body();
            Intrinsics.checkNotNull((Object)responseBody);
            Closeable closeable2 = responseBody.byteStream();
            Throwable throwable2 = null;
            try {
                InputStream bs = (InputStream)closeable2;
                boolean bl2 = false;
                int len = 0;
                len = bs.read(buf);
                Closeable closeable3 = new FileOutputStream(destPath);
                Throwable throwable3 = null;
                try {
                    FileOutputStream fos = (FileOutputStream)closeable3;
                    boolean bl3 = false;
                    while (len != -1) {
                        fos.write(buf, 0, len);
                        len = bs.read(buf);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void downloadFile(@NotNull Response response, @NotNull File destPath) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)destPath, (String)"destPath");
        if (response.code() == 304) {
            logger.info("file is newest, do not download to " + destPath);
            return;
        }
        if (!response.isSuccessful()) {
            logger.warn("fail to download the file because of " + response.message() + " and code " + response.code());
            throw new RuntimeException("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25");
        }
        if (!destPath.getParentFile().exists()) {
            destPath.getParentFile().mkdirs();
        }
        byte[] buf = new byte[4096];
        ResponseBody responseBody = response.body();
        Intrinsics.checkNotNull((Object)responseBody);
        Closeable closeable = responseBody.byteStream();
        Throwable throwable = null;
        try {
            InputStream bs = (InputStream)closeable;
            boolean bl = false;
            int len = 0;
            len = bs.read(buf);
            Closeable closeable2 = new FileOutputStream(destPath);
            Throwable throwable2 = null;
            try {
                FileOutputStream fos = (FileOutputStream)closeable2;
                boolean bl2 = false;
                while (len != -1) {
                    fos.write(buf, 0, len);
                    len = bs.read(buf);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final Response doPost(@NotNull String url, @NotNull String jsonParam, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)jsonParam, (String)"jsonParam");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Request.Builder builder = this.getBuilder(url, headers);
        RequestBody body = RequestBody.Companion.create(MediaType.Companion.parse(CONTENT_TYPE_JSON), jsonParam);
        Request request = builder.post(body).build();
        return this.doHttp(request);
    }

    public static /* synthetic */ Response doPost$default(OkhttpUtils okhttpUtils, String string, String string2, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return okhttpUtils.doPost(string, string2, map);
    }

    private final Request.Builder getBuilder(String url, Map<String, String> headers) {
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        if (headers != null) {
            builder.headers(Headers.Companion.of(headers));
        }
        return builder;
    }

    private static final Unit doGet$lambda$0(Request.Builder $requestBuilder, String key, String value) {
        Intrinsics.checkNotNullParameter((Object)$requestBuilder, (String)"$requestBuilder");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $requestBuilder.addHeader(key, value);
        return Unit.INSTANCE;
    }

    private static final void doGet$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }
}

