/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api;

import com.testdroid.api.APIArray;
import com.testdroid.api.APIClient;
import com.testdroid.api.APIException;
import com.testdroid.api.APIExceptionMessage;
import com.testdroid.api.APIList;
import com.testdroid.api.APIListResource;
import com.testdroid.api.APIQueryBuilder;
import com.testdroid.api.APIResource;
import com.testdroid.api.APISort;
import com.testdroid.api.APIView;
import com.testdroid.api.model.APIConnection;
import com.testdroid.api.model.APIDevice;
import com.testdroid.api.model.APIDeviceGroup;
import com.testdroid.api.model.APIDeviceProperty;
import com.testdroid.api.model.APIDeviceRun;
import com.testdroid.api.model.APIDeviceRunDataAvailability;
import com.testdroid.api.model.APIDeviceRunState;
import com.testdroid.api.model.APIDeviceSession;
import com.testdroid.api.model.APIDeviceSessionStep;
import com.testdroid.api.model.APIDeviceTimeEntry;
import com.testdroid.api.model.APIFileSet;
import com.testdroid.api.model.APIFiles;
import com.testdroid.api.model.APILabelGroup;
import com.testdroid.api.model.APINotificationEmail;
import com.testdroid.api.model.APIProject;
import com.testdroid.api.model.APIProjectJobConfig;
import com.testdroid.api.model.APIProjectSharing;
import com.testdroid.api.model.APIRecorderOnlineSession;
import com.testdroid.api.model.APIRole;
import com.testdroid.api.model.APIScreenshot;
import com.testdroid.api.model.APISoftwareVersion;
import com.testdroid.api.model.APITag;
import com.testdroid.api.model.APITestCaseRun;
import com.testdroid.api.model.APITestCaseRunStep;
import com.testdroid.api.model.APITestRun;
import com.testdroid.api.model.APITestRunConfig;
import com.testdroid.api.model.APITestRunDataAvailability;
import com.testdroid.api.model.APITestRunExtended;
import com.testdroid.api.model.APITestRunParameter;
import com.testdroid.api.model.APIUser;
import com.testdroid.api.model.APIUserDeviceTime;
import com.testdroid.api.model.APIUserFile;
import com.testdroid.api.model.APIUserFileProperty;
import com.testdroid.api.model.APIUserFileTag;
import com.testdroid.api.model.AndroidFiles;
import com.testdroid.api.model.AppiumAndroidFiles;
import com.testdroid.api.model.AppiumIOSFiles;
import com.testdroid.api.model.CalabashFiles;
import com.testdroid.api.model.CalabashIOSFiles;
import com.testdroid.api.model.IOSFiles;
import com.testdroid.api.model.RecorderOnlineFiles;
import com.testdroid.api.model.RemoteControlFiles;
import com.testdroid.api.model.UIAutomatorFiles;
import com.testdroid.api.model.jrjc.APIBasicJiraIssue;
import com.testdroid.api.model.jrjc.APIBasicJiraProject;
import com.testdroid.api.model.jrjc.APIJiraAccount;
import com.testdroid.api.model.jrjc.APIJiraIssue;
import com.testdroid.api.model.jrjc.APIJiraIssueType;
import com.testdroid.api.model.jrjc.APIJiraPriority;
import com.testdroid.api.model.jrjc.APIJiraProject;
import com.testdroid.api.model.jrjc.APIJiraServerInfo;
import com.testdroid.api.um.model.APIUserService;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonView;

@XmlRootElement(namespace="com.testdroid.api")
@XmlSeeAlso(value={APIArray.class, APIConnection.class, APIDevice.class, APIDeviceGroup.class, APIDeviceProperty.class, APIDeviceRun.class, APIDeviceRunState.class, APIDeviceSession.class, APIDeviceSessionStep.class, APIExceptionMessage.class, APIFiles.class, APIFiles.AndroidAppFile.class, APIFiles.AndroidTestFile.class, APIFiles.APIFile.class, APIFiles.CalabashTestFile.class, APIFiles.DataFile.class, APIFiles.IOSAppFile.class, APIFiles.IOSTestFile.class, APIFiles.UIAutomatorTestFile.class, APIFileSet.class, APILabelGroup.class, APIList.class, APINotificationEmail.class, APIProject.class, APIProjectJobConfig.class, APIProjectSharing.class, APIRecorderOnlineSession.class, APIRole.class, APIScreenshot.class, APISoftwareVersion.class, APITag.class, APITestCaseRun.class, APITestCaseRunStep.class, APITestRun.class, APITestRunConfig.class, APITestRunExtended.class, APITestRunParameter.class, APIUser.class, APIUserFile.class, APIUserFileProperty.class, APIUserFileTag.class, AndroidFiles.class, CalabashFiles.class, CalabashIOSFiles.class, AppiumAndroidFiles.class, AppiumIOSFiles.class, IOSFiles.class, RecorderOnlineFiles.class, RemoteControlFiles.class, UIAutomatorFiles.class, APIUserService.class, APIBasicJiraProject.class, APIBasicJiraIssue.class, APIJiraAccount.class, APIJiraIssue.class, APIJiraIssueType.class, APIJiraPriority.class, APIJiraProject.class, APIJiraServerInfo.class, APIDeviceRunDataAvailability.class, APITestRunDataAvailability.class, APIUserDeviceTime.class, APIDeviceTimeEntry.class})
public abstract class APIEntity {
    private static final DateFormat API_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH:mm");
    private static final HashMap<Class, JAXBContext> contextMap = new HashMap();
    protected APIClient client;
    protected Long id;
    protected String selfURI;
    protected Class<? extends APIView> view;

    public APIEntity() {
    }

    public APIEntity(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public static String format(Date date) {
        return API_DATE_FORMAT.format(date);
    }

    @JsonIgnore
    public static <T extends APIEntity> T fromXML(String xml, Class<T> type) {
        try {
            JAXBContext context = APIEntity.getJAXBContext(type);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            return (T)((APIEntity)unmarshaller.unmarshal((Reader)new StringReader(xml)));
        }
        catch (JAXBException ex) {
            Logger.getLogger(APIEntity.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @JsonIgnore
    public static JAXBContext getJAXBContext(Class type) throws JAXBException {
        JAXBContext context = contextMap.get(type);
        if (context == null) {
            context = JAXBContext.newInstance((Class[])new Class[]{type});
            contextMap.put(type, context);
            return context;
        }
        return context;
    }

    @JsonIgnore
    protected static String createUri(String preUri, String postUri) {
        if (preUri.contains("?")) {
            String[] parts = preUri.split("\\?");
            return String.format("%s%s", parts[0], postUri);
        }
        return String.format("%s%s", preUri, postUri);
    }

    @JsonView(value={APIView.class})
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    protected <T extends APIEntity> APIResource<T> getResource(String uri, Class<T> type) throws APIException {
        this.checkClient(this.client);
        return new APIResource<T>(this.client, uri, type);
    }

    @JsonIgnore
    protected <T extends APIEntity> APIListResource<T> getListResource(String uri) throws APIException {
        this.checkClient(this.client);
        return new APIListResource(this.client, uri);
    }

    @JsonIgnore
    protected <T extends APIEntity> APIListResource<T> getListResource(String uri, APIQueryBuilder queryBuilder) throws APIException {
        this.checkClient(this.client);
        return new APIListResource(this.client, uri, queryBuilder);
    }

    @JsonIgnore
    protected <T extends APIEntity> APIListResource<T> getListResource(String uri, long offset, long limit, String search, APISort sort, Class<T> type) throws APIException {
        this.checkClient(this.client);
        if (limit <= 0L) {
            limit = 10L;
        }
        return new APIListResource(this.client, uri, new APIQueryBuilder().offset(offset).limit(limit).search(search).sort(type, sort.getItems()));
    }

    @JsonIgnore
    protected <T extends APIEntity> T postResource(String uri, Object body, Class<T> type) throws APIException {
        this.checkClient(this.client);
        return this.client.post(uri, body, type);
    }

    @JsonIgnore
    protected <T extends APIEntity> T postFile(String uri, File file, String contentType, Class<T> type) throws APIException {
        this.checkClient(this.client);
        return this.client.postFile(uri, contentType, file, type);
    }

    @JsonIgnore
    protected void deleteResource(String uri) throws APIException {
        this.checkClient(this.client);
        this.client.delete(uri);
    }

    @JsonIgnore
    protected InputStream getFile(String uri) throws APIException {
        this.checkClient(this.client);
        return this.client.get(uri);
    }

    @JsonIgnore
    public void refresh() throws APIException {
        this.checkClient(this.client);
        this.clone((APIEntity)this.client.get(this.selfURI, this.getClass()));
    }

    @JsonIgnore
    private void checkClient(APIClient client) throws APIException {
        if (client == null) {
            throw new APIException("Missing API client");
        }
    }

    @JsonIgnore
    public boolean hasView() {
        return this.view != null;
    }

    @JsonIgnore
    @XmlTransient
    public Class<? extends APIView> getView() {
        return this.view;
    }

    @JsonIgnore
    public void setView(Class<? extends APIView> view) {
        this.view = view;
    }

    @JsonIgnore
    public String toXML() {
        try {
            JAXBContext context = APIEntity.getJAXBContext(this.getClass());
            Marshaller marshaller = context.createMarshaller();
            StringWriter writer = new StringWriter();
            marshaller.marshal((Object)this, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException ex) {
            Logger.getLogger(APIEntity.class.getName()).log(Level.SEVERE, null, ex);
            return "";
        }
    }

    @JsonIgnore
    protected abstract <T extends APIEntity> void clone(T var1);

    @JsonIgnore
    protected <T extends APIEntity> void cloneBase(T from) {
        this.id = from.id;
        this.view = from.view;
    }
}

