/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api;

import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIListResource;
import com.testdroid.api.APIQueryBuilder;
import com.testdroid.api.APIView;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonView;

@XmlRootElement
@JsonIgnoreProperties(value={"id"})
public class APIList<T extends APIEntity>
extends APIEntity {
    @XmlElementWrapper
    private List<T> data;
    private Integer limit;
    private String next;
    private Integer offset;
    private String previous;
    private String search;
    private String sort;
    private Integer total;

    public APIList() {
        this.data = new ArrayList<T>();
        this.total = 0;
    }

    public APIList(String next, String previous, List<T> data, Integer total, String search, String sort) {
        this.next = next;
        this.previous = previous;
        this.data = data;
        this.total = total;
        this.search = search;
        this.sort = sort;
    }

    @JsonView(value={APIView.class})
    public String getNext() {
        return this.next;
    }

    public void setNext(String next) {
        this.next = next;
    }

    @JsonIgnore
    public boolean isNextAvailable() {
        return this.offset + this.limit < this.total && !this.data.isEmpty();
    }

    @JsonIgnore
    public APIList<T> getNextItems() throws APIException {
        if (!this.isNextAvailable()) {
            return null;
        }
        APIQueryBuilder queryBuilder = new APIQueryBuilder().limit(this.limit.intValue()).offset(this.offset + this.limit).search(this.search);
        return new APIListResource(this.client, this.selfURI, queryBuilder).getEntity();
    }

    @JsonIgnore
    public boolean isPreviousAvailable() {
        return this.offset > 0;
    }

    @JsonIgnore
    public APIList<T> getPreviousItems() throws APIException {
        if (!this.isPreviousAvailable()) {
            return null;
        }
        APIQueryBuilder queryBuilder = new APIQueryBuilder().limit(this.limit.intValue()).offset(this.offset - this.limit).search(this.search);
        return new APIListResource(this.client, this.selfURI, queryBuilder).getEntity();
    }

    @JsonView(value={APIView.class})
    public String getPrevious() {
        return this.previous;
    }

    public void setPrevious(String previous) {
        this.previous = previous;
    }

    @XmlTransient
    @JsonView(value={APIView.class})
    public List<T> getData() {
        return this.data;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    @JsonView(value={APIView.class})
    public T get(int index) {
        return (T)((APIEntity)this.data.get(index));
    }

    @JsonView(value={APIView.class})
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @JsonView(value={APIView.class})
    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    @JsonView(value={APIView.class})
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    @JsonView(value={APIView.class})
    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    @JsonView(value={APIView.class})
    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    @JsonView(value={APIView.class})
    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    @JsonIgnore
    protected <S extends APIEntity> void clone(S from) {
        APIList apiList = (APIList)from;
        this.cloneBase(from);
        this.data = apiList.data;
        this.limit = apiList.limit;
        this.next = apiList.next;
        this.offset = apiList.offset;
        this.previous = apiList.previous;
        this.search = apiList.search;
        this.sort = apiList.sort;
        this.total = apiList.total;
    }
}

