/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api;

import com.testdroid.api.APIClient;
import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIList;
import com.testdroid.api.APIQueryBuilder;
import com.testdroid.api.APIResource;

public class APIListResource<T extends APIEntity>
extends APIResource<APIList<T>> {
    public APIListResource(APIClient client, String resourceURI) {
        this(client, resourceURI, new APIQueryBuilder());
    }

    public APIListResource(APIClient client, String resourceURI, APIQueryBuilder queryBuilder) {
        super(client, resourceURI, queryBuilder, APIList.class);
    }

    @Override
    public APIList<T> getEntity() throws APIException {
        APIList result = (APIList)super.getEntity();
        for (APIEntity item : result.getData()) {
            item.client = this.client;
            item.selfURI = APIEntity.createUri(this.resourceURI, String.format("/%s", item.id));
        }
        return result;
    }

    public Integer getTotal() throws APIException {
        return ((APIList)this.getEntity()).getTotal();
    }

    public boolean isNextAvailable() {
        try {
            APIEntity list = this.getEntity();
            return ((APIList)list).getOffset() + ((APIList)list).getLimit() < ((APIList)list).getTotal();
        }
        catch (APIException ex) {
            return false;
        }
    }

    public APIListResource<T> getNext() throws APIException {
        if (!this.isNextAvailable()) {
            return null;
        }
        APIEntity list = this.getEntity();
        return new APIListResource<T>(this.client, this.resourceURI, this.queryBuilder.offset(((APIList)list).getOffset() + ((APIList)list).getLimit()));
    }

    public boolean isPreviousAvailable() {
        try {
            return ((APIList)this.getEntity()).getOffset() > 0;
        }
        catch (APIException ex) {
            return false;
        }
    }

    public APIListResource<T> getPrevious() throws APIException {
        if (!this.isPreviousAvailable()) {
            return null;
        }
        APIEntity list = this.getEntity();
        return new APIListResource<T>(this.client, this.resourceURI, this.queryBuilder.offset(((APIList)list).getOffset() - ((APIList)list).getLimit()));
    }
}

