/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api;

import com.testdroid.api.APIClient;
import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIQueryBuilder;
import java.io.InputStream;

public class APIResource<T extends APIEntity> {
    protected APIClient client;
    protected APIQueryBuilder queryBuilder;
    protected String resourceURI;
    protected Class<T> type;
    private T entity;
    private boolean loaded = false;

    public APIResource(APIClient client, String resourceURI, Class<T> type) {
        this(client, resourceURI, null, type);
    }

    public APIResource(APIClient client, String resourceURI, APIQueryBuilder queryBuilder, Class<T> type) {
        this.client = client;
        this.resourceURI = resourceURI;
        this.type = type;
        this.queryBuilder = queryBuilder;
    }

    public T getEntity() throws APIException {
        this.load();
        return this.entity;
    }

    public InputStream getStream() throws APIException {
        return this.client.get(this.resourceURI);
    }

    public T update() throws APIException {
        this.entity = this.client.post(this.resourceURI, null, this.type);
        return this.entity;
    }

    public void delete() throws APIException {
        this.client.delete(this.resourceURI);
        this.entity = null;
        this.loaded = true;
    }

    public void refresh() throws APIException {
        this.clean();
        this.load();
    }

    private void load() throws APIException {
        if (!this.loaded) {
            this.entity = this.client.get(this.resourceURI, this.queryBuilder, this.type);
        }
    }

    private void clean() {
        this.loaded = false;
    }
}

