/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api;

import com.testdroid.api.APIEntity;
import com.testdroid.api.model.APIDevice;
import com.testdroid.api.model.APIDeviceGroup;
import com.testdroid.api.model.APIDeviceProperty;
import com.testdroid.api.model.APIDeviceRun;
import com.testdroid.api.model.APIDeviceRunState;
import com.testdroid.api.model.APILabelGroup;
import com.testdroid.api.model.APINotificationEmail;
import com.testdroid.api.model.APIProject;
import com.testdroid.api.model.APIProjectJobConfig;
import com.testdroid.api.model.APIProjectSharing;
import com.testdroid.api.model.APIRecorderOnlineSession;
import com.testdroid.api.model.APIScreenshot;
import com.testdroid.api.model.APISoftwareVersion;
import com.testdroid.api.model.APITag;
import com.testdroid.api.model.APITestCaseRun;
import com.testdroid.api.model.APITestRun;
import com.testdroid.api.model.APITestRunParameter;
import com.testdroid.api.model.APIUser;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class APISort {
    private SortItem[] items;

    protected APISort() {
    }

    private APISort(Class<? extends APIEntity> type, SortItem ... items) {
        if (items != null && items.length > 0) {
            ArrayList<SortItem> itemList = new ArrayList<SortItem>();
            for (SortItem si : items) {
                if (!si.column.supportedClass.equals(type)) continue;
                itemList.add(si);
            }
            this.items = itemList.toArray(new SortItem[itemList.size()]);
        } else {
            this.items = new SortItem[0];
        }
    }

    public static APISort create(Class<? extends APIEntity> type, SortItem ... items) {
        return new APISort(type, items);
    }

    public static APISort deserialize(Class<? extends APIEntity> type, String value) {
        String[] resultItems;
        if (StringUtils.isBlank((String)value)) {
            return new APISort(type, new SortItem[0]);
        }
        ArrayList<SortItem> items = new ArrayList<SortItem>();
        for (String stringItem : resultItems = value.split(":")) {
            String[] sortItemValues = stringItem.split("_");
            if (sortItemValues.length <= 1) continue;
            Column sc = Column.fromColumnName(type, sortItemValues[0]);
            Type st = Type.fromURLValue(sortItemValues[1]);
            if (sc == null || st == null) continue;
            items.add(new SortItem(sc, st));
        }
        return new APISort(type, items.toArray(new SortItem[items.size()]));
    }

    public SortItem[] getItems() {
        return this.items;
    }

    public void setItems(SortItem ... items) {
        this.items = items;
    }

    public boolean isEmpty() {
        return this.items == null || this.items.length == 0;
    }

    public String serialize() {
        ArrayList<String> resultItems = new ArrayList<String>();
        for (SortItem item : this.items) {
            resultItems.add(String.format("%s_%s", item.column.getName(), item.type.getURLValue()));
        }
        return StringUtils.join(resultItems, (String)":");
    }

    public static class SortItem {
        private Column column;
        private Type type;

        public SortItem(Column column, Type sortType) {
            this.column = column;
            this.type = sortType;
        }

        public Column getColumn() {
            return this.column;
        }

        public Type getType() {
            return this.type;
        }
    }

    public static enum Type {
        ASC,
        DESC;


        public static Type fromURLValue(String urlValue) {
            for (Type t : Type.values()) {
                if (!t.getURLValue().equals(urlValue)) continue;
                return t;
            }
            return null;
        }

        public String getURLValue() {
            switch (this) {
                case DESC: {
                    return "d";
                }
            }
            return "a";
        }
    }

    public static enum Column {
        DEVICE_NAME(APIDevice.class, "name"),
        DEVICE_OS_TYPE(APIDevice.class, "osType"),
        DEVICE_VNC_SUPPORTED(APIDevice.class, "vncSupported"),
        DEVICE_GROUP_ID(APIDeviceGroup.class, "id"),
        DEVICE_GROUP_NAME(APIDeviceGroup.class, "displayName"),
        DEVICE_GROUP_OS_TYPE(APIDeviceGroup.class, "osType"),
        DEVICE_PROPERTY_NAME(APIDeviceProperty.class, "displayName"),
        DEVICE_RUN_CREATED(APIDeviceRun.class, "createTime"),
        DEVICE_RUN_DEVICE(APIDeviceRun.class, "deviceModel.name"),
        DEVICE_RUN_END_TIME(APIDeviceRun.class, "endTime"),
        DEVICE_RUN_ID(APIDeviceRun.class, "id"),
        DEVICE_RUN_STATE_FINISHED(APIDeviceRunState.class, "finishTimeMS"),
        DEVICE_RUN_STATE_ID(APIDeviceRunState.class, "id"),
        DEVICE_RUN_STATE_STARTED(APIDeviceRunState.class, "startTimeMS"),
        DEVICE_RUN_STATE_STATUS(APIDeviceRunState.class, "status"),
        LABEL_GROUP_NAME(APILabelGroup.class, "displayName"),
        NOTIFICATION_EMAIL_EMAIL(APINotificationEmail.class, "email"),
        NOTIFICATION_EMAIL_ID(APINotificationEmail.class, "id"),
        NOTIFICATION_EMAIL_PROJECT_NAME(APINotificationEmail.class, "p.name", NameType.ABSOLUTE),
        PROJECT_DESCRIPTION(APIProject.class, "description"),
        PROJECT_ID(APIProject.class, "id"),
        PROJECT_NAME(APIProject.class, "name"),
        PROJECT_CREATE_TIME(APIProject.class, "createTime"),
        PROJECT_JOB_CONFIG_ID(APIProjectJobConfig.class, "id"),
        PROJECT_JOB_CONFIG_TYPE(APIProjectJobConfig.class, "type"),
        PROJECT_JOB_CONFIG_VERSION(APIProjectJobConfig.class, "version"),
        PROJECT_SHARING_ID(APIProjectSharing.class, "id"),
        PROJECT_SHARING_USER_EMAIL(APIProjectSharing.class, "userEmail"),
        RECORDER_ONLINE_SESSION_ID(APIRecorderOnlineSession.class, "id"),
        RECORDER_ONLINE_SESSION_END_TIME(APIRecorderOnlineSession.class, "endTime"),
        RECORDER_ONLINE_SESSION_START_TIME(APIRecorderOnlineSession.class, "startTime"),
        RECORDER_ONLINE_SESSION_UPDATE_TIME(APIRecorderOnlineSession.class, "updateTime"),
        SCREENSHOT_ID(APIScreenshot.class, "id"),
        SCREENSHOT_ORIGINAL_NAME(APIScreenshot.class, "originalName"),
        SCREENSHOT_TAKE_TIMESTAMP(APIScreenshot.class, "takeTimestamp"),
        SCREENSHOT_TYPE(APIScreenshot.class, "type"),
        SOFTWARE_API_LEVEL(APISoftwareVersion.class, "apiLevel"),
        SOFTWARE_ID(APISoftwareVersion.class, "id"),
        SOFTWARE_RELEASE_VERSION(APISoftwareVersion.class, "releaseVersion"),
        TAG_ID(APITag.class, "id"),
        TAG_NAME(APITag.class, "name"),
        TEST_CASE_RUN_CREATE_TIME(APITestCaseRun.class, "createTime"),
        TEST_CASE_RUN_ID(APITestCaseRun.class, "id"),
        TEST_CASE_RUN_RESULT(APITestCaseRun.class, "result"),
        TEST_RUN_CREATED(APITestRun.class, "createTime"),
        TEST_RUN_ID(APITestRun.class, "id"),
        TEST_RUN_NAME(APITestRun.class, "userName"),
        TEST_RUN_TAG(APITestRun.class, "t.name", NameType.ABSOLUTE),
        TEST_RUN_PARAMETER_ID(APITestRunParameter.class, "id"),
        TEST_RUN_PARAMETER_KEY(APITestRunParameter.class, "key"),
        USER_COUNTRY(APIUser.class, "localeCountry"),
        USER_EMAIL(APIUser.class, "email"),
        USER_ID(APIUser.class, "id"),
        USER_NAME(APIUser.class, "name");

        private String name;
        private Class<? extends APIEntity> supportedClass;
        private NameType type = NameType.RELATIVE;

        private Column(Class<? extends APIEntity> supportedClass, String name) {
            this.supportedClass = supportedClass;
            this.name = name;
        }

        private Column(Class<? extends APIEntity> supportedClass, String name, NameType type) {
            this(supportedClass, name);
            this.type = type;
        }

        public static Column fromColumnName(Class<? extends APIEntity> type, String name) {
            if (name == null) {
                return null;
            }
            for (Column sc : Column.get(type)) {
                if (!name.equals(sc.getName())) continue;
                return sc;
            }
            return null;
        }

        public static List<Column> get(Class<? extends APIEntity> type) {
            ArrayList<Column> result = new ArrayList<Column>();
            for (Column sc : Column.values()) {
                if (!sc.supportedClass.isAssignableFrom(type)) continue;
                result.add(sc);
            }
            return result;
        }

        public String getName() {
            return this.name;
        }

        public NameType getNameType() {
            return this.type;
        }

        public static enum NameType {
            RELATIVE,
            ABSOLUTE;

        }
    }
}

