/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api;

import com.testdroid.api.APIEntity;
import com.testdroid.api.APISort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class APISort2
extends APISort {
    private List<SortItem> sorts;

    private APISort2(Class<? extends APIEntity> type, SortItem ... items) {
        this.sorts = items != null && items.length > 0 ? Arrays.asList(items) : Collections.emptyList();
    }

    public static APISort2 create(Class<? extends APIEntity> type, SortItem ... items) {
        return new APISort2(type, items);
    }

    public static APISort2 deserialize(Class<? extends APIEntity> type, String value) {
        String[] resultItems;
        if (StringUtils.isBlank((String)value)) {
            return new APISort2(type, new SortItem[0]);
        }
        ArrayList<SortItem> items = new ArrayList<SortItem>();
        for (String stringItem : resultItems = value.split(":")) {
            String[] sortItemValues = stringItem.split("_");
            if (sortItemValues.length <= 1) continue;
            String column = sortItemValues[0];
            Type sortType = Type.fromURLValue(sortItemValues[1]);
            if (column == null || type == null) continue;
            items.add(new SortItem(column, sortType));
        }
        return new APISort2(type, items.toArray(new SortItem[items.size()]));
    }

    public List<SortItem> getSorts() {
        return this.sorts;
    }

    public void setSorts(List<SortItem> items) {
        this.sorts = items;
    }

    @Override
    public boolean isEmpty() {
        return this.sorts == null || this.sorts.isEmpty();
    }

    @Override
    public String serialize() {
        ArrayList<String> resultItems = new ArrayList<String>();
        for (SortItem item : this.sorts) {
            resultItems.add(String.format("%s_%s", item.column, item.type.getURLValue()));
        }
        return StringUtils.join(resultItems, (String)":");
    }

    public static class SortItem {
        private String column;
        private Type type;

        public SortItem(String column, Type sortType) {
            this.column = column;
            this.type = sortType;
        }

        public String getColumn() {
            return this.column;
        }

        public Type getType() {
            return this.type;
        }
    }

    public static enum Type {
        ASC("a"),
        DESC("d");

        private String urlValue;

        private Type(String urlValue) {
            this.urlValue = urlValue;
        }

        public static Type fromURLValue(String urlValue) {
            for (Type t : Type.values()) {
                if (!t.getURLValue().equals(urlValue)) continue;
                return t;
            }
            return null;
        }

        public String getURLValue() {
            return this.urlValue;
        }
    }
}

