/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api;

import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.FileContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.http.apache.ApacheHttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.testdroid.api.APIClient;
import com.testdroid.api.APIDeviceQueryBuilder;
import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIExceptionMessage;
import com.testdroid.api.APIListResource;
import com.testdroid.api.APIQueryBuilder;
import com.testdroid.api.APISort;
import com.testdroid.api.http.MultipartFormDataContent;
import com.testdroid.api.model.APIDevice;
import com.testdroid.api.model.APILabelGroup;
import com.testdroid.api.model.APIUser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.ChallengeState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;

public class DefaultAPIClient
implements APIClient {
    public static final int HTTP_CONNECT_TIMEOUT = 60000;
    public static final int HTTP_READ_TIMEOUT = 60000;
    protected static final String API_URI = "/api/v2";
    static final JAXBContext context = DefaultAPIClient.initContext();
    private static final int DEFAULT_CLIENT_CONNECT_TIMEOUT = 20000;
    private int clientConnectTimeout = 20000;
    private static final int DEFAULT_CLIENT_REQUEST_TIMEOUT = 60000;
    private int clientRequestTimeout = 60000;
    private static final String DEVICES_URI = "/devices";
    private static final String LABEL_GROUPS_URI = "/label-groups";
    private static final String TESTDROID_API_PACKAGES = "com.testdroid.api:com.testdroid.api.model";
    protected final HttpTransport httpTransport;
    protected String accessToken;
    protected long accessTokenExpireTime = 0L;
    protected String apiURL;
    protected String cloudURL;
    protected String password;
    protected String refreshToken;
    protected String username;

    public DefaultAPIClient(String cloudURL, String username, String password) {
        this(cloudURL, username, password, false);
    }

    public DefaultAPIClient(String cloudURL, String username, String password, boolean skipCheckCertificate) {
        NetHttpTransport.Builder netHttpBuilder;
        if (skipCheckCertificate) {
            try {
                netHttpBuilder = new NetHttpTransport.Builder().doNotValidateCertificate();
            }
            catch (GeneralSecurityException ex) {
                Logger.getLogger(DefaultAPIClient.class.getName()).log(Level.WARNING, "Cannot set not-validating certificate. Certificate will be validating.", ex);
                netHttpBuilder = new NetHttpTransport.Builder();
            }
        } else {
            netHttpBuilder = new NetHttpTransport.Builder();
        }
        this.httpTransport = netHttpBuilder.build();
        this.initializeDefaultAPIClient(cloudURL, username, password);
    }

    public DefaultAPIClient(String cloudURL, String username, String password, HttpHost proxy, boolean skipCheckCertificate) {
        ApacheHttpTransport.Builder apacheBuilder;
        if (skipCheckCertificate) {
            try {
                apacheBuilder = new ApacheHttpTransport.Builder().setProxy(proxy).doNotValidateCertificate();
            }
            catch (GeneralSecurityException ex) {
                Logger.getLogger(DefaultAPIClient.class.getName()).log(Level.WARNING, "Cannot set not-validating certificate. Certificate will be validating.", ex);
                apacheBuilder = new ApacheHttpTransport.Builder().setProxy(proxy);
            }
        } else {
            apacheBuilder = new ApacheHttpTransport.Builder().setProxy(proxy);
        }
        this.httpTransport = apacheBuilder.build();
        this.initializeDefaultAPIClient(cloudURL, username, password);
    }

    public DefaultAPIClient(String cloudURL, String username, String password, HttpHost proxy, String proxyUser, String proxyPassword, boolean skipCheckCertificate) {
        this(cloudURL, username, password, proxy, skipCheckCertificate);
        DefaultHttpClient apacheClient = (DefaultHttpClient)((ApacheHttpTransport)this.httpTransport).getHttpClient();
        apacheClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        apacheClient.getCredentialsProvider().setCredentials(new AuthScope(proxy.getHostName(), proxy.getPort()), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme(ChallengeState.PROXY);
        authCache.put(proxy, (AuthScheme)basicAuth);
        apacheClient.addRequestInterceptor(new HttpRequestInterceptor((AuthCache)authCache){
            final /* synthetic */ AuthCache val$authCache;
            {
                this.val$authCache = authCache;
            }

            public void process(org.apache.http.HttpRequest hr, HttpContext hc) throws HttpException, IOException {
                hc.setAttribute("http.auth.auth-cache", (Object)this.val$authCache);
            }
        }, 0);
    }

    protected static Credential getCredential() {
        return new Credential.Builder(BearerToken.queryParameterAccessMethod()).build();
    }

    private static JAXBContext initContext() {
        try {
            ClassLoader cl = APIEntity.class.getClassLoader();
            return JAXBContext.newInstance((String)TESTDROID_API_PACKAGES, (ClassLoader)cl);
        }
        catch (JAXBException e) {
            System.out.println("Failed initializing JAXBContext for DefaultAPIClient - API client will not work!");
            e.printStackTrace();
            return null;
        }
    }

    protected JAXBContext getContext() {
        return context;
    }

    private void initializeDefaultAPIClient(String cloudURL, String username, String password) {
        if (cloudURL.endsWith("/")) {
            cloudURL = cloudURL.substring(0, cloudURL.length() - 1);
        }
        this.cloudURL = cloudURL;
        this.apiURL = cloudURL + API_URI;
        this.username = username;
        this.password = password;
    }

    protected HttpRequestFactory getRequestFactory(String accessToken) {
        final Credential credential = DefaultAPIClient.getCredential();
        if (StringUtils.isNotBlank((String)accessToken)) {
            credential.setAccessToken(accessToken);
        }
        return this.httpTransport.createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                credential.initialize(request);
            }
        });
    }

    protected String getAccessToken() throws APIException {
        if (this.accessToken == null) {
            this.accessToken = this.acquireAccessToken();
        }
        if (System.currentTimeMillis() > this.accessTokenExpireTime - 10000L) {
            try {
                this.accessToken = this.refreshAccessToken();
            }
            catch (APIException ex) {
                this.accessToken = null;
                this.accessToken = this.acquireAccessToken();
            }
        }
        return this.accessToken;
    }

    protected String acquireAccessToken() throws APIException {
        try {
            if (this.username == null && this.password == null) {
                return "";
            }
            GenericUrl url = new GenericUrl(String.format("%s/oauth/token", this.cloudURL));
            UrlEncodedContent content = new UrlEncodedContent((Object)new HashMap(){
                {
                    this.put("client_id", "testdroid-cloud-api");
                    this.put("grant_type", "password");
                    this.put("username", DefaultAPIClient.this.username);
                    this.put("password", DefaultAPIClient.this.password);
                }
            });
            HttpRequest request = this.httpTransport.createRequestFactory().buildPostRequest(url, (HttpContent)content);
            request.setConnectTimeout(60000);
            request.setReadTimeout(60000);
            request.setHeaders(new HttpHeaders().setAccept("application/json"));
            HttpResponse response = request.execute();
            if (response.getStatusCode() != 200) {
                throw new APIException(response.getStatusCode(), "Failed to acquire access token");
            }
            String responseJson = StringUtils.join((Collection)IOUtils.readLines((InputStream)response.getContent()), (String)"\n");
            JSONObject json = JSONObject.fromObject((Object)responseJson);
            this.accessTokenExpireTime = System.currentTimeMillis() + Long.parseLong(json.optString("expires_in")) * 1000L;
            this.refreshToken = json.optString("refresh_token");
            return json.optString("access_token");
        }
        catch (HttpResponseException ex) {
            throw new APIException(String.format("Failed to acquire access token. Reason: %s", ex.getStatusMessage()), ex);
        }
        catch (IOException ex) {
            throw new APIException(String.format("Failed to acquire access token. Reason: %s", ex.getMessage()), ex);
        }
    }

    protected String refreshAccessToken() throws APIException {
        try {
            if (this.refreshToken == null) {
                return null;
            }
            GenericUrl url = new GenericUrl(String.format("%s/oauth/token", this.cloudURL));
            UrlEncodedContent content = new UrlEncodedContent((Object)new HashMap(){
                {
                    this.put("client_id", "testdroid-cloud-api");
                    this.put("grant_type", "refresh_token");
                    this.put("refresh_token", DefaultAPIClient.this.refreshToken);
                }
            });
            HttpRequest request = this.httpTransport.createRequestFactory().buildPostRequest(url, (HttpContent)content);
            request.setConnectTimeout(60000);
            request.setReadTimeout(60000);
            request.setHeaders(new HttpHeaders().setAccept("application/json"));
            HttpResponse response = request.execute();
            if (response.getStatusCode() != 200) {
                throw new APIException(response.getStatusCode(), "Failed to refresh access token");
            }
            String jsonContent = StringUtils.join((Collection)IOUtils.readLines((InputStream)response.getContent()), (String)"\n");
            JSONObject json = JSONObject.fromObject((Object)jsonContent);
            this.accessTokenExpireTime = System.currentTimeMillis() + Long.parseLong(json.optString("expires_in")) * 1000L;
            this.refreshToken = json.optString("refresh_token");
            return json.optString("access_token");
        }
        catch (IOException ex) {
            throw new APIException(String.format("Failed to refresh access token. Reason: %s", ex.getMessage()), ex);
        }
    }

    @Override
    public void setConnectTimeout(int timeout) {
        this.clientConnectTimeout = timeout;
    }

    @Override
    public void setRequestTimeout(int timeout) {
        this.clientRequestTimeout = timeout;
    }

    @Override
    public <T extends APIEntity> T get(String uri, Class<T> type) throws APIException {
        try {
            return this.getOnce(uri, null, type);
        }
        catch (APIException ex) {
            if (ex.getStatus() != null && 401 == ex.getStatus()) {
                this.accessToken = null;
                return this.getOnce(uri, null, type);
            }
            throw ex;
        }
    }

    @Override
    public <T extends APIEntity> T get(String uri, APIQueryBuilder queryBuilder, Class<T> type) throws APIException {
        try {
            return this.getOnce(uri, queryBuilder, type);
        }
        catch (APIException ex) {
            if (ex.getStatus() != null && 401 == ex.getStatus()) {
                this.accessToken = null;
                return this.getOnce(uri, queryBuilder, type);
            }
            throw ex;
        }
    }

    @Override
    public InputStream get(String uri) throws APIException {
        try {
            return this.getStream(uri);
        }
        catch (APIException ex) {
            if (ex.getStatus() != null && 401 == ex.getStatus()) {
                this.accessToken = null;
                return this.getStream(uri);
            }
            throw ex;
        }
    }

    private <T extends APIEntity> T getOnce(String uri, APIQueryBuilder queryBuilder, Class<T> type) throws APIException {
        HttpRequestFactory factory = this.getRequestFactory(this.getAccessToken());
        try {
            HttpRequest request = factory.buildGetRequest(new GenericUrl(this.buildUrl(this.apiURL + uri, queryBuilder)));
            request.setHeaders(new HttpHeaders().setAccept("application/xml"));
            request.setConnectTimeout(this.clientConnectTimeout);
            request.setReadTimeout(this.clientRequestTimeout);
            HttpResponse response = request.execute();
            if (!Arrays.asList(200, 202, 201, 204).contains(response.getStatusCode())) {
                throw new APIException(response.getStatusCode(), String.format("Failed to execute api call: %s", uri));
            }
            APIEntity result = (APIEntity)this.fromXML(response.getContent(), type);
            result.client = this;
            result.selfURI = uri;
            return (T)result;
        }
        catch (HttpResponseException ex) {
            try {
                APIExceptionMessage exceptionMessage = this.fromXML(ex.getContent(), APIExceptionMessage.class);
                throw new APIException(ex.getStatusCode(), exceptionMessage.getMessage(), ex);
            }
            catch (APIException e) {
                throw new APIException(ex.getStatusCode(), ex.getMessage());
            }
        }
        catch (IOException ex) {
            throw new APIException(String.format("Failed to execute API call: %s. Reason: %s", uri, ex.getMessage()), ex);
        }
    }

    private InputStream getStream(String uri) throws APIException {
        HttpRequestFactory factory = this.getRequestFactory(this.getAccessToken());
        try {
            HttpRequest request = factory.buildGetRequest(new GenericUrl(this.apiURL + uri));
            request.setConnectTimeout(this.clientConnectTimeout);
            request.setReadTimeout(this.clientRequestTimeout);
            HttpResponse response = request.execute();
            if (!Arrays.asList(200, 202, 201).contains(response.getStatusCode())) {
                throw new APIException(response.getStatusCode(), String.format("Failed to execute api call: %s", uri));
            }
            return response.getContent();
        }
        catch (HttpResponseException ex) {
            try {
                APIExceptionMessage exceptionMessage = this.fromXML(ex.getContent(), APIExceptionMessage.class);
                throw new APIException(ex.getStatusCode(), exceptionMessage.getMessage(), ex);
            }
            catch (APIException e) {
                throw new APIException(ex.getStatusCode(), ex.getMessage());
            }
        }
        catch (IOException ex) {
            throw new APIException(String.format("Failed to execute API call: %s. Reason: %s", uri, ex.getMessage()), ex);
        }
    }

    @Override
    public <T extends APIEntity> T post(String uri, Object body, Class<T> type) throws APIException {
        try {
            return this.postOnce(uri, body, null, type);
        }
        catch (APIException ex) {
            if (ex.getStatus() != null && 401 == ex.getStatus()) {
                this.accessToken = null;
                return this.postOnce(uri, body, null, type);
            }
            throw ex;
        }
    }

    protected <T extends APIEntity> T postOnce(String uri, Object body, String contentType, Class<T> type) throws APIException {
        if (contentType == null) {
            contentType = "application/xml";
        }
        HttpRequestFactory factory = this.getRequestFactory(this.getAccessToken());
        String resourceUrl = this.apiURL + uri;
        try {
            Object content;
            HttpHeaders headers = new HttpHeaders();
            headers.setAccept("application/xml");
            if (body instanceof File) {
                MultipartFormDataContent multipartContent = new MultipartFormDataContent();
                FileContent fileContent = new FileContent(contentType, (File)body);
                MultipartFormDataContent.Part filePart = new MultipartFormDataContent.Part("file", (HttpContent)fileContent);
                multipartContent.addPart(filePart);
                content = multipartContent;
            } else if (body instanceof InputStream) {
                headers.setContentType(contentType);
                content = new InputStreamContent(contentType, (InputStream)body);
            } else if (body instanceof APIEntity) {
                content = new InputStreamContent(contentType, IOUtils.toInputStream((String)((APIEntity)body).toXML()));
            } else if (body instanceof HttpContent) {
                content = (HttpContent)body;
            } else if (body instanceof Map) {
                Map map = (Map)body;
                this.fixMapParameters(map);
                content = new UrlEncodedContent((Object)map);
            } else {
                content = body == null ? null : new ByteArrayContent("text/plain", body.toString().getBytes());
            }
            HttpRequest request = factory.buildPostRequest(new GenericUrl(resourceUrl), content);
            request.setHeaders(headers);
            request.setConnectTimeout(this.clientConnectTimeout);
            request.setReadTimeout(this.clientRequestTimeout);
            HttpResponse response = request.execute();
            if (response == null) {
                throw new APIException("No response from API");
            }
            if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                throw new APIException(response.getStatusCode(), "Failed to post resource: " + response.getStatusMessage());
            }
            if (type != null) {
                APIEntity result = (APIEntity)this.fromXML(response.getContent(), type);
                result.client = this;
                result.selfURI = uri;
                if (response.getStatusCode() == 201 && result.getId() != null) {
                    result.selfURI = result.selfURI + String.format("/%s", result.getId());
                }
                return (T)result;
            }
            return null;
        }
        catch (HttpResponseException ex) {
            try {
                try {
                    APIExceptionMessage exceptionMessage = this.fromXML(ex.getContent(), APIExceptionMessage.class);
                    throw new APIException(ex.getStatusCode(), exceptionMessage.getMessage(), ex);
                }
                catch (Exception e) {
                    throw new APIException(ex.getStatusCode(), ex.getContent(), ex);
                }
            }
            catch (APIException e) {
                throw new APIException(ex.getStatusCode(), ex.getMessage());
            }
        }
        catch (IOException ex) {
            throw new APIException(String.format("Failed to execute API call: %s. Reason: %s", uri, ex.getMessage()), ex);
        }
    }

    @Override
    public <T extends APIEntity> T postFile(String uri, String contentType, File file, Class<T> type) throws APIException {
        try {
            return this.postOnce(uri, file, contentType, type);
        }
        catch (APIException ex) {
            if (ex.getStatus() != null && 401 == ex.getStatus()) {
                this.accessToken = null;
                return this.postOnce(uri, file, contentType, type);
            }
            throw ex;
        }
    }

    @Override
    public void delete(String uri) throws APIException {
        try {
            this.deleteOnce(uri);
        }
        catch (APIException ex) {
            if (ex.getStatus() != null && 401 == ex.getStatus()) {
                this.accessToken = null;
                this.deleteOnce(uri);
            }
            throw ex;
        }
    }

    private void deleteOnce(String uri) throws APIException {
        HttpRequestFactory factory = this.getRequestFactory(this.getAccessToken());
        try {
            HttpRequest request = factory.buildDeleteRequest(new GenericUrl(this.apiURL + uri));
            request.setHeaders(new HttpHeaders().setAccept("application/xml"));
            request.setConnectTimeout(this.clientConnectTimeout);
            request.setReadTimeout(this.clientRequestTimeout);
            HttpResponse response = request.execute();
            if (response == null) {
                throw new APIException("No response from API");
            }
            if (response.getStatusCode() != 204) {
                throw new APIException(response.getStatusCode(), "Failed to delete resource: " + response.getStatusMessage());
            }
        }
        catch (HttpResponseException ex) {
            try {
                APIExceptionMessage exceptionMessage = this.fromXML(ex.getContent(), APIExceptionMessage.class);
                throw new APIException(ex.getStatusCode(), exceptionMessage.getMessage(), ex);
            }
            catch (APIException e) {
                throw new APIException(ex.getStatusCode(), ex.getMessage());
            }
        }
        catch (IOException ex) {
            throw new APIException(String.format("Failed to execute API call: %s. Reason: %s", uri, ex.getMessage()), ex);
        }
    }

    @Override
    public APIUser me() throws APIException {
        return this.get("/me", APIUser.class);
    }

    @Override
    public APIUser register(String email) throws APIException {
        APIUser result = this.post("/users", Collections.singletonMap("email", email), APIUser.class);
        result.selfURI = "/me";
        return result;
    }

    @Override
    public APIListResource<APIDevice> getDevices() throws APIException {
        return new APIListResource<APIDevice>(this, DEVICES_URI);
    }

    @Override
    public APIListResource<APIDevice> getDevices(APIDevice.DeviceFilter ... filters) throws APIException {
        return new APIListResource<APIDevice>((APIClient)this, DEVICES_URI, new APIDeviceQueryBuilder().filterWithDeviceFilters(filters));
    }

    @Override
    public APIListResource<APIDevice> getDevices(APIDeviceQueryBuilder queryBuilder) throws APIException {
        return new APIListResource<APIDevice>((APIClient)this, DEVICES_URI, queryBuilder);
    }

    @Override
    public APIListResource<APIDevice> getDevices(long offset, long limit, String search, APISort sort, APIDevice.DeviceFilter ... filters) throws APIException {
        if (limit <= 0L) {
            limit = 10L;
        }
        APIDeviceQueryBuilder builder = new APIDeviceQueryBuilder().offset((int)offset).limit((int)limit).search(search).filterWithDeviceFilters(filters);
        if (sort != null) {
            builder.sort(APIDevice.class, sort.getItems());
        }
        return new APIListResource<APIDevice>((APIClient)this, DEVICES_URI, builder);
    }

    @Override
    public APIListResource<APILabelGroup> getLabelGroups() throws APIException {
        return new APIListResource<APILabelGroup>(this, LABEL_GROUPS_URI);
    }

    @Override
    public APIListResource<APILabelGroup> getLabelGroups(APIQueryBuilder queryBuilder) throws APIException {
        return new APIListResource<APILabelGroup>((APIClient)this, LABEL_GROUPS_URI, queryBuilder);
    }

    private <T> T fromXML(String xml, Class<T> type) throws APIException {
        try {
            Unmarshaller unmarshaller = this.getContext().createUnmarshaller();
            return (T)unmarshaller.unmarshal((Reader)new StringReader(xml));
        }
        catch (JAXBException ex) {
            throw new APIException(String.format("Failed to parse response as %s", type.getName()));
        }
    }

    private <T> T fromXML(InputStream inputStream, Class<T> type) throws APIException {
        try {
            Unmarshaller unmarshaller = this.getContext().createUnmarshaller();
            return (T)unmarshaller.unmarshal(inputStream);
        }
        catch (JAXBException ex) {
            throw new APIException(String.format("Failed to parse response as %s", type.getName()));
        }
    }

    private String buildUrl(String url, APIQueryBuilder queryBuilder) throws APIException {
        try {
            URIBuilder builder = new URIBuilder(url);
            if (queryBuilder != null) {
                for (Map.Entry<String, Object> entry : queryBuilder.build().entrySet()) {
                    builder.addParameter(entry.getKey(), entry.getValue() == null ? "" : entry.getValue().toString());
                }
            }
            return builder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new APIException(String.format("Bad URL: %s", e.getMessage()));
        }
    }

    private Map fixMapParameters(Map map) {
        for (Object key : map.keySet()) {
            if (map.get(key) == null) {
                map.put(key, "");
            }
            if (!(map.get(key) instanceof Enum)) continue;
            map.put(key, map.get(key).toString());
        }
        return map;
    }
}

