/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIListResource;
import com.testdroid.api.APIQueryBuilder;
import com.testdroid.api.APISort;
import com.testdroid.api.model.APIDevice;
import java.util.Collections;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonIgnore;

@XmlRootElement
public class APIDeviceGroup
extends APIEntity {
    private Integer creditsPrice;
    private Integer deviceCount;
    private String displayName;
    private String name;
    private APIDevice.OsType osType;
    private Long userId;

    public APIDeviceGroup() {
    }

    public APIDeviceGroup(Long id, String name, String displayName, APIDevice.OsType osType, Integer deviceCount, Integer creditsPrice, Long userId) {
        this.id = id;
        this.name = name;
        this.displayName = displayName;
        this.creditsPrice = creditsPrice;
        this.deviceCount = deviceCount;
        this.userId = userId;
        this.osType = osType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Integer getDeviceCount() {
        return this.deviceCount;
    }

    public void setDeviceCount(Integer deviceCount) {
        this.deviceCount = deviceCount;
    }

    public Integer getCreditsPrice() {
        return this.creditsPrice;
    }

    public void setCreditsPrice(Integer creditsPrice) {
        this.creditsPrice = creditsPrice;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public APIDevice.OsType getOsType() {
        return this.osType;
    }

    public void setOsType(APIDevice.OsType osType) {
        this.osType = osType;
    }

    @JsonIgnore
    public boolean isPublic() {
        return this.userId == null;
    }

    private String getIncludedDevicesURI() {
        return APIDeviceGroup.createUri(this.selfURI, "/devices");
    }

    private String getIncludedDevicesURI(Long deviceId) {
        return APIDeviceGroup.createUri(this.selfURI, "/devices/" + deviceId);
    }

    @JsonIgnore
    public APIListResource<APIDevice> getIncludedDevicesResource() throws APIException {
        return this.getListResource(this.getIncludedDevicesURI());
    }

    @JsonIgnore
    public APIListResource<APIDevice> getIncludedDevicesResource(APIQueryBuilder queryBuilder) throws APIException {
        return this.getListResource(this.getIncludedDevicesURI(), queryBuilder);
    }

    @JsonIgnore
    public APIListResource<APIDevice> getIncludedDevicesResource(long offset, long limit, String search, APISort sort) throws APIException {
        return this.getListResource(this.getIncludedDevicesURI(), offset, limit, search, sort, APIDevice.class);
    }

    public void delete() throws APIException {
        this.deleteResource(this.selfURI);
    }

    public void addDevice(APIDevice device) throws APIException {
        this.postResource(this.getIncludedDevicesURI(), Collections.singletonMap("deviceId", device.getId()), null);
    }

    public void deleteDevice(APIDevice device) throws APIException {
        this.deleteResource(this.getIncludedDevicesURI(device.getId()));
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APIDeviceGroup apiDeviceGroup = (APIDeviceGroup)from;
        this.cloneBase(from);
        this.creditsPrice = apiDeviceGroup.creditsPrice;
        this.deviceCount = apiDeviceGroup.deviceCount;
        this.name = apiDeviceGroup.name;
        this.displayName = apiDeviceGroup.displayName;
        this.userId = apiDeviceGroup.userId;
        this.osType = apiDeviceGroup.osType;
    }
}

