/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIListResource;
import com.testdroid.api.APIQueryBuilder;
import com.testdroid.api.APISort;
import com.testdroid.api.model.APIDevice;
import com.testdroid.api.model.APIDeviceRunState;
import com.testdroid.api.model.APIScreenshot;
import com.testdroid.api.model.APISoftwareVersion;
import java.io.InputStream;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.jackson.annotate.JsonIgnore;

@XmlRootElement
public class APIDeviceRun
extends APIEntity {
    private Date createTime;
    private APIDeviceRunState currentState;
    private APIDevice device;
    private String deviceName;
    private String deviceSerialId;
    private Long deviceSessionId;
    private APIDeviceRunState interruptedByState;
    private Long launchAppDuration;
    private RunStatus runStatus;
    private APISoftwareVersion softwareVersion;
    private Date startTime;
    private Integer testCaseAllNo;
    private Integer testCaseSuccessNo;
    private Integer testCasePassedNo;
    private Integer testCaseFailedNo;
    private Integer testCaseSkippedNo;

    public APIDeviceRun() {
    }

    public APIDeviceRun(Long id, Long deviceSessionId, Long launchAppDuration, APIDevice device, Integer testCaseSuccessNo, Integer testCaseAllNo, Integer testCasePassedNo, Integer testCaseFailedNo, Integer testCaseSkippedNo, APISoftwareVersion softwareVersion, Date createTime, Date startTime, APIDeviceRunState currentState, APIDeviceRunState interruptedByState, RunStatus runStatus, String deviceName, String deviceSerialId) {
        super(id);
        this.deviceSessionId = deviceSessionId;
        this.launchAppDuration = launchAppDuration;
        this.device = device;
        this.testCaseSuccessNo = testCaseSuccessNo;
        this.testCaseAllNo = testCaseAllNo;
        this.testCasePassedNo = testCasePassedNo;
        this.testCaseFailedNo = testCaseFailedNo;
        this.testCaseSkippedNo = testCaseSkippedNo;
        this.softwareVersion = softwareVersion;
        this.createTime = createTime;
        this.startTime = startTime;
        this.currentState = currentState;
        this.interruptedByState = interruptedByState;
        this.runStatus = runStatus;
        this.deviceName = deviceName;
        this.deviceSerialId = deviceSerialId;
    }

    public Long getDeviceSessionId() {
        return this.deviceSessionId;
    }

    public void setDeviceSessionId(Long deviceSessionId) {
        this.deviceSessionId = deviceSessionId;
    }

    public Long getLaunchAppDuration() {
        return this.launchAppDuration;
    }

    public void setLaunchAppDuration(Long launchAppDuration) {
        this.launchAppDuration = launchAppDuration;
    }

    public APIDevice getDevice() {
        return this.device;
    }

    public void setDevice(APIDevice device) {
        this.device = device;
    }

    public Integer getTestCaseSuccessNo() {
        return this.testCaseSuccessNo;
    }

    public void setTestCaseSuccessNo(Integer testCaseSuccessNo) {
        this.testCaseSuccessNo = testCaseSuccessNo;
    }

    public Integer getTestCaseAllNo() {
        return this.testCaseAllNo;
    }

    public void setTestCaseAllNo(Integer testCaseAllNo) {
        this.testCaseAllNo = testCaseAllNo;
    }

    public Integer getTestCasePassedNo() {
        return this.testCasePassedNo;
    }

    public void setTestCasePassedNo(Integer testCasePassedNo) {
        this.testCasePassedNo = testCasePassedNo;
    }

    public Integer getTestCaseFailedNo() {
        return this.testCaseFailedNo;
    }

    public void setTestCaseFailedNo(Integer testCaseFailedNo) {
        this.testCaseFailedNo = testCaseFailedNo;
    }

    public Integer getTestCaseSkippedNo() {
        return this.testCaseSkippedNo;
    }

    public void setTestCaseSkippedNo(Integer testCaseSkippedNo) {
        this.testCaseSkippedNo = testCaseSkippedNo;
    }

    public APISoftwareVersion getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(APISoftwareVersion softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public APIDeviceRunState getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(APIDeviceRunState currentState) {
        this.currentState = currentState;
    }

    public APIDeviceRunState getInterruptedByState() {
        return this.interruptedByState;
    }

    public void setInterruptedByState(APIDeviceRunState interruptedByState) {
        this.interruptedByState = interruptedByState;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getDeviceSerialId() {
        return this.deviceSerialId;
    }

    public void setDeviceSerialId(String deviceSerialId) {
        this.deviceSerialId = deviceSerialId;
    }

    private String getLogsURI() {
        return APIDeviceRun.createUri(this.selfURI, "/logs");
    }

    private String getScreenshotsURI() {
        return APIDeviceRun.createUri(this.selfURI, "/screenshots");
    }

    private String getJunitURI() {
        return APIDeviceRun.createUri(this.selfURI, "/junit.xml");
    }

    private String getPerformanceURI() {
        return APIDeviceRun.createUri(this.selfURI, "/performance");
    }

    private String getResultDataZipURI() {
        return APIDeviceRun.createUri(this.selfURI, "/result-data.zip");
    }

    private String getStatesURI() {
        return APIDeviceRun.createUri(this.selfURI, "/states");
    }

    @JsonIgnore
    public InputStream getLogs() throws APIException {
        return this.client.get(this.getLogsURI());
    }

    @JsonIgnore
    public InputStream getJunitXml() throws APIException {
        return this.client.get(this.getJunitURI());
    }

    @JsonIgnore
    public InputStream getPerformanceData() throws APIException {
        return this.client.get(this.getPerformanceURI());
    }

    @JsonIgnore
    public InputStream getResultDataZip() throws APIException {
        return this.client.get(this.getResultDataZipURI());
    }

    @JsonIgnore
    public APIListResource<APIDeviceRunState> getDeviceRunStatesResource() throws APIException {
        return this.getListResource(this.getStatesURI());
    }

    @JsonIgnore
    public APIListResource<APIDeviceRunState> getDeviceRunStatesResource(APIQueryBuilder queryBuilder) throws APIException {
        return this.getListResource(this.getStatesURI(), queryBuilder);
    }

    @JsonIgnore
    public APIListResource<APIDeviceRunState> getDeviceRunStatesResource(long offset, long limit, String search, APISort sort) throws APIException {
        return this.getListResource(this.getStatesURI(), offset, limit, search, sort, APIDeviceRunState.class);
    }

    @JsonIgnore
    public APIListResource<APIScreenshot> getScreenshotsResource() throws APIException {
        return this.getListResource(this.getScreenshotsURI());
    }

    @JsonIgnore
    public APIListResource<APIScreenshot> getScreenshotsResource(APIQueryBuilder queryBuilder) throws APIException {
        return this.getListResource(this.getScreenshotsURI(), queryBuilder);
    }

    @JsonIgnore
    public APIListResource<APIScreenshot> getScreenshotsResource(long offset, long limit, String search, APISort sort) throws APIException {
        return this.getListResource(this.getScreenshotsURI(), offset, limit, search, sort, APIScreenshot.class);
    }

    public RunStatus getRunStatus() {
        return this.runStatus;
    }

    public void setRunStatus(RunStatus runStatus) {
        this.runStatus = runStatus;
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APIDeviceRun apiDeviceRun = (APIDeviceRun)from;
        this.cloneBase(from);
        this.deviceSessionId = apiDeviceRun.deviceSessionId;
        this.launchAppDuration = apiDeviceRun.launchAppDuration;
        this.createTime = apiDeviceRun.createTime;
        this.currentState = apiDeviceRun.currentState;
        this.device = apiDeviceRun.device;
        this.interruptedByState = apiDeviceRun.interruptedByState;
        this.runStatus = apiDeviceRun.runStatus;
        this.softwareVersion = apiDeviceRun.softwareVersion;
        this.startTime = apiDeviceRun.startTime;
        this.testCaseAllNo = apiDeviceRun.testCaseAllNo;
        this.testCaseSuccessNo = apiDeviceRun.testCaseSuccessNo;
        this.testCasePassedNo = apiDeviceRun.testCasePassedNo;
        this.testCaseFailedNo = apiDeviceRun.testCaseFailedNo;
        this.testCaseSkippedNo = apiDeviceRun.testCaseSkippedNo;
    }

    @XmlType(namespace="APIDeviceRun")
    public static enum RunStatus {
        WAITING,
        RUNNING,
        EXCLUDED,
        WARNING,
        FAILED,
        SUCCEEDED;

    }
}

