/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIListResource;
import com.testdroid.api.APIQueryBuilder;
import com.testdroid.api.model.APIUserFile;
import java.util.Collections;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonIgnore;

@XmlRootElement
public class APIFileSet
extends APIEntity {
    private Date createTime;
    private Integer fileCount;
    private String name;

    public APIFileSet() {
    }

    public APIFileSet(Long id, String name, Date createTime, Integer fileCount) {
        super(id);
        this.name = name;
        this.createTime = createTime;
        this.fileCount = fileCount;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(Integer fileCount) {
        this.fileCount = fileCount;
    }

    private String getIncludedFilesURI() {
        return APIFileSet.createUri(this.selfURI, "/files");
    }

    private String getIncludedFilesURI(Long fileId) {
        return APIFileSet.createUri(this.selfURI, "/files/" + fileId);
    }

    @JsonIgnore
    public APIListResource<APIUserFile> getIncludedFilesResource() throws APIException {
        return this.getListResource(this.getIncludedFilesURI());
    }

    @JsonIgnore
    public APIListResource<APIUserFile> getIncludedFilesResource(APIQueryBuilder queryBuilder) throws APIException {
        return this.getListResource(this.getIncludedFilesURI(), queryBuilder);
    }

    public void delete() throws APIException {
        this.deleteResource(this.selfURI);
    }

    public void addFile(APIUserFile file) throws APIException {
        this.postResource(this.getIncludedFilesURI(), Collections.singletonMap("fileId", file.getId()), null);
    }

    public void removeFile(APIUserFile file) throws APIException {
        this.deleteResource(this.getIncludedFilesURI(file.getId()));
    }

    public void update() throws APIException {
        APIFileSet fileSet = this.postResource(this.selfURI, Collections.singletonMap("name", this.name), APIFileSet.class);
        this.clone(fileSet);
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APIFileSet apiFileSet = (APIFileSet)from;
        this.cloneBase(from);
        this.name = apiFileSet.name;
        this.createTime = apiFileSet.createTime;
        this.fileCount = apiFileSet.fileCount;
    }
}

