/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.model.AndroidFiles;
import com.testdroid.api.model.AppiumAndroidFiles;
import com.testdroid.api.model.AppiumIOSFiles;
import com.testdroid.api.model.CalabashFiles;
import com.testdroid.api.model.CalabashIOSFiles;
import com.testdroid.api.model.IOSFiles;
import com.testdroid.api.model.RemoteControlFiles;
import com.testdroid.api.model.UIAutomatorFiles;
import java.io.InputStream;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonTypeInfo;

@XmlRootElement
@XmlSeeAlso(value={AndroidFiles.class, IOSFiles.class, UIAutomatorFiles.class, RemoteControlFiles.class, CalabashFiles.class, CalabashIOSFiles.class, AppiumAndroidFiles.class, AppiumIOSFiles.class})
@JsonIgnoreProperties(value={"id"})
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public abstract class APIFiles
extends APIEntity {
    private DataFile data;

    public APIFiles() {
    }

    public APIFiles(Long id, DataFile data) {
        super(id);
        this.data = data;
    }

    public DataFile getData() {
        return this.data;
    }

    public void setData(DataFile data) {
        this.data = data;
    }

    protected String getDataURI() {
        return APIFiles.createUri(this.selfURI, "/data");
    }

    protected String getApplicationURI() {
        return APIFiles.createUri(this.selfURI, "/application");
    }

    protected String getTestURI() {
        return APIFiles.createUri(this.selfURI, "/test");
    }

    @JsonIgnore
    @XmlTransient
    public InputStream getApplicationStream() throws APIException {
        return this.getResource(this.getApplicationURI(), null).getStream();
    }

    @JsonIgnore
    @XmlTransient
    public InputStream getTestStream() throws APIException {
        return this.getResource(this.getTestURI(), null).getStream();
    }

    @JsonIgnore
    @XmlTransient
    public InputStream getDataStream() throws APIException {
        return this.getResource(this.getDataURI(), null).getStream();
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APIFiles apiFiles = (APIFiles)from;
        this.cloneBase(from);
        this.data = apiFiles.data;
    }

    @XmlRootElement
    public static class RecorderOnlineScreenplayFile
    extends APIFile {
        public RecorderOnlineScreenplayFile() {
        }

        public RecorderOnlineScreenplayFile(String originalName) {
            super(originalName);
        }

        public RecorderOnlineScreenplayFile(Long id, String originalName, Date uploadTime, String readableSize) {
            super(id, originalName, uploadTime, readableSize);
        }

        public static enum Format {
            JAVA("java"),
            JSON("json");

            private String urlForm;

            private Format(String urlForm) {
                this.urlForm = urlForm;
            }

            public static Format fromUrlForm(String url) {
                for (Format f : Format.values()) {
                    if (!f.getUrlForm().equalsIgnoreCase(url)) continue;
                    return f;
                }
                return null;
            }

            public String getUrlForm() {
                return this.urlForm;
            }
        }
    }

    @XmlRootElement
    public static class DataFile
    extends APIFile {
        public DataFile() {
        }

        public DataFile(String originalName) {
            super(originalName);
        }

        public DataFile(Long id, String originalName, Date uploadTime, String readableSize) {
            super(id, originalName, uploadTime, readableSize);
        }
    }

    @XmlRootElement
    public static class UIAutomatorTestFile
    extends APIFile {
        private String jarNames;

        public UIAutomatorTestFile() {
        }

        public UIAutomatorTestFile(String originalName) {
            super(originalName);
        }

        public UIAutomatorTestFile(Long id, String originalName, Date uploadTime, String readableSize, String jarNames) {
            super(id, originalName, uploadTime, readableSize);
            this.jarNames = jarNames;
        }

        public String getJarNames() {
            return this.jarNames;
        }

        public void setJarNames(String jarNames) {
            this.jarNames = jarNames;
        }

        @Override
        @JsonIgnore
        protected <T extends APIEntity> void clone(T from) {
            super.clone(from);
            UIAutomatorTestFile uiAutomatorTestFile = (UIAutomatorTestFile)from;
            this.jarNames = uiAutomatorTestFile.jarNames;
        }
    }

    @XmlRootElement
    public static class CalabashTestFile
    extends APIFile {
        public CalabashTestFile() {
        }

        public CalabashTestFile(String originalName) {
            super(originalName);
        }

        public CalabashTestFile(Long id, String originalName, Date uploadTime, String readableSize) {
            super(id, originalName, uploadTime, readableSize);
        }
    }

    @XmlRootElement
    public static class TelerikTestFile
    extends APIFile {
        public TelerikTestFile() {
        }

        public TelerikTestFile(String originalName) {
            super(originalName);
        }

        public TelerikTestFile(Long id, String originalName, Date uploadTime, String readableSize) {
            super(id, originalName, uploadTime, readableSize);
        }
    }

    @XmlRootElement
    public static class IOSTestFile
    extends APIFile {
        public IOSTestFile() {
        }

        public IOSTestFile(String originalName) {
            super(originalName);
        }

        public IOSTestFile(Long id, String originalName, Date uploadTime, String readableSize) {
            super(id, originalName, uploadTime, readableSize);
        }
    }

    @XmlRootElement
    public static class IOSAppFile
    extends APIFile {
        private String bundleIdentifier;
        private String bundleName;

        public IOSAppFile() {
        }

        public IOSAppFile(String originalName) {
            super(originalName);
        }

        public IOSAppFile(Long id, String originalName, Date uploadTime, String readableSize, String bundleName, String bundleIdentifier) {
            super(id, originalName, uploadTime, readableSize);
            this.bundleName = bundleName;
            this.bundleIdentifier = bundleIdentifier;
        }

        public String getBundleName() {
            return this.bundleName;
        }

        public void setBundleName(String bundleName) {
            this.bundleName = bundleName;
        }

        public String getBundleIdentifier() {
            return this.bundleIdentifier;
        }

        public void setBundleIdentifier(String bundleIdentifier) {
            this.bundleIdentifier = bundleIdentifier;
        }

        @Override
        @JsonIgnore
        protected <T extends APIEntity> void clone(T from) {
            super.clone(from);
            IOSAppFile iosAppFile = (IOSAppFile)from;
            this.bundleIdentifier = iosAppFile.bundleIdentifier;
            this.bundleName = iosAppFile.bundleName;
        }
    }

    @XmlRootElement
    public static class AndroidTestFile
    extends APIFile {
        private String mainActivity;
        private Integer minSdk;
        private String packageName;

        public AndroidTestFile() {
        }

        public AndroidTestFile(String originalName) {
            super(originalName);
        }

        public AndroidTestFile(Long id, String originalName, Date uploadTime, String readableSize, String packageName, String mainActivity, Integer minSdk) {
            super(id, originalName, uploadTime, readableSize);
            this.packageName = packageName;
            this.mainActivity = mainActivity;
            this.minSdk = minSdk;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getMainActivity() {
            return this.mainActivity;
        }

        public void setMainActivity(String mainActivity) {
            this.mainActivity = mainActivity;
        }

        public Integer getMinSdk() {
            return this.minSdk;
        }

        public void setMinSdk(Integer minSdk) {
            this.minSdk = minSdk;
        }

        @Override
        @JsonIgnore
        protected <T extends APIEntity> void cloneBase(T from) {
            super.cloneBase(from);
            AndroidTestFile androidTestFile = (AndroidTestFile)from;
            this.mainActivity = androidTestFile.mainActivity;
            this.minSdk = androidTestFile.minSdk;
            this.packageName = androidTestFile.packageName;
        }
    }

    @XmlRootElement
    public static class AndroidAppFile
    extends APIFile {
        public AndroidAppFile() {
        }

        public AndroidAppFile(String originalName) {
            super(originalName);
        }

        public AndroidAppFile(Long id, String originalName, Date uploadTime, String readableSize) {
            super(id, originalName, uploadTime, readableSize);
        }
    }

    @XmlRootElement
    @XmlSeeAlso(value={APIFile.class, AndroidAppFile.class, AndroidTestFile.class, DataFile.class, IOSAppFile.class, IOSTestFile.class, UIAutomatorTestFile.class, RecorderOnlineScreenplayFile.class, CalabashTestFile.class})
    public static abstract class APIFile
    extends APIEntity {
        private String originalName;
        private String readableSize;
        private Date uploadTime;

        public APIFile() {
        }

        public APIFile(String originalName) {
            this.originalName = originalName;
        }

        public APIFile(Long id, String originalName, Date uploadTime, String readableSize) {
            super(id);
            this.originalName = originalName;
            this.uploadTime = uploadTime;
            this.readableSize = readableSize;
        }

        public String getOriginalName() {
            return this.originalName;
        }

        public void setOriginalName(String originalName) {
            this.originalName = originalName;
        }

        public Date getUploadTime() {
            return this.uploadTime;
        }

        public void setUploadTime(Date uploadTime) {
            this.uploadTime = uploadTime;
        }

        public String getReadableSize() {
            return this.readableSize;
        }

        public void setReadableSize(String readableSize) {
            this.readableSize = readableSize;
        }

        @Override
        @JsonIgnore
        protected <T extends APIEntity> void clone(T from) {
            APIFile apiFile = (APIFile)from;
            this.cloneBase(from);
            this.originalName = apiFile.originalName;
            this.readableSize = apiFile.readableSize;
            this.uploadTime = apiFile.uploadTime;
        }
    }
}

