/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIListResource;
import com.testdroid.api.APIQueryBuilder;
import com.testdroid.api.APISort;
import com.testdroid.api.model.APIDeviceGroup;
import com.testdroid.api.model.APIFiles;
import com.testdroid.api.model.APINotificationEmail;
import com.testdroid.api.model.APIProjectJobConfig;
import com.testdroid.api.model.APIProjectSharing;
import com.testdroid.api.model.APITestRun;
import com.testdroid.api.model.APITestRunConfig;
import com.testdroid.api.model.APITestRunParameter;
import com.testdroid.api.model.AndroidFiles;
import com.testdroid.api.model.AppiumAndroidFiles;
import com.testdroid.api.model.AppiumIOSFiles;
import com.testdroid.api.model.CalabashFiles;
import com.testdroid.api.model.CalabashIOSFiles;
import com.testdroid.api.model.IOSFiles;
import com.testdroid.api.model.RecorderOnlineFiles;
import com.testdroid.api.model.RemoteControlFiles;
import com.testdroid.api.model.TelerikAndroidFiles;
import com.testdroid.api.model.TelerikIOSFiles;
import com.testdroid.api.model.UIAutomatorFiles;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonIgnore;

@XmlRootElement
public class APIProject
extends APIEntity {
    private Integer archivingItemCount;
    private APIArchivingStrategy archivingStrategy;
    private boolean common;
    private String description;
    private APIFiles files;
    private byte[] icon;
    private Map<APIProjectJobConfig.Type, APIProjectJobConfig> jobConfig;
    private String name;
    private String sharedByEmail;
    private Long sharedById;
    private APITestRunConfig testRunConfig;
    private Type type;
    private Date createTime;

    public APIProject() {
    }

    public APIProject(Long id, Date createTime, String name, String description, Type type, Long sharedById, String sharedByEmail, boolean common, APIArchivingStrategy archivingStrategy, Integer archivingItemCount) {
        super(id);
        this.createTime = createTime;
        this.name = name;
        this.description = description;
        this.type = type;
        this.sharedById = sharedById;
        this.sharedByEmail = sharedByEmail;
        this.common = common;
        this.archivingStrategy = archivingStrategy;
        this.archivingItemCount = archivingItemCount;
        this.jobConfig = new HashMap<APIProjectJobConfig.Type, APIProjectJobConfig>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isCommon() {
        return this.common;
    }

    public void setCommon(boolean common) {
        this.common = common;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getSharedById() {
        return this.sharedById;
    }

    public void setSharedById(Long sharedById) {
        this.sharedById = sharedById;
    }

    public String getSharedByEmail() {
        return this.sharedByEmail;
    }

    public void setSharedByEmail(String sharedByEmail) {
        this.sharedByEmail = sharedByEmail;
    }

    public APIArchivingStrategy getArchivingStrategy() {
        return this.archivingStrategy;
    }

    public void setArchivingStrategy(APIArchivingStrategy archivingStrategy) {
        this.archivingStrategy = archivingStrategy;
    }

    public Integer getArchivingItemCount() {
        return this.archivingItemCount;
    }

    public void setArchivingItemCount(Integer archivingItemCount) {
        this.archivingItemCount = archivingItemCount;
    }

    public String getArchivingStrategyDisplayValue() {
        switch (this.archivingStrategy) {
            case NEVER: {
                return "never";
            }
            case RUNS: {
                return String.format("%s run%s", this.archivingItemCount, this.archivingItemCount != 1 ? "s" : "");
            }
            case DAYS: {
                return String.format("%s day%s", this.archivingItemCount, this.archivingItemCount != 1 ? "s" : "");
            }
        }
        return "";
    }

    private String getConfigURI() {
        return APIProject.createUri(this.selfURI, "/config");
    }

    private String getJobConfigURI(APIProjectJobConfig.Type type) {
        return APIProject.createUri(this.selfURI, "/job-configs/" + type.toString());
    }

    private String getFilesURI() {
        return APIProject.createUri(this.selfURI, "/files");
    }

    private String getIconURI() {
        return APIProject.createUri(this.selfURI, "/icon");
    }

    private String getSharingsURI() {
        return APIProject.createUri(this.selfURI, "/sharings");
    }

    private String getRunsURI() {
        return APIProject.createUri(this.selfURI, "/runs");
    }

    private String getRunURI(Long id) {
        return APIProject.createUri(this.selfURI, "/runs/" + id);
    }

    private String getPublicDeviceGroupsURI() {
        return APIProject.createUri(this.selfURI, "/public-device-groups");
    }

    private String getDeviceGroupsURI() {
        return APIProject.createUri(this.selfURI, "/device-groups");
    }

    private String getUploadApplicationURI() {
        return APIProject.createUri(this.selfURI, "/files/application");
    }

    private String getUploadTestURI() {
        return APIProject.createUri(this.selfURI, "/files/test");
    }

    private String getUploadDataURI() {
        return APIProject.createUri(this.selfURI, "/files/data");
    }

    private String getNotificationEmailsURI() {
        return APIProject.createUri(this.selfURI, "/notifications");
    }

    private String getParametersURI() {
        return APIProject.createUri(this.selfURI, "/config/parameters");
    }

    private Map<String, Object> getCreateRunParameters(String testRunName) {
        return Collections.singletonMap("name", testRunName);
    }

    private Map<String, Object> getCreateRunParameters(List<Long> usedDeviceIds) {
        return Collections.singletonMap("usedDeviceIds[]", StringUtils.join(usedDeviceIds, (String)","));
    }

    private Map<String, Object> getCreateRunParameters(String testRunName, List<Long> usedDeviceIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(this.getCreateRunParameters(testRunName));
        result.putAll(this.getCreateRunParameters(usedDeviceIds));
        return result;
    }

    private Map<String, Object> getCreateNotificationParameters(final String email, final APINotificationEmail.Type type) {
        return new HashMap<String, Object>(){
            {
                this.put("email", email);
                this.put("type", type);
            }
        };
    }

    private Map<String, Object> getCreateParameterParameters(final String key, final String value) {
        return new HashMap<String, Object>(){
            {
                this.put("key", key);
                this.put("value", value);
            }
        };
    }

    private Map<String, Object> getShareParameters(final String email) {
        return new HashMap<String, Object>(){
            {
                this.put("email", email);
            }
        };
    }

    @JsonIgnore
    public APITestRunConfig getTestRunConfig() throws APIException {
        if (this.testRunConfig == null) {
            this.testRunConfig = this.getResource(this.getConfigURI(), APITestRunConfig.class).getEntity();
        }
        return this.testRunConfig;
    }

    @JsonIgnore
    public APIProjectJobConfig getJobConfig(APIProjectJobConfig.Type type) throws APIException {
        if (this.jobConfig == null) {
            this.jobConfig = new HashMap<APIProjectJobConfig.Type, APIProjectJobConfig>();
        }
        if (this.jobConfig.get((Object)type) == null) {
            this.jobConfig.put(type, this.getResource(this.getJobConfigURI(type), APIProjectJobConfig.class).getEntity());
        }
        return this.jobConfig.get((Object)type);
    }

    @JsonIgnore
    public <T extends APIFiles> T getFiles(Class<T> clazz) throws APIException {
        if (clazz == null || !clazz.isAssignableFrom(this.type.getFilesClass())) {
            throw new APIException("This project type does not have requested file types");
        }
        if (this.files == null) {
            this.files = (APIFiles)this.getResource(this.getFilesURI(), clazz).getEntity();
        }
        return (T)this.files;
    }

    @JsonIgnore
    public byte[] getIcon() throws APIException, IOException {
        if (this.icon == null) {
            this.icon = IOUtils.toByteArray((InputStream)this.getResource(this.getIconURI(), null).getStream());
        }
        return this.icon;
    }

    @JsonIgnore
    public APITestRun run() throws APIException {
        return this.postResource(this.getRunsURI(), null, APITestRun.class);
    }

    @JsonIgnore
    public APITestRun run(String testRunName) throws APIException {
        return this.postResource(this.getRunsURI(), this.getCreateRunParameters(testRunName), APITestRun.class);
    }

    @JsonIgnore
    public APITestRun run(List<Long> usedDevicesId) throws APIException {
        return this.postResource(this.getRunsURI(), this.getCreateRunParameters(usedDevicesId), APITestRun.class);
    }

    @JsonIgnore
    public APITestRun run(String testRunName, List<Long> usedDevicesId) throws APIException {
        return this.postResource(this.getRunsURI(), this.getCreateRunParameters(testRunName, usedDevicesId), APITestRun.class);
    }

    public void delete() throws APIException {
        this.deleteResource(this.selfURI);
    }

    @JsonIgnore
    public APIListResource<APITestRun> getTestRunsResource() throws APIException {
        return this.getListResource(this.getRunsURI());
    }

    @JsonIgnore
    public APIListResource<APITestRun> getTestRunsResource(APIQueryBuilder queryBuilder) throws APIException {
        return this.getListResource(this.getRunsURI(), queryBuilder);
    }

    public APITestRun getTestRun(Long id) throws APIException {
        return this.getResource(this.getRunURI(id), APITestRun.class).getEntity();
    }

    @JsonIgnore
    public APIListResource<APITestRun> getTestRunsResource(long offset, long limit, String search, APISort sort) throws APIException {
        return this.getListResource(this.getRunsURI(), offset, limit, search, sort, APITestRun.class);
    }

    @JsonIgnore
    public APIProjectSharing share(String email) throws APIException {
        return this.postResource(this.getSharingsURI(), this.getShareParameters(email), APIProjectSharing.class);
    }

    @JsonIgnore
    public APIListResource<APIProjectSharing> getProjectSharings() throws APIException {
        return this.getListResource(this.getSharingsURI());
    }

    @JsonIgnore
    public APIListResource<APIProjectSharing> getProjectSharings(APIQueryBuilder queryBuilder) throws APIException {
        return this.getListResource(this.getSharingsURI(), queryBuilder);
    }

    @JsonIgnore
    public APIListResource<APIProjectSharing> getProjectSharings(long offset, long limit, String search, APISort sort) throws APIException {
        return this.getListResource(this.getSharingsURI(), offset, limit, search, sort, APIProjectSharing.class);
    }

    @JsonIgnore
    public APIListResource<APIDeviceGroup> getPublicDeviceGroups() throws APIException {
        return this.getListResource(this.getPublicDeviceGroupsURI());
    }

    @JsonIgnore
    public APIListResource<APIDeviceGroup> getDeviceGroups() throws APIException {
        return this.getListResource(this.getDeviceGroupsURI());
    }

    @JsonIgnore
    public APINotificationEmail createNotificationEmail(String email, APINotificationEmail.Type type) throws APIException {
        return this.postResource(this.getNotificationEmailsURI(), this.getCreateNotificationParameters(email, type), APINotificationEmail.class);
    }

    @JsonIgnore
    public APIListResource<APINotificationEmail> getNotificationEmails() throws APIException {
        return this.getListResource(this.getNotificationEmailsURI());
    }

    @JsonIgnore
    public APIListResource<APINotificationEmail> getNotificationEmails(APIQueryBuilder queryBuilder) throws APIException {
        return this.getListResource(this.getNotificationEmailsURI(), queryBuilder);
    }

    @JsonIgnore
    public APIFiles.APIFile uploadApplication(File file, String contentType) throws APIException {
        return this.postFile(this.getUploadApplicationURI(), file, contentType, APIFiles.APIFile.class);
    }

    @JsonIgnore
    public APIFiles.APIFile uploadTest(File file, String contentType) throws APIException {
        return this.postFile(this.getUploadTestURI(), file, contentType, APIFiles.APIFile.class);
    }

    @JsonIgnore
    public APIFiles.APIFile uploadData(File file, String contentType) throws APIException {
        return this.postFile(this.getUploadDataURI(), file, contentType, APIFiles.APIFile.class);
    }

    @JsonIgnore
    public APITestRunParameter createParameter(String key, String value) throws APIException {
        return this.postResource(this.getParametersURI(), this.getCreateParameterParameters(key, value), APITestRunParameter.class);
    }

    @JsonIgnore
    public APIListResource<APITestRunParameter> getParameters() throws APIException {
        return this.getListResource(this.getParametersURI());
    }

    @JsonIgnore
    public APIListResource<APITestRunParameter> getParameters(APIQueryBuilder queryBuilder) throws APIException {
        return this.getListResource(this.getParametersURI(), queryBuilder);
    }

    @JsonIgnore
    public void deleteParameter(long parameterId) throws APIException {
        this.deleteResource(String.format("%s/%s", this.getParametersURI(), parameterId));
    }

    public void update() throws APIException {
        HashMap<String, Object> body = new HashMap<String, Object>(){
            {
                this.put("name", APIProject.this.name);
                this.put("description", APIProject.this.description);
                this.put("common", APIProject.this.common);
                this.put("archivingStrategy", APIProject.this.archivingStrategy.name());
                this.put("archivingItemCount", APIProject.this.archivingItemCount);
            }
        };
        APIProject project = this.postResource(this.selfURI, body, APIProject.class);
        this.clone(project);
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APIProject apiProject = (APIProject)from;
        this.cloneBase(from);
        this.common = apiProject.common;
        this.createTime = apiProject.createTime;
        this.description = apiProject.description;
        this.files = apiProject.files;
        this.icon = apiProject.icon;
        this.jobConfig = apiProject.jobConfig;
        this.name = apiProject.name;
        this.sharedById = apiProject.sharedById;
        this.testRunConfig = apiProject.testRunConfig;
        this.type = apiProject.type;
        this.archivingStrategy = apiProject.archivingStrategy;
        this.archivingItemCount = apiProject.archivingItemCount;
    }

    @XmlType(namespace="APIProject")
    public static enum Type {
        ANDROID,
        CTS,
        IOS,
        UIAUTOMATOR,
        REMOTECONTROL,
        RECORDERONLINE,
        CALABASH,
        CALABASH_IOS,
        APPIUM_ANDROID,
        APPIUM_IOS,
        TELERIK_ANDROID,
        TELERIK_IOS;


        public Class<? extends APIFiles> getFilesClass() {
            switch (this) {
                case ANDROID: {
                    return AndroidFiles.class;
                }
                case CTS: {
                    return null;
                }
                case IOS: {
                    return IOSFiles.class;
                }
                case UIAUTOMATOR: {
                    return UIAutomatorFiles.class;
                }
                case REMOTECONTROL: {
                    return RemoteControlFiles.class;
                }
                case RECORDERONLINE: {
                    return RecorderOnlineFiles.class;
                }
                case CALABASH: {
                    return CalabashFiles.class;
                }
                case CALABASH_IOS: {
                    return CalabashIOSFiles.class;
                }
                case APPIUM_ANDROID: {
                    return AppiumAndroidFiles.class;
                }
                case APPIUM_IOS: {
                    return AppiumIOSFiles.class;
                }
                case TELERIK_ANDROID: {
                    return TelerikAndroidFiles.class;
                }
                case TELERIK_IOS: {
                    return TelerikIOSFiles.class;
                }
            }
            return null;
        }
    }

    @XmlType(namespace="APIProject")
    public static enum APIArchivingStrategy {
        NEVER,
        DAYS,
        RUNS;

    }
}

