/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIListResource;
import com.testdroid.api.APIQueryBuilder;
import com.testdroid.api.APISort;
import com.testdroid.api.model.APIDeviceRun;
import com.testdroid.api.model.APIFiles;
import com.testdroid.api.model.APITag;
import com.testdroid.api.model.APITestRunConfig;
import com.testdroid.api.model.APIUserFile;
import java.util.Collections;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.jackson.annotate.JsonIgnore;

@XmlRootElement
public class APITestRun
extends APIEntity {
    protected APITestRunConfig config;
    protected Date createTime;
    protected String displayName;
    protected Float executionRatio;
    protected APIFiles files;
    protected Integer number;
    protected Long projectId;
    protected String startedByDisplayName;
    protected State state;
    protected Float successRatio;
    protected Long screenshotsFileId;
    protected Long logsFileId;

    public APITestRun() {
    }

    public APITestRun(Long id, Integer number, Date createTime, String displayName, Float executionRatio, Float successRatio, String startedByDisplayName, State state, Long projectId, Long screenshotsFileId, Long logsFileId) {
        super(id);
        this.number = number;
        this.createTime = createTime;
        this.displayName = displayName;
        this.executionRatio = executionRatio;
        this.successRatio = successRatio;
        this.startedByDisplayName = startedByDisplayName;
        this.state = state;
        this.projectId = projectId;
        this.screenshotsFileId = screenshotsFileId;
        this.logsFileId = logsFileId;
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Float getExecutionRatio() {
        return this.executionRatio;
    }

    public void setExecutionRatio(Float executionRatio) {
        this.executionRatio = executionRatio;
    }

    public Float getSuccessRatio() {
        return this.successRatio;
    }

    public void setSuccessRatio(Float successRatio) {
        this.successRatio = successRatio;
    }

    public String getStartedByDisplayName() {
        return this.startedByDisplayName;
    }

    public void setStartedByDisplayName(String startedByDisplayName) {
        this.startedByDisplayName = startedByDisplayName;
    }

    public Long getScreenshotsFileId() {
        return this.screenshotsFileId;
    }

    public void setScreenshotsFileId(Long screenshotsFileId) {
        this.screenshotsFileId = screenshotsFileId;
    }

    public Long getLogsFileId() {
        return this.logsFileId;
    }

    public void setLogsFileId(Long logsFileId) {
        this.logsFileId = logsFileId;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    private String getFilesURI() {
        return APITestRun.createUri(this.selfURI, "/files");
    }

    private String getConfigURI() {
        return APITestRun.createUri(this.selfURI, "/config");
    }

    private String getTagsURI() {
        return APITestRun.createUri(this.selfURI, "/tags");
    }

    private String getDeviceRunsURI() {
        return APITestRun.createUri(this.selfURI, "/device-runs");
    }

    private String getRequestScreenshotsZipURI() {
        return APITestRun.createUri(this.selfURI, "/screenshots.zip");
    }

    private String getRequestLogsZipURI() {
        return APITestRun.createUri(this.selfURI, "/logs.zip");
    }

    private String getAbortURI() {
        return APITestRun.createUri(this.selfURI, "/abort");
    }

    private String getLogsZipURI() {
        return String.format("/files/%s", this.logsFileId);
    }

    private String getScreenshotsZipURI() {
        return String.format("/files/%s", this.screenshotsFileId);
    }

    @JsonIgnore
    public <T extends APIFiles> T getFiles(Class<T> clazz) throws APIException {
        if (this.files == null) {
            this.files = (APIFiles)this.getResource(this.getFilesURI(), clazz).getEntity();
        }
        return (T)this.files;
    }

    public void delete() throws APIException {
        this.deleteResource(this.selfURI);
    }

    @JsonIgnore
    public APITestRunConfig getConfig() throws APIException {
        if (this.config == null) {
            this.config = this.getResource(this.getConfigURI(), APITestRunConfig.class).getEntity();
        }
        return this.config;
    }

    public APITag addTag(String name) throws APIException {
        return this.postResource(this.getTagsURI(), Collections.singletonMap("name", name), APITag.class);
    }

    @JsonIgnore
    public APIListResource<APITag> getTagsResource() throws APIException {
        return this.getListResource(this.getTagsURI());
    }

    @JsonIgnore
    public APIListResource<APITag> getTagsResource(APIQueryBuilder queryBuilder) throws APIException {
        return this.getListResource(this.getTagsURI(), queryBuilder);
    }

    @JsonIgnore
    public APIListResource<APITag> getTagsResource(long offset, long limit, String search, APISort sort) throws APIException {
        return this.getListResource(this.getTagsURI(), offset, limit, search, sort, APITag.class);
    }

    @JsonIgnore
    public APIListResource<APIDeviceRun> getDeviceRunsResource() throws APIException {
        return this.getListResource(this.getDeviceRunsURI());
    }

    @JsonIgnore
    public APIListResource<APIDeviceRun> getDeviceRunsResource(APIQueryBuilder queryBuilder) throws APIException {
        return this.getListResource(this.getDeviceRunsURI(), queryBuilder);
    }

    @JsonIgnore
    public APIListResource<APIDeviceRun> getDeviceRunsResource(long offset, long limit, String search, APISort sort) throws APIException {
        return this.getListResource(this.getDeviceRunsURI(), offset, limit, search, sort, APIDeviceRun.class);
    }

    @JsonIgnore
    public void requestScreenshotsZip() throws APIException {
        APIUserFile result = this.postResource(this.getRequestScreenshotsZipURI(), null, APIUserFile.class);
        this.screenshotsFileId = result.getId();
    }

    @JsonIgnore
    public void requestLogsZip() throws APIException {
        APIUserFile result = this.postResource(this.getRequestLogsZipURI(), null, APIUserFile.class);
        this.logsFileId = result.getId();
    }

    @JsonIgnore
    public APIUserFile getScreenshotsZip() throws APIException {
        return super.getResource(this.getScreenshotsZipURI(), APIUserFile.class).getEntity();
    }

    @JsonIgnore
    public APIUserFile getLogsZip() throws APIException {
        return super.getResource(this.getLogsZipURI(), APIUserFile.class).getEntity();
    }

    public void update() throws APIException {
        APITestRun testRun = this.postResource(this.selfURI, Collections.singletonMap("displayName", this.displayName), APITestRun.class);
        this.clone(testRun);
    }

    public void abort() throws APIException {
        this.postResource(this.getAbortURI(), null, null);
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APITestRun apiTestRun = (APITestRun)from;
        this.cloneBase(from);
        this.config = apiTestRun.config;
        this.createTime = apiTestRun.createTime;
        this.displayName = apiTestRun.displayName;
        this.executionRatio = apiTestRun.executionRatio;
        this.files = apiTestRun.files;
        this.number = apiTestRun.number;
        this.startedByDisplayName = apiTestRun.startedByDisplayName;
        this.state = apiTestRun.state;
        this.successRatio = apiTestRun.successRatio;
        this.projectId = apiTestRun.projectId;
        this.screenshotsFileId = apiTestRun.screenshotsFileId;
        this.logsFileId = apiTestRun.logsFileId;
    }

    @XmlType(namespace="APITestRun", name="APITestRunState")
    public static enum State {
        WAITING,
        RUNNING,
        FINISHED;

    }
}

