/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIListResource;
import com.testdroid.api.APIQueryBuilder;
import com.testdroid.api.model.APITestRunParameter;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.jackson.annotate.JsonIgnore;

@XmlRootElement
public class APITestRunConfig
extends APIEntity {
    private boolean appRequired;
    private String applicationPassword;
    private String applicationUsername;
    private boolean autoScreenshots;
    private boolean checkApp;
    private Integer creditsPrice;
    private String deviceLanguageCode;
    private String hookURL;
    private String instrumentationRunner;
    private boolean launchApp;
    private LimitationType limitationType;
    private String limitationValue;
    private Mode mode;
    private Long projectId;
    private boolean runAvailable;
    private Scheduler scheduler;
    private String screenshotDir;
    private String uiAutomatorTestClasses;
    private Long usedDeviceGroupId;
    private String withAnnotation;
    private String withoutAnnotation;
    private Long timeout;

    public APITestRunConfig() {
    }

    public APITestRunConfig(Long id, Long projectId, Scheduler scheduler, Mode mode, boolean autoScreenshots, boolean runAvailable, String screenshotDir, LimitationType limitationType, String limitationValue, String withAnnotation, String withoutAnnotation, String applicationUsername, String applicationPassword, Long usedClusterId, Integer creditsPrice, String deviceLanguageCode, String hookURL, String uiAutomatorTestClasses, Boolean launchApp, String instrumentationRunner, Boolean checkApp, Boolean appRequired, Long timeout) {
        super(id);
        this.projectId = projectId;
        this.scheduler = scheduler;
        this.mode = mode;
        this.autoScreenshots = autoScreenshots;
        this.runAvailable = runAvailable;
        this.screenshotDir = screenshotDir;
        this.limitationType = limitationType;
        this.limitationValue = limitationValue;
        this.withAnnotation = withAnnotation;
        this.withoutAnnotation = withoutAnnotation;
        this.applicationUsername = applicationUsername;
        this.applicationPassword = applicationPassword;
        this.usedDeviceGroupId = usedClusterId;
        this.creditsPrice = creditsPrice;
        this.deviceLanguageCode = deviceLanguageCode;
        this.hookURL = hookURL;
        this.uiAutomatorTestClasses = uiAutomatorTestClasses;
        this.launchApp = launchApp;
        this.instrumentationRunner = instrumentationRunner;
        this.checkApp = checkApp;
        this.appRequired = appRequired;
        this.timeout = timeout;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public LimitationType getLimitationType() {
        return this.limitationType;
    }

    public void setLimitationType(LimitationType limitationType) {
        this.limitationType = limitationType;
    }

    public boolean isAutoScreenshots() {
        return this.autoScreenshots;
    }

    public void setAutoScreenshots(boolean autoScreenshots) {
        this.autoScreenshots = autoScreenshots;
    }

    public boolean isRunAvailable() {
        return this.runAvailable;
    }

    public void setRunAvailable(boolean runAvailable) {
        this.runAvailable = runAvailable;
    }

    public String getScreenshotDir() {
        return this.screenshotDir;
    }

    public void setScreenshotDir(String screenshotDir) {
        this.screenshotDir = screenshotDir;
    }

    public String getLimitationValue() {
        return this.limitationValue;
    }

    public void setLimitationValue(String limitationValue) {
        this.limitationValue = limitationValue;
    }

    public String getWithAnnotation() {
        return this.withAnnotation;
    }

    public void setWithAnnotation(String withAnnotation) {
        this.withAnnotation = withAnnotation;
    }

    public String getWithoutAnnotation() {
        return this.withoutAnnotation;
    }

    public void setWithoutAnnotation(String withoutAnnotation) {
        this.withoutAnnotation = withoutAnnotation;
    }

    public String getApplicationUsername() {
        return this.applicationUsername;
    }

    public void setApplicationUsername(String applicationUsername) {
        this.applicationUsername = applicationUsername;
    }

    public String getApplicationPassword() {
        return this.applicationPassword;
    }

    public void setApplicationPassword(String applicationPassword) {
        this.applicationPassword = applicationPassword;
    }

    public Long getUsedDeviceGroupId() {
        return this.usedDeviceGroupId;
    }

    public void setUsedDeviceGroupId(Long usedDeviceGroupId) {
        this.usedDeviceGroupId = usedDeviceGroupId;
    }

    public Integer getCreditsPrice() {
        return this.creditsPrice;
    }

    public void setCreditsPrice(Integer creditsPrice) {
        this.creditsPrice = creditsPrice;
    }

    public String getDeviceLanguageCode() {
        return this.deviceLanguageCode;
    }

    public void setDeviceLanguageCode(String deviceLanguageCode) {
        this.deviceLanguageCode = deviceLanguageCode;
    }

    public String getHookURL() {
        return this.hookURL;
    }

    public void setHookURL(String hookURL) {
        this.hookURL = hookURL;
    }

    public String getUiAutomatorTestClasses() {
        return this.uiAutomatorTestClasses;
    }

    public void setUiAutomatorTestClasses(String uiAutomatorTestClasses) {
        this.uiAutomatorTestClasses = uiAutomatorTestClasses;
    }

    public boolean isLaunchApp() {
        return this.launchApp;
    }

    public void setLaunchApp(boolean launchApp) {
        this.launchApp = launchApp;
    }

    public String getInstrumentationRunner() {
        return this.instrumentationRunner;
    }

    public void setInstrumentationRunner(String instrumentationRunner) {
        this.instrumentationRunner = instrumentationRunner;
    }

    public boolean isCheckApp() {
        return this.checkApp;
    }

    public void setCheckApp(boolean checkApp) {
        this.checkApp = checkApp;
    }

    public boolean isAppRequired() {
        return this.appRequired;
    }

    public void setAppRequired(boolean appRequired) {
        this.appRequired = appRequired;
    }

    private String getParametersURI() {
        return APITestRunConfig.createUri(this.selfURI, "/parameters");
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    @JsonIgnore
    public APITestRunParameter createParameter(final String key, final String value) throws APIException {
        HashMap<String, Object> body = new HashMap<String, Object>(){
            {
                this.put("key", key);
                this.put("value", value);
            }
        };
        return this.postResource(this.getParametersURI(), body, APITestRunParameter.class);
    }

    @JsonIgnore
    public APIListResource<APITestRunParameter> getParameters() throws APIException {
        return this.getListResource(this.getParametersURI());
    }

    @JsonIgnore
    public APIListResource<APITestRunParameter> getParameters(APIQueryBuilder queryBuilder) throws APIException {
        return this.getListResource(this.getParametersURI(), queryBuilder);
    }

    @JsonIgnore
    public void deleteParameter(long parameterId) throws APIException {
        this.deleteResource(String.format("%s/%s", this.getParametersURI(), parameterId));
    }

    public void update() throws APIException {
        HashMap<String, Object> body = new HashMap<String, Object>(){
            {
                this.put("scheduler", APITestRunConfig.this.scheduler != null ? APITestRunConfig.this.scheduler.name() : null);
                this.put("mode", APITestRunConfig.this.mode != null ? APITestRunConfig.this.mode.name() : null);
                this.put("autoScreenshots", APITestRunConfig.this.autoScreenshots);
                this.put("screenshotDir", APITestRunConfig.this.screenshotDir);
                this.put("limitationType", APITestRunConfig.this.limitationType != null ? APITestRunConfig.this.limitationType.name() : null);
                this.put("limitationValue", APITestRunConfig.this.limitationValue);
                this.put("withAnnotation", APITestRunConfig.this.withAnnotation);
                this.put("withoutAnnotation", APITestRunConfig.this.withoutAnnotation);
                this.put("applicationUsername", APITestRunConfig.this.applicationUsername);
                this.put("applicationPassword", APITestRunConfig.this.applicationPassword);
                this.put("usedDeviceGroupId", APITestRunConfig.this.usedDeviceGroupId);
                this.put("deviceLanguageCode", APITestRunConfig.this.deviceLanguageCode);
                this.put("hookURL", APITestRunConfig.this.hookURL);
                this.put("uiAutomatorTestClasses", APITestRunConfig.this.uiAutomatorTestClasses);
                this.put("launchApp", APITestRunConfig.this.launchApp);
                this.put("instrumentationRunner", APITestRunConfig.this.instrumentationRunner);
                this.put("checkApp", APITestRunConfig.this.checkApp);
                this.put("appRequired", APITestRunConfig.this.appRequired);
                this.put("timeout", APITestRunConfig.this.timeout);
            }
        };
        APITestRunConfig config = this.postResource(this.selfURI, body, APITestRunConfig.class);
        this.clone(config);
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APITestRunConfig apiTestRunConfig = (APITestRunConfig)from;
        this.cloneBase(from);
        this.applicationPassword = apiTestRunConfig.applicationPassword;
        this.applicationUsername = apiTestRunConfig.applicationUsername;
        this.appRequired = apiTestRunConfig.appRequired;
        this.autoScreenshots = apiTestRunConfig.autoScreenshots;
        this.checkApp = apiTestRunConfig.checkApp;
        this.creditsPrice = apiTestRunConfig.creditsPrice;
        this.deviceLanguageCode = apiTestRunConfig.deviceLanguageCode;
        this.hookURL = apiTestRunConfig.hookURL;
        this.instrumentationRunner = apiTestRunConfig.instrumentationRunner;
        this.launchApp = apiTestRunConfig.launchApp;
        this.limitationType = apiTestRunConfig.limitationType;
        this.limitationValue = apiTestRunConfig.limitationValue;
        this.mode = apiTestRunConfig.mode;
        this.projectId = apiTestRunConfig.projectId;
        this.runAvailable = apiTestRunConfig.runAvailable;
        this.scheduler = apiTestRunConfig.scheduler;
        this.screenshotDir = apiTestRunConfig.screenshotDir;
        this.uiAutomatorTestClasses = apiTestRunConfig.uiAutomatorTestClasses;
        this.usedDeviceGroupId = apiTestRunConfig.usedDeviceGroupId;
        this.withAnnotation = apiTestRunConfig.withAnnotation;
        this.withoutAnnotation = apiTestRunConfig.withoutAnnotation;
        this.timeout = apiTestRunConfig.timeout;
    }

    @XmlType(namespace="APITestRunConfig")
    public static enum Scheduler {
        PARALLEL,
        SERIAL,
        SINGLE;

    }

    @XmlType(namespace="APITestRunConfig")
    public static enum Mode {
        FULL_RUN("Full run"),
        APP_CRAWLER("App crawler"),
        CTS("CTS"),
        IOS("iOS"),
        UIAUTOMATOR("UIAutomator"),
        REMOTECONTROL("Remote control"),
        RECORDERONLINE("Recorder online"),
        CALABASH("Calabash Android"),
        CALABASH_IOS("Calabash iOS"),
        APPIUM_ANDROID("Appium Android"),
        APPIUM_IOS("Appium iOS"),
        IOS_CRAWLER("iOS App crawler"),
        TELERIK_ANDROID("Telerik Android"),
        TELERIK_IOS("Telerik iOS");

        private String friendlyName;

        private Mode(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }
    }

    @XmlType(namespace="APITestRunConfig")
    public static enum LimitationType {
        PACKAGE,
        CLASS;

    }
}

