/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIListResource;
import com.testdroid.api.APIQueryBuilder;
import com.testdroid.api.APISort;
import com.testdroid.api.model.APIDevice;
import com.testdroid.api.model.APIDeviceGroup;
import com.testdroid.api.model.APINotificationEmail;
import com.testdroid.api.model.APIProject;
import com.testdroid.api.model.APIRole;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.jackson.annotate.JsonIgnore;

@XmlRootElement
public class APIUser
extends APIEntity {
    private String address;
    private String city;
    private String code;
    private String country;
    private String email;
    private boolean enabled;
    private String name;
    private String organization;
    private String phone;
    private APIRole[] roles;
    private String state;
    private String timeZone;
    private String vatID;
    private Date createTime;
    private EmailNotification emailNotification;
    private Boolean isMainUser;

    public APIUser() {
    }

    public APIUser(Long id, String email, String name, String state, String country, String city, String code, String address, String phone, String organization, String vatID, String timeZone, boolean enabled, EmailNotification emailNotification, Date createTime, APIRole ... roles) {
        super(id);
        this.email = email;
        this.name = name;
        this.state = state;
        this.country = country;
        this.city = city;
        this.code = code;
        this.address = address;
        this.phone = phone;
        this.organization = organization;
        this.vatID = vatID;
        this.timeZone = timeZone;
        this.enabled = enabled;
        this.emailNotification = emailNotification;
        this.roles = roles;
        this.createTime = createTime;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getVatID() {
        return this.vatID;
    }

    public void setVatID(String vatID) {
        this.vatID = vatID;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getIsMainUser() {
        return this.isMainUser;
    }

    public void setIsMainUser(Boolean isMainUser) {
        this.isMainUser = isMainUser;
    }

    public APIRole[] getRoles() {
        return this.roles;
    }

    public void setRoles(APIRole[] roles) {
        this.roles = roles;
    }

    public EmailNotification getEmailNotification() {
        return this.emailNotification;
    }

    public void setEmailNotification(EmailNotification emailNotification) {
        this.emailNotification = emailNotification;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    private String getProjectsURI() {
        return APIUser.createUri(this.selfURI, "/projects");
    }

    private String getProjectURI(Long id) {
        return APIUser.createUri(this.selfURI, "/projects/" + id);
    }

    private String getDeviceGroupsURI() {
        return APIUser.createUri(this.selfURI, "/device-groups");
    }

    private String getNotificationsURI() {
        return APIUser.createUri(this.selfURI, "/notifications");
    }

    private String getNotificationURI(long id) {
        return APIUser.createUri(this.selfURI, "/notifications/" + id);
    }

    private String getAvailbleProjectTypesURI() {
        return APIUser.createUri(this.selfURI, "/available-project-types");
    }

    private Map<String, Object> getNotificationEmailParams(final APINotificationEmail.Type type) {
        return new HashMap<String, Object>(){
            {
                this.put("type", type);
            }
        };
    }

    private Map<String, Object> getNotificationEmailParams(String email, APINotificationEmail.Type type) {
        Map<String, Object> result = this.getNotificationEmailParams(type);
        result.put("email", email);
        return result;
    }

    private Map<String, Object> getUpdateUserParams(final String address, final String city, final String code, final String country, final String email, final String name, final String organization, final String phone, final String state, final String timeZone, final String vatId) {
        return new HashMap<String, Object>(){
            {
                this.put("address", address);
                this.put("city", city);
                this.put("code", code);
                this.put("country", country);
                this.put("email", email);
                this.put("name", name);
                this.put("organization", organization);
                this.put("phone", phone);
                this.put("state", state);
                this.put("timeZone", timeZone);
                this.put("vatId", vatId);
            }
        };
    }

    private Map<String, Object> getCreateDeviceGroupParams(final String name, final APIDevice.OsType osType) {
        return new HashMap<String, Object>(){
            {
                this.put("name", name);
                this.put("osType", osType);
            }
        };
    }

    private Map<String, Object> getCreateProjectParams(final APIProject.Type type) {
        return new HashMap<String, Object>(){
            {
                this.put("type", type);
            }
        };
    }

    private Map<String, Object> getCreateProjectParams(APIProject.Type type, String name) {
        Map<String, Object> result = this.getCreateProjectParams(type);
        result.put("name", name);
        return result;
    }

    public APIProject createProject(APIProject.Type projectType) throws APIException {
        return this.postResource(this.getProjectsURI(), this.getCreateProjectParams(projectType), APIProject.class);
    }

    public APIProject createProject(APIProject.Type type, String name) throws APIException {
        return this.postResource(this.getProjectsURI(), this.getCreateProjectParams(type, name), APIProject.class);
    }

    public void update() throws APIException {
        APIUser user = this.postResource(this.selfURI, this.getUpdateUserParams(this.address, this.city, this.code, this.country, this.email, this.name, this.organization, this.phone, this.state, this.timeZone, this.vatID), APIUser.class);
        this.clone(user);
    }

    @JsonIgnore
    public APIListResource<APIProject> getProjectsResource() throws APIException {
        return this.getListResource(this.getProjectsURI());
    }

    @JsonIgnore
    public APIListResource<APIProject> getProjectsResource(APIQueryBuilder queryBuilder) throws APIException {
        return this.getListResource(this.getProjectsURI(), queryBuilder);
    }

    @JsonIgnore
    public APIListResource<APIProject> getProjectsResource(long offset, long limit, String search, APISort sort) throws APIException {
        return this.getListResource(this.getProjectsURI(), offset, limit, search, sort, APIProject.class);
    }

    public APIProject getProject(Long id) throws APIException {
        return this.getResource(this.getProjectURI(id), APIProject.class).getEntity();
    }

    @JsonIgnore
    public APIListResource<APIDeviceGroup> getDeviceGroupsResource() throws APIException {
        return this.getListResource(this.getDeviceGroupsURI());
    }

    @JsonIgnore
    public APIListResource<APIDeviceGroup> getDeviceGroupsResource(APIQueryBuilder queryBuilder) throws APIException {
        return this.getListResource(this.getDeviceGroupsURI(), queryBuilder);
    }

    @JsonIgnore
    public APIListResource<APIDeviceGroup> getDeviceGroupsResource(long offset, long limit, String search, APISort sort) throws APIException {
        return this.getListResource(this.getDeviceGroupsURI(), offset, limit, search, sort, APIDeviceGroup.class);
    }

    @JsonIgnore
    public APIDeviceGroup createDeviceGroup(String name, APIDevice.OsType osType) throws APIException {
        return this.postResource(this.getDeviceGroupsURI(), this.getCreateDeviceGroupParams(name, osType), APIDeviceGroup.class);
    }

    @JsonIgnore
    public APINotificationEmail createNotificationEmail(String email, APINotificationEmail.Type type) throws APIException {
        return this.postResource(this.getNotificationsURI(), this.getNotificationEmailParams(email, type), APINotificationEmail.class);
    }

    @JsonIgnore
    public APIListResource<APINotificationEmail> getNotificationEmails() throws APIException {
        return this.getListResource(this.getNotificationsURI());
    }

    @JsonIgnore
    public APIListResource<APINotificationEmail> getNotificationEmails(APIQueryBuilder queryBuilder) throws APIException {
        return this.getListResource(this.getNotificationsURI(), queryBuilder);
    }

    @JsonIgnore
    public APIListResource<APINotificationEmail> getNotificationEmails(long offset, long limit, String search, APISort sort) throws APIException {
        return this.getListResource(this.getNotificationsURI(), offset, limit, search, sort, APINotificationEmail.class);
    }

    @JsonIgnore
    public APINotificationEmail updateNotificationEmail(long id, APINotificationEmail.Type emailType) throws APIException {
        return this.postResource(this.getNotificationURI(id), this.getNotificationEmailParams(emailType), APINotificationEmail.class);
    }

    @JsonIgnore
    public void deleteNotificationEmail(long id) throws APIException {
        this.deleteResource(this.getNotificationURI(id));
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APIUser apiUser = (APIUser)from;
        this.cloneBase(from);
        this.address = apiUser.address;
        this.city = apiUser.city;
        this.code = apiUser.code;
        this.country = apiUser.country;
        this.email = apiUser.email;
        this.enabled = apiUser.enabled;
        this.name = apiUser.name;
        this.organization = apiUser.organization;
        this.phone = apiUser.phone;
        this.roles = apiUser.roles;
        this.state = apiUser.state;
        this.timeZone = apiUser.timeZone;
        this.vatID = apiUser.vatID;
        this.emailNotification = apiUser.emailNotification;
        this.createTime = apiUser.createTime;
        this.isMainUser = apiUser.isMainUser;
    }

    @XmlType(namespace="APIUser", name="APIUserEmailNotification")
    public static enum EmailNotification {
        ALWAYS,
        NEVER,
        ON_FAILURE;

    }
}

