/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIListResource;
import com.testdroid.api.model.APIUserFileProperty;
import com.testdroid.api.model.APIUserFileTag;
import java.io.InputStream;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.jackson.annotate.JsonIgnore;

@XmlRootElement
public class APIUserFile
extends APIEntity {
    private Date createTime;
    private APIUserFileProperty[] fileProperties;
    private State state;
    private String name;
    private Long size;

    public APIUserFile() {
    }

    public APIUserFile(Long id, String name, Date createTime, Long size, State state, APIUserFileProperty ... fileProperties) {
        super(id);
        this.name = name;
        this.createTime = createTime;
        this.size = size;
        this.fileProperties = fileProperties;
        this.state = state;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public APIUserFileProperty[] getFileProperties() {
        return this.fileProperties;
    }

    public void setFileProperties(APIUserFileProperty[] fileProperties) {
        this.fileProperties = fileProperties;
    }

    private String getFileURI() {
        return APIUserFile.createUri(this.selfURI, "/file");
    }

    private String getIconURI() {
        return APIUserFile.createUri(this.selfURI, "/icon");
    }

    private String getFileTagsURI() {
        return APIUserFile.createUri(this.selfURI, "/tags");
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    @JsonIgnore
    public InputStream getIcon() throws APIException {
        return this.getFile(this.getIconURI());
    }

    @JsonIgnore
    public InputStream getFile() throws APIException {
        return this.getFile(this.getFileURI());
    }

    @JsonIgnore
    public APIListResource<APIUserFileTag> getTagsResource() throws APIException {
        return this.getListResource(this.getFileTagsURI());
    }

    public void delete() throws APIException {
        this.deleteResource(this.selfURI);
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APIUserFile apiUserFile = (APIUserFile)from;
        this.cloneBase(from);
        this.name = apiUserFile.name;
        this.createTime = apiUserFile.createTime;
        this.size = apiUserFile.size;
        this.fileProperties = apiUserFile.fileProperties;
        this.state = apiUserFile.state;
    }

    @XmlType(namespace="APIUserFile", name="APIUserFileState")
    public static enum State {
        PREPARING,
        READY;

    }
}

