/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.sample;

import com.testdroid.api.APIClient;
import com.testdroid.api.APIDeviceQueryBuilder;
import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIList;
import com.testdroid.api.APIQueryBuilder;
import com.testdroid.api.model.APIDevice;
import com.testdroid.api.model.APIDeviceGroup;
import com.testdroid.api.model.APIUser;
import com.testdroid.api.sample.util.Common;

public class CreateDeviceGroupSample {
    public static final APIClient CLIENT = Common.createApiClient();

    public static void main(String[] args) {
        try {
            APIUser me = CLIENT.me();
            APIDeviceGroup deviceGroup = me.createDeviceGroup("My device group", APIDevice.OsType.ANDROID);
            System.out.println(String.format("Device group name: %s\nOwner id: %s\nIs group public?: %s", deviceGroup.getDisplayName(), deviceGroup.getUserId(), deviceGroup.isPublic()));
            APIEntity devicesList = CLIENT.getDevices().getEntity();
            System.out.println(String.format("Got %s devices", ((APIList)devicesList).getLimit()));
            int i = 0;
            for (APIDevice device : ((APIList)devicesList).getData()) {
                if (i++ % 2 != 0) continue;
                deviceGroup.addDevice(device);
            }
            deviceGroup.refresh();
            System.out.println(String.format("Device group have %s devices. Single run cost %s credits. Devices are:", deviceGroup.getDeviceCount(), deviceGroup.getCreditsPrice()));
            for (APIDevice device : ((APIList)deviceGroup.getIncludedDevicesResource().getEntity()).getData()) {
                System.out.println(device.getDisplayName());
            }
            String deviceName = ((APIDevice)((APIList)deviceGroup.getIncludedDevicesResource().getEntity()).get(0)).getDisplayName();
            System.out.println(String.format("Searching device with name %s...", deviceName));
            System.out.println("Results:");
            for (APIDevice device : ((APIList)deviceGroup.getIncludedDevicesResource(new APIQueryBuilder().offset(0L).limit(10L).search(deviceName)).getEntity()).getData()) {
                System.out.println(device.getDisplayName());
            }
            APIEntity samsungDevices = CLIENT.getDevices(new APIDeviceQueryBuilder().offset(0L).limit(10L).search("Samsung")).getEntity();
            APIDeviceGroup samsungsDeviceGroup = me.createDeviceGroup("Samsungs only", APIDevice.OsType.ANDROID);
            for (APIDevice device : ((APIList)samsungDevices).getData()) {
                samsungsDeviceGroup.addDevice(device);
            }
            samsungsDeviceGroup.refresh();
            System.out.println(String.format("Devices added to %s group", samsungsDeviceGroup.getDisplayName()));
            for (APIDevice device : ((APIList)samsungsDeviceGroup.getIncludedDevicesResource().getEntity()).getData()) {
                System.out.println(device.getDisplayName());
            }
        }
        catch (APIException apie) {
            System.err.println(apie.getMessage());
        }
    }
}

