/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.sample;

import com.testdroid.api.APIClient;
import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIList;
import com.testdroid.api.model.APINotificationEmail;
import com.testdroid.api.model.APIProject;
import com.testdroid.api.model.APIUser;
import com.testdroid.api.sample.util.Common;

public class CreateNotificationEmailsSample {
    public static final APIClient CLIENT = Common.createApiClient();

    public static void main(String[] args) {
        try {
            APIUser me = CLIENT.me();
            for (APINotificationEmail notificationEmail : ((APIList)me.getNotificationEmails().getEntity()).getData()) {
                System.out.println(String.format("Deleting notification email %s", notificationEmail.getEmail()));
                notificationEmail.delete();
            }
            System.out.println("Now add some notification emails");
            APINotificationEmail alwaysNotificationEmail = me.createNotificationEmail("email@localhost", APINotificationEmail.Type.ALWAYS);
            APINotificationEmail onFailureNotificationEmail = me.createNotificationEmail("different.email@localhost", APINotificationEmail.Type.ON_FAILURE);
            APIEntity notificationEmailsList = me.getNotificationEmails().getEntity();
            System.out.println("Notification emails are:");
            for (APINotificationEmail notificationEmail : ((APIList)notificationEmailsList).getData()) {
                System.out.println(String.format("%s, type: %s", new Object[]{notificationEmail.getEmail(), notificationEmail.getType()}));
            }
            APIProject project = me.createProject(APIProject.Type.ANDROID);
            project.createNotificationEmail("user@localhost", APINotificationEmail.Type.ON_FAILURE);
            for (APINotificationEmail notificationEmail : ((APIList)project.getNotificationEmails().getEntity()).getData()) {
                System.out.println(String.format("%s, type: %s", new Object[]{notificationEmail.getEmail(), notificationEmail.getType()}));
            }
        }
        catch (APIException apie) {
            System.err.println(apie.getMessage());
        }
    }
}

