/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.sample;

import com.testdroid.api.APIClient;
import com.testdroid.api.APIDeviceQueryBuilder;
import com.testdroid.api.APIException;
import com.testdroid.api.APIList;
import com.testdroid.api.APIListResource;
import com.testdroid.api.APISort;
import com.testdroid.api.model.APIDevice;
import com.testdroid.api.sample.util.Common;

public class GetDevicesSample {
    public static final APIClient CLIENT = Common.createApiClient();

    public static void main(String[] args) {
        try {
            APIListResource<APIDevice> devicesResource = CLIENT.getDevices();
            System.out.println(String.format("Get %s devices", devicesResource.getTotal()));
            GetDevicesSample.printDeviceNames(devicesResource);
            while (devicesResource.isNextAvailable()) {
                devicesResource = devicesResource.getNext();
                GetDevicesSample.printDeviceNames(devicesResource);
            }
            devicesResource = CLIENT.getDevices(new APIDeviceQueryBuilder().filterWithDeviceFilters(APIDevice.DeviceFilter.NEW));
            System.out.println(String.format("\nGet %s new devices", devicesResource.getTotal()));
            GetDevicesSample.printDeviceNames(devicesResource);
            devicesResource = CLIENT.getDevices(new APIDeviceQueryBuilder().filterWithDeviceFilters(APIDevice.DeviceFilter.RECOMMENDED));
            System.out.println(String.format("\nGet %s recommended devices", devicesResource.getTotal()));
            GetDevicesSample.printDeviceNames(devicesResource);
            devicesResource = CLIENT.getDevices(new APIDeviceQueryBuilder().filterWithDeviceFilters(APIDevice.DeviceFilter.FREE));
            System.out.println(String.format("\nGet %s free devices", devicesResource.getTotal()));
            GetDevicesSample.printDeviceNames(devicesResource);
            String deviceName = ((APIDevice)((APIList)devicesResource.getEntity()).get(0)).getDisplayName();
            devicesResource = CLIENT.getDevices(new APIDeviceQueryBuilder().offset(0L).limit(10L).search(deviceName));
            System.out.println(String.format("\nFound %s devices", devicesResource.getTotal()));
            GetDevicesSample.printDeviceNames(devicesResource);
            devicesResource = CLIENT.getDevices(new APIDeviceQueryBuilder().offset(0L).limit(10L).search(deviceName).filterWithDeviceFilters(APIDevice.DeviceFilter.RECOMMENDED));
            System.out.println(String.format("\nFound %s recommended devices", devicesResource.getTotal()));
            GetDevicesSample.printDeviceNames(devicesResource);
            deviceName = "Samsung Galaxy";
            devicesResource = CLIENT.getDevices((APIDeviceQueryBuilder)new APIDeviceQueryBuilder().offset(0L).limit(10L).search(deviceName).sort(APIDevice.class, new APISort.SortItem[]{new APISort.SortItem(APISort.Column.DEVICE_NAME, APISort.Type.ASC)}));
            System.out.println(String.format("\nFound %s devices with name %s", devicesResource.getTotal(), deviceName));
            GetDevicesSample.printDeviceNames(devicesResource);
        }
        catch (APIException apie) {
            System.err.println(apie.getMessage());
        }
    }

    private static void printDeviceNames(APIListResource<APIDevice> devicesResource) throws APIException {
        for (APIDevice device : ((APIList)devicesResource.getEntity()).getData()) {
            System.out.println(device.getDisplayName());
        }
    }
}

