/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.sample;

import com.testdroid.api.APIClient;
import com.testdroid.api.APIException;
import com.testdroid.api.APIList;
import com.testdroid.api.APIListResource;
import com.testdroid.api.APIQueryBuilder;
import com.testdroid.api.model.APIProject;
import com.testdroid.api.model.APIProjectSharing;
import com.testdroid.api.model.APIUser;
import com.testdroid.api.sample.util.Common;

public class ProjectsSharingSample {
    public static final APIClient CLIENT = Common.createApiClient();

    public static void main(String[] args) {
        try {
            APIUser me = CLIENT.me();
            APIProject project = me.createProject(APIProject.Type.ANDROID);
            APIProjectSharing projectSharing = project.share("user@localhost");
            System.out.println(String.format("Project %s was shared to user with id %s", project.getName(), projectSharing.getUserId()));
            APIListResource<APIProject> projects = me.getProjectsResource(new APIQueryBuilder().offset(0L).limit(10L).search(project.getId().toString()));
            for (APIProject p : ((APIList)projects.getEntity()).getData()) {
                System.out.println(p.getName());
                System.out.println("Project sharings: ");
                for (APIProjectSharing ps : ((APIList)p.getProjectSharings().getEntity()).getData()) {
                    System.out.println(String.format("\t Shared to user with id %s", ps.getUserId()));
                }
            }
        }
        catch (APIException apie) {
            System.err.println(apie.getMessage());
        }
    }
}

