/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.sample;

import com.testdroid.api.APIClient;
import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIList;
import com.testdroid.api.model.APIDeviceGroup;
import com.testdroid.api.model.APIDeviceRun;
import com.testdroid.api.model.APIFiles;
import com.testdroid.api.model.APIProject;
import com.testdroid.api.model.APITestRun;
import com.testdroid.api.model.APITestRunConfig;
import com.testdroid.api.model.APIUser;
import com.testdroid.api.model.AndroidFiles;
import com.testdroid.api.sample.util.Common;
import java.io.File;

public class RunProjectSample {
    public static final APIClient CLIENT = Common.createApiClient();
    public static final String HOOK_URL = "some URL";

    public static void main(String[] args) {
        try {
            APIUser me = CLIENT.me();
            APIProject project = me.createProject(APIProject.Type.ANDROID);
            APIEntity deviceGroupsList = project.getPublicDeviceGroups().getEntity();
            APIDeviceGroup deviceGroup = (APIDeviceGroup)((APIList)deviceGroupsList).get(0);
            APITestRunConfig testRunConfig = project.getTestRunConfig();
            testRunConfig.setApplicationPassword("applicationPassword");
            testRunConfig.setApplicationUsername("applicationUsername");
            testRunConfig.setAutoScreenshots(false);
            testRunConfig.setCheckApp(true);
            testRunConfig.setDeviceLanguageCode("EN");
            testRunConfig.setUsedDeviceGroupId(deviceGroup.getId());
            testRunConfig.setMode(APITestRunConfig.Mode.FULL_RUN);
            testRunConfig.setHookURL(HOOK_URL);
            testRunConfig.update();
            project.uploadApplication(new File(RunProjectSample.class.getResource("/fixtures/BitbarSampleApp.apk").getPath()), "application/vnd.android.package-archive");
            project.uploadTest(new File(RunProjectSample.class.getResource("/fixtures/BitbarSampleAppTest.apk").getPath()), "application/vnd.android.package-archive");
            project.uploadData(new File(RunProjectSample.class.getResource("/fixtures/testData.zip").getPath()), "application/zip");
            APITestRun testRun = project.run("My test run name");
            System.out.println(String.format("Created test run with name: %s", testRun.getDisplayName()));
            System.out.println("Device runs was also created for devices:");
            for (APIDeviceRun deviceRun : ((APIList)testRun.getDeviceRunsResource().getEntity()).getData()) {
                System.out.println(String.format("Device: %s, created: %s", deviceRun.getDevice().getDisplayName(), deviceRun.getCreateTime()));
            }
            AndroidFiles androidFiles = project.getFiles(AndroidFiles.class);
            APIFiles.AndroidAppFile androidAppFile = androidFiles.getApp();
            APIFiles.AndroidTestFile androidTestFile = androidFiles.getTest();
        }
        catch (APIException apie) {
            System.err.println(apie.getMessage());
        }
    }
}

