/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.sample;

import com.testdroid.api.APIClient;
import com.testdroid.api.APIDeviceQueryBuilder;
import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIList;
import com.testdroid.api.model.APIDevice;
import com.testdroid.api.model.APIProject;
import com.testdroid.api.model.APITestRun;
import com.testdroid.api.model.APITestRunConfig;
import com.testdroid.api.model.APIUser;
import com.testdroid.api.sample.util.Common;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class RunProjectWithoutDeviceGroupSample {
    public static final APIClient CLIENT = Common.createApiClient();

    public static void main(String[] args) {
        try {
            APIUser me = CLIENT.me();
            APIProject project = me.createProject(APIProject.Type.ANDROID);
            APITestRunConfig testRunConfig = project.getTestRunConfig();
            testRunConfig.setApplicationPassword("applicationPassword");
            testRunConfig.setApplicationUsername("applicationUsername");
            testRunConfig.setAutoScreenshots(false);
            testRunConfig.setCheckApp(true);
            testRunConfig.setDeviceLanguageCode("EN");
            testRunConfig.setMode(APITestRunConfig.Mode.FULL_RUN);
            testRunConfig.update();
            project.uploadApplication(new File(RunProjectWithoutDeviceGroupSample.class.getResource("/fixtures/BitbarSampleApp.apk").getPath()), "application/vnd.android.package-archive");
            project.uploadTest(new File(RunProjectWithoutDeviceGroupSample.class.getResource("/fixtures/BitbarSampleAppTest.apk").getPath()), "application/vnd.android.package-archive");
            project.uploadData(new File(RunProjectWithoutDeviceGroupSample.class.getResource("/fixtures/testData.zip").getPath()), "application/zip");
            APITestRun testRun = project.run("My test run", RunProjectWithoutDeviceGroupSample.getDeviceIds());
            System.out.println(String.format("Created test run with name: %s", testRun.getDisplayName()));
        }
        catch (APIException apie) {
            System.err.println(apie.getMessage());
        }
    }

    private static List<Long> getDeviceIds() throws APIException {
        APIEntity devices = CLIENT.getDevices(new APIDeviceQueryBuilder().search("samsung")).getEntity();
        ArrayList<Long> result = new ArrayList<Long>();
        for (APIDevice device : ((APIList)devices).getData()) {
            result.add(device.getId());
        }
        return result;
    }
}

