/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.sample;

import com.testdroid.api.APIClient;
import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIList;
import com.testdroid.api.model.APIProject;
import com.testdroid.api.model.APITestRun;
import com.testdroid.api.model.APIUser;
import com.testdroid.api.model.APIUserFile;
import com.testdroid.api.sample.util.Common;
import java.io.InputStream;

public class ScreenshotsSample {
    private static final APIClient client = Common.createApiClient();

    public static void main(String[] args) {
        try {
            APIUser me = client.me();
            APITestRun testRun = ScreenshotsSample.getFinishedTestRun(me);
            if (testRun == null) {
                System.out.println("You have no finished test runs. Cannot generate screenshots.");
                return;
            }
            testRun.requestScreenshotsZip();
            APIUserFile file = testRun.getScreenshotsZip();
            while (file.getState() != APIUserFile.State.READY) {
                try {
                    System.out.println("Waiting for screenshots...");
                    Thread.sleep(5000L);
                    file.refresh();
                }
                catch (InterruptedException ignore) {}
            }
            InputStream is = file.getFile();
        }
        catch (APIException apie) {
            System.out.println(apie.getMessage());
        }
    }

    private static APITestRun getFinishedTestRun(APIUser user) throws APIException {
        APIEntity projectsList = user.getProjectsResource().getEntity();
        for (APIProject project : ((APIList)projectsList).getData()) {
            APIEntity testRunsList = project.getTestRunsResource().getEntity();
            for (APITestRun testRun : ((APIList)testRunsList).getData()) {
                if (testRun.getState() != APITestRun.State.FINISHED) continue;
                return testRun;
            }
        }
        return null;
    }
}

