/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.sample;

import com.testdroid.api.APIClient;
import com.testdroid.api.APIException;
import com.testdroid.api.APIList;
import com.testdroid.api.APIListResource;
import com.testdroid.api.APIQueryBuilder;
import com.testdroid.api.model.APIProject;
import com.testdroid.api.model.APITag;
import com.testdroid.api.model.APITestRun;
import com.testdroid.api.model.APITestRunConfig;
import com.testdroid.api.model.APIUser;
import com.testdroid.api.sample.util.Common;
import java.io.File;

public class TestRunTagsSample {
    private static final APIClient CLIENT = Common.createApiClient();

    public static void main(String[] args) {
        try {
            APIUser me = CLIENT.me();
            APIProject project = me.createProject(APIProject.Type.ANDROID);
            APITestRunConfig config = project.getTestRunConfig();
            config.setMode(APITestRunConfig.Mode.APP_CRAWLER);
            config.update();
            project.uploadApplication(new File(TestRunTagsSample.class.getResource("/fixtures/BitbarSampleApp.apk").getPath()), "application/vnd.android.package-archive");
            APITestRun testRun = project.run();
            String tagName = "Test run tag";
            APITag tag = testRun.addTag(tagName);
            System.out.println(String.format("Created tag with name: %s", tag.getName()));
            testRun.refresh();
            System.out.println("Test run have now tags:");
            for (APITag t : ((APIList)testRun.getTagsResource().getEntity()).getData()) {
                System.out.println(String.format("\t%s", t.getName()));
            }
            APIListResource<APITestRun> projects = project.getTestRunsResource(new APIQueryBuilder().search(tagName));
            System.out.println(String.format("Projects found using tag name: %s", tagName));
            for (APITestRun tr : ((APIList)projects.getEntity()).getData()) {
                System.out.println(String.format("\t%s", tr.getDisplayName()));
            }
        }
        catch (APIException apie) {
            System.err.println(apie.getMessage());
        }
    }
}

