/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.um.model;

import com.testdroid.api.formatter.CurrencyFormatter;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.jackson.annotate.JsonIgnore;

@XmlRootElement(name="umApiService", namespace="cloud.testdroid.api.um.model")
@XmlType(name="umApiService", namespace="cloud.testdroid.api.um.model")
public class APIService {
    private boolean autoRenew;
    private String braintreeId;
    private Integer centPrice;
    private String description;
    private Long id;
    private String name;
    private boolean quantityAppliable;
    private Type type;
    private Unit unit;
    private Integer unitCount;

    public APIService() {
    }

    public APIService(Long id, String name, String description, boolean autoRenew, Type type, Integer centPrice, Integer unitCount, Unit unit, boolean quantityAppliable, String braintreeId) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.autoRenew = autoRenew;
        this.type = type;
        this.centPrice = centPrice;
        this.unitCount = unitCount;
        this.unit = unit;
        this.quantityAppliable = quantityAppliable;
        this.braintreeId = braintreeId;
    }

    public boolean isAutoRenew() {
        return this.autoRenew;
    }

    public void setAutoRenew(boolean autoRenew) {
        this.autoRenew = autoRenew;
    }

    public Integer getCentPrice() {
        return this.centPrice;
    }

    public void setCentPrice(Integer centPrice) {
        this.centPrice = centPrice;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    @JsonIgnore
    public String getPaypalUnit() {
        switch (this.unit) {
            case YEAR: {
                return "Y";
            }
            case DAY: {
                return "D";
            }
            case MONTH: {
                return "M";
            }
        }
        return "";
    }

    public Integer getUnitCount() {
        return this.unitCount;
    }

    public void setUnitCount(Integer unitCount) {
        this.unitCount = unitCount;
    }

    public boolean isQuantityAppliable() {
        return this.quantityAppliable;
    }

    public void setQuantityAppliable(boolean quantityAppliable) {
        this.quantityAppliable = quantityAppliable;
    }

    public String getBraintreeId() {
        return this.braintreeId;
    }

    public void setBraintreeId(String braintreeId) {
        this.braintreeId = braintreeId;
    }

    public String getPriceString() {
        return CurrencyFormatter.format(this.centPrice);
    }

    @JsonIgnore
    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    @JsonIgnore
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof APIService)) {
            return false;
        }
        APIService other = (APIService)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    @XmlType(name="umApiServiceUnit", namespace="cloud.testdroid.um.api.model")
    public static enum Unit {
        SECOND,
        MINUTE,
        HOUR,
        DAY,
        MONTH,
        YEAR,
        RUN,
        PROJECT;

    }

    @XmlType(name="umApiServiceType", namespace="cloud.testdroid.um.api.model")
    public static enum Type {
        RECORDER,
        CLOUD;

    }
}

