/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api;

import com.testdroid.api.APIClient;
import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIList;
import com.testdroid.api.dto.Context;

public class APIListResource<T extends APIEntity> {
    private final APIClient client;
    private final Context<T> context;
    private final String resourceURI;
    private APIList<T> entity;

    public APIListResource(APIClient client, String resourceURI, Class<T> type) {
        this.client = client;
        this.resourceURI = resourceURI;
        this.context = new Context<T>(type);
    }

    public APIListResource(APIClient client, String resourceURI, Context<T> context) {
        this.client = client;
        this.resourceURI = resourceURI;
        this.context = context;
    }

    public APIList<T> getEntity() throws APIException {
        this.entity = this.client.get(this.resourceURI, this.context);
        for (APIEntity item : this.entity.getData()) {
            item.client = this.client;
            item.selfURI = APIEntity.createUri(this.resourceURI, String.format("/%s", item.id));
        }
        return this.entity;
    }

    public Integer getTotal() throws APIException {
        return this.getEntity().getTotal();
    }

    public boolean isNextAvailable() {
        try {
            APIList<T> list = this.getEntity();
            return list.getOffset() + list.getLimit() < list.getTotal();
        }
        catch (APIException ex) {
            return false;
        }
    }

    public APIListResource<T> getNext() throws APIException {
        if (!this.isNextAvailable()) {
            return null;
        }
        APIList<T> list = this.getEntity();
        return new APIListResource<T>(this.client, this.resourceURI, this.context.setOffset(list.getOffset() + list.getLimit()));
    }

    public boolean isPreviousAvailable() {
        try {
            return this.getEntity().getOffset() > 0;
        }
        catch (APIException ex) {
            return false;
        }
    }

    public APIListResource<T> getPrevious() throws APIException {
        if (!this.isPreviousAvailable()) {
            return null;
        }
        APIList<T> list = this.getEntity();
        return new APIListResource<T>(this.client, this.resourceURI, this.context.setOffset(list.getOffset() - list.getLimit()));
    }
}

