/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.http.apache.ApacheHttpTransport;
import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIKeyClient;
import com.testdroid.api.AbstractAPIClient;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.ChallengeState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAPIClient
extends AbstractAPIClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(APIKeyClient.class);
    public static final int HTTP_CONNECT_TIMEOUT = 60000;
    public static final int HTTP_READ_TIMEOUT = 60000;
    protected String accessToken;
    protected long accessTokenExpireTime = 0L;
    protected String cloudURL;
    protected String password;
    protected String refreshToken;
    protected String username;

    public DefaultAPIClient(String cloudURL, String username, String password) {
        this(cloudURL, username, password, false);
    }

    public DefaultAPIClient(String cloudURL, String username, String password, boolean skipCheckCertificate) {
        ApacheHttpTransport.Builder apacheBuilder = new ApacheHttpTransport.Builder();
        if (skipCheckCertificate) {
            try {
                apacheBuilder.doNotValidateCertificate();
            }
            catch (GeneralSecurityException ex) {
                LOGGER.warn("Cannot set not-validating certificate. Certificate will be validating.", (Throwable)ex);
            }
        }
        this.httpTransport = apacheBuilder.build();
        DefaultHttpClient apacheClient = (DefaultHttpClient)((ApacheHttpTransport)this.httpTransport).getHttpClient();
        apacheClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler());
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)apacheClient.getParams(), (boolean)true);
        this.initializeDefaultAPIClient(cloudURL, username, password);
    }

    public DefaultAPIClient(String cloudURL, String username, String password, HttpHost proxy, boolean skipCheckCertificate) {
        this(cloudURL, username, password, skipCheckCertificate);
        DefaultHttpClient apacheClient = (DefaultHttpClient)((ApacheHttpTransport)this.httpTransport).getHttpClient();
        apacheClient.setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(proxy));
    }

    public DefaultAPIClient(String cloudURL, String username, String password, HttpHost proxy, String proxyUser, String proxyPassword, boolean skipCheckCertificate) {
        this(cloudURL, username, password, proxy, skipCheckCertificate);
        DefaultHttpClient apacheClient = (DefaultHttpClient)((ApacheHttpTransport)this.httpTransport).getHttpClient();
        apacheClient.getCredentialsProvider().setCredentials(new AuthScope(proxy.getHostName(), proxy.getPort()), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme(ChallengeState.PROXY);
        authCache.put(proxy, (AuthScheme)basicAuth);
        apacheClient.addRequestInterceptor((arg_0, arg_1) -> DefaultAPIClient.lambda$new$0((AuthCache)authCache, arg_0, arg_1), 0);
    }

    private void initializeDefaultAPIClient(String cloudURL, String username, String password) {
        this.cloudURL = StringUtils.removeEnd((String)cloudURL, (String)"/");
        this.apiURL = cloudURL + "/api/v2";
        this.username = username;
        this.password = password;
    }

    @Override
    protected HttpRequestFactory getRequestFactory() throws APIException {
        String accessToken = this.getAccessToken();
        Credential credential = new Credential.Builder(BearerToken.queryParameterAccessMethod()).build();
        if (StringUtils.isNotBlank((CharSequence)accessToken)) {
            credential.setAccessToken(accessToken);
        }
        return this.httpTransport.createRequestFactory((HttpRequestInitializer)credential);
    }

    private String getAccessToken() throws APIException {
        if (this.accessToken == null) {
            this.accessToken = this.acquireAccessToken();
        } else if (System.currentTimeMillis() > this.accessTokenExpireTime - 10000L) {
            try {
                this.accessToken = this.refreshAccessToken();
            }
            catch (APIException ex) {
                this.accessToken = null;
                this.accessToken = this.acquireAccessToken();
            }
        }
        return this.accessToken;
    }

    protected String acquireAccessToken() throws APIException {
        HttpResponse response = null;
        try {
            if (this.username == null && this.password == null) {
                String string = "";
                return string;
            }
            GenericUrl url = new GenericUrl(String.format("%s/oauth/token", this.cloudURL));
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("client_id", "testdroid-cloud-api");
            data.put("grant_type", "password");
            data.put("username", this.username);
            data.put("password", this.password);
            UrlEncodedContent content = new UrlEncodedContent(data);
            HttpRequest request = this.httpTransport.createRequestFactory().buildPostRequest(url, (HttpContent)content);
            request.setConnectTimeout(60000);
            request.setReadTimeout(60000);
            request.setHeaders(new HttpHeaders().setAccept("application/json"));
            response = request.execute();
            if (response.getStatusCode() != 200) {
                throw new APIException(response.getStatusCode(), "Failed to acquire access token");
            }
            String responseJson = StringUtils.join((Iterable)IOUtils.readLines((InputStream)response.getContent(), (Charset)StandardCharsets.UTF_8), (String)"\n");
            Map<String, String> json = this.fromJson(responseJson, new TypeReference<Map<String, String>>(){});
            this.accessTokenExpireTime = System.currentTimeMillis() + Long.parseLong(json.get("expires_in")) * 1000L;
            this.refreshToken = json.get("refresh_token");
            String string = json.get("access_token");
            this.disconnectQuietly(response);
            return string;
        }
        catch (HttpResponseException ex) {
            throw new APIException(String.format("Failed to acquire access token. Reason: %s", ex.getStatusMessage()), ex);
        }
        catch (IOException ex) {
            throw new APIException(String.format("Failed to acquire access token. Reason: %s", ex.getMessage()), ex);
        }
        finally {
            this.disconnectQuietly(response);
        }
    }

    protected String refreshAccessToken() throws APIException {
        HttpResponse response = null;
        try {
            if (this.refreshToken == null) {
                String string = null;
                return string;
            }
            GenericUrl url = new GenericUrl(String.format("%s/oauth/token", this.cloudURL));
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("client_id", "testdroid-cloud-api");
            data.put("grant_type", "refresh_token");
            data.put("refresh_token", this.refreshToken);
            UrlEncodedContent content = new UrlEncodedContent(data);
            HttpRequest request = this.httpTransport.createRequestFactory().buildPostRequest(url, (HttpContent)content);
            request.setConnectTimeout(60000);
            request.setReadTimeout(60000);
            request.setHeaders(this.getHttpHeaders());
            response = request.execute();
            if (response.getStatusCode() != 200) {
                throw new APIException(response.getStatusCode(), "Failed to refresh access token");
            }
            String jsonContent = StringUtils.join((Iterable)IOUtils.readLines((InputStream)response.getContent(), (Charset)StandardCharsets.UTF_8), (String)"\n");
            Map<String, String> json = this.fromJson(jsonContent, new TypeReference<Map<String, String>>(){});
            this.accessTokenExpireTime = System.currentTimeMillis() + Long.parseLong(json.get("expires_in")) * 1000L;
            this.refreshToken = json.get("refresh_token");
            String string = json.get("access_token");
            this.disconnectQuietly(response);
            return string;
        }
        catch (IOException ex) {
            throw new APIException(String.format("Failed to refresh access token. Reason: %s", ex.getMessage()), ex);
        }
        finally {
            this.disconnectQuietly(response);
        }
    }

    @Override
    public <T extends APIEntity> T get(String uri, Class<T> type) throws APIException {
        try {
            return super.get(uri, type);
        }
        catch (APIException ex) {
            if (ex.getStatus() != null && 401 == ex.getStatus()) {
                this.accessToken = null;
                return super.get(uri, type);
            }
            throw ex;
        }
    }

    @Override
    public InputStream get(String uri) throws APIException {
        try {
            return super.get(uri);
        }
        catch (APIException ex) {
            if (ex.getStatus() != null && 401 == ex.getStatus()) {
                this.accessToken = null;
                return super.get(uri);
            }
            throw ex;
        }
    }

    @Override
    public <T extends APIEntity> T post(String uri, Object body, Class<T> type) throws APIException {
        try {
            return super.post(uri, body, type);
        }
        catch (APIException ex) {
            if (ex.getStatus() != null && 401 == ex.getStatus()) {
                this.accessToken = null;
                return super.post(uri, body, type);
            }
            throw ex;
        }
    }

    @Override
    public <T extends APIEntity> T postFile(String uri, String contentType, File file, Class<T> type) throws APIException {
        try {
            return super.postFile(uri, contentType, file, type);
        }
        catch (APIException ex) {
            if (ex.getStatus() != null && 401 == ex.getStatus()) {
                this.accessToken = null;
                return super.postFile(uri, contentType, file, type);
            }
            throw ex;
        }
    }

    @Override
    public void delete(String uri) throws APIException {
        try {
            super.delete(uri);
        }
        catch (APIException ex) {
            if (ex.getStatus() != null && 401 == ex.getStatus()) {
                this.accessToken = null;
                super.delete(uri);
            }
            throw ex;
        }
    }

    @Override
    protected HttpHeaders getHttpHeaders() {
        return new HttpHeaders().setAccept("application/json");
    }

    private static /* synthetic */ void lambda$new$0(AuthCache authCache, org.apache.http.HttpRequest hr, HttpContext hc) throws HttpException, IOException {
        hc.setAttribute("http.auth.auth-cache", (Object)authCache);
    }
}

