/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.dto;

import com.testdroid.api.APIEntity;
import com.testdroid.api.APISort;
import com.testdroid.api.dto.Operand;
import com.testdroid.api.filter.FilterEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class Context<T extends APIEntity> {
    public static final int DEFAULT_LIMIT = 20;
    public static final int DEFAULT_OFFSET = 0;
    public static final String FILTER_REQUEST_PARAM = "filter";
    public static final String SEARCH_REQUEST_PARAM = "search";
    public static final String FILTER_DELIMITER = ";";
    public static final String GROUP_REQUEST_PARAM = "group";
    public static final String LIMIT_REQUEST_PARAM = "limit";
    public static final String SORT_REQUEST_PARAM = "sort";
    public static final String OFFSET_REQUEST_PARAM = "offset";
    private int limit = 20;
    private int offset = 0;
    private String search;
    private APISort sort;
    private List<String> groups = new ArrayList<String>();
    private List<FilterEntry> filters = new ArrayList<FilterEntry>();
    private final Class<T> type;
    private Boolean cacheable = Boolean.FALSE;
    private Map<String, Object> extraParams = new HashMap<String, Object>();

    public Context(Class<T> type) {
        this.type = type;
    }

    public Context(Class<T> type, int offset, int limit, String search, String sort) {
        this.offset = offset;
        this.limit = limit;
        this.search = search;
        this.type = type;
        this.sort = APISort.deserialize(sort);
    }

    public Context(Class<T> type, int offset, int limit, String search, String sort, List<FilterEntry> filters, List<String> groups) {
        this.offset = offset;
        this.limit = limit;
        this.search = search;
        this.type = type;
        this.sort = APISort.deserialize(sort);
        this.filters = filters;
        this.groups = groups;
    }

    public int getOffset() {
        return this.offset;
    }

    public Context<T> setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public Context<T> setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public String getSearch() {
        return this.search;
    }

    public Context<T> setSearch(String search) {
        this.search = search;
        return this;
    }

    public APISort getSort() {
        return this.sort;
    }

    public Context<T> setSort(APISort sort) {
        this.sort = sort;
        return this;
    }

    public Class<T> getType() {
        return this.type;
    }

    public List<FilterEntry> getFilters() {
        return this.filters;
    }

    public Optional<FilterEntry> findFilter(String field, Operand operand) {
        return this.filters.stream().filter(f -> f.getField().equals(field) && f.getOperand().equals((Object)operand)).findAny();
    }

    public Context<T> setFilters(List<FilterEntry> filters) {
        this.filters = filters;
        return this;
    }

    public Context<T> addFilter(FilterEntry filterEntry) {
        this.filters.add(filterEntry);
        return this;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public Boolean getCacheable() {
        return this.cacheable;
    }

    public Context<T> setCacheable(Boolean cacheable) {
        this.cacheable = cacheable;
        return this;
    }

    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    public void setExtraParams(Map<String, Object> extraParams) {
        this.extraParams = extraParams;
    }

    public Map<String, Object> build() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(LIMIT_REQUEST_PARAM, this.limit);
        map.put(OFFSET_REQUEST_PARAM, this.offset);
        map.put(SEARCH_REQUEST_PARAM, this.search);
        map.put(SORT_REQUEST_PARAM, this.sort != null ? this.sort.serialize() : null);
        map.put(FILTER_REQUEST_PARAM, this.filters.stream().map(FilterEntry::toString).collect(Collectors.joining(FILTER_DELIMITER)));
        map.put(GROUP_REQUEST_PARAM, this.groups);
        map.putAll(this.extraParams);
        return map;
    }
}

