/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.filter;

import com.testdroid.api.dto.Operand;
import java.util.List;
import java.util.stream.Collectors;

public class FilterEntry<T> {
    private String field;
    private Operand operand;
    private T value;

    private FilterEntry() {
    }

    FilterEntry(String field, Operand comparison, T value) {
        this.field = field;
        this.operand = comparison;
        this.value = value;
    }

    FilterEntry(String field, Operand comparison) {
        this.field = field;
        this.operand = comparison;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Operand getOperand() {
        return this.operand;
    }

    public void setOperand(Operand operand) {
        this.operand = operand;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilterEntry)) {
            return false;
        }
        FilterEntry that = (FilterEntry)o;
        if (this.field != null ? !this.field.equals(that.field) : that.field != null) {
            return false;
        }
        if (this.operand != that.operand) {
            return false;
        }
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public int hashCode() {
        int result = this.field != null ? this.field.hashCode() : 0;
        result = 31 * result + (this.operand != null ? this.operand.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        switch (this.operand.getArity()) {
            case 1: {
                return String.format("%s_%s", new Object[]{this.field, this.operand});
            }
            case 2: {
                return String.format("%s_%s_%s", new Object[]{this.field, this.operand, this.value});
            }
        }
        return String.format("%s_%s_%s", new Object[]{this.field, this.operand, ((List)this.value).stream().map(Object::toString).collect(Collectors.joining("|"))});
    }
}

