/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.testdroid.api.APIEntity;
import com.testdroid.api.model.APICluster;
import com.testdroid.api.model.APIDevice;
import com.testdroid.api.model.APISoftwareVersion;
import com.testdroid.api.util.TimeConverter;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.tuple.Pair;

@XmlRootElement
public class APIAdminDevice
extends APIEntity {
    private APICluster cluster;
    private Long deviceModelId;
    private String deviceModelName;
    private boolean enabled;
    private String fingerprint;
    private InitStep initStep;
    private String name;
    private String serialId;
    private APISoftwareVersion softwareVersion;
    private ComplexState state;
    private Date stateTime;
    private Date lastOnlineTime;
    private String unlockGesture;
    private String ipAddress;
    private Long accountId;
    private String mainUserEmail;
    private boolean locked;
    private APIDevice.OsType osType;

    public APIAdminDevice() {
    }

    public APIAdminDevice(Long id) {
        super(id);
    }

    public APIAdminDevice(Long id, String name, boolean enabled, String serialId, String fingerprint, String unlockGesture, Long softwareVersionId, String releaseVersion, Integer apiLevel, Long deviceModelId, String deviceModelName, ComplexState state, LocalDateTime stateTime, InitStep initStep, String ipAddress, Long clusterId, String clusterName, String clusterUrl, APICluster.State clusterState, LocalDateTime clusterStateTime, LocalDateTime clusterStateChangeTime, Boolean clusterEnabled, LocalDateTime lastOnlineTime, Long accountId, String mainUserEmail, Boolean locked, APIDevice.OsType osType) {
        super(id);
        this.name = name;
        this.enabled = enabled;
        this.serialId = serialId;
        this.fingerprint = fingerprint;
        this.unlockGesture = unlockGesture;
        this.softwareVersion = new APISoftwareVersion(softwareVersionId, releaseVersion, apiLevel);
        this.deviceModelId = deviceModelId;
        this.deviceModelName = deviceModelName;
        this.state = state;
        this.stateTime = TimeConverter.toDate(stateTime);
        this.initStep = initStep;
        this.ipAddress = ipAddress;
        this.cluster = new APICluster(clusterId, clusterName, clusterUrl, clusterState, clusterStateTime, clusterStateChangeTime, clusterEnabled);
        this.lastOnlineTime = TimeConverter.toDate(lastOnlineTime);
        this.accountId = accountId;
        this.mainUserEmail = mainUserEmail;
        this.locked = locked;
        this.osType = osType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getSerialId() {
        return this.serialId;
    }

    public void setSerialId(String serialId) {
        this.serialId = serialId;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public String getUnlockGesture() {
        return this.unlockGesture;
    }

    public void setUnlockGesture(String unlockGesture) {
        this.unlockGesture = unlockGesture;
    }

    public APISoftwareVersion getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(APISoftwareVersion softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public Long getDeviceModelId() {
        return this.deviceModelId;
    }

    public void setDeviceModelId(Long deviceModelId) {
        this.deviceModelId = deviceModelId;
    }

    public ComplexState getState() {
        return this.state;
    }

    public void setState(ComplexState state) {
        this.state = state;
    }

    public Date getStateTime() {
        return this.stateTime;
    }

    public void setStateTime(Date stateTime) {
        this.stateTime = stateTime;
    }

    public InitStep getInitStep() {
        return this.initStep;
    }

    public void setInitStep(InitStep initStep) {
        this.initStep = initStep;
    }

    public APICluster getCluster() {
        return this.cluster;
    }

    public void setCluster(APICluster cluster) {
        this.cluster = cluster;
    }

    public String getDeviceModelName() {
        return this.deviceModelName;
    }

    public void setDeviceModelName(String deviceModelName) {
        this.deviceModelName = deviceModelName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public Date getLastOnlineTime() {
        return this.lastOnlineTime;
    }

    public void setLastOnlineTime(Date lastOnlineTime) {
        this.lastOnlineTime = lastOnlineTime;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getMainUserEmail() {
        return this.mainUserEmail;
    }

    public void setMainUserEmail(String mainUserEmail) {
        this.mainUserEmail = mainUserEmail;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public APIDevice.OsType getOsType() {
        return this.osType;
    }

    public void setOsType(APIDevice.OsType osType) {
        this.osType = osType;
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APIAdminDevice adminDevice = (APIAdminDevice)from;
        this.cloneBase(from);
        this.cluster = adminDevice.cluster;
        this.deviceModelId = adminDevice.deviceModelId;
        this.deviceModelName = adminDevice.deviceModelName;
        this.enabled = adminDevice.enabled;
        this.fingerprint = adminDevice.fingerprint;
        this.initStep = adminDevice.initStep;
        this.name = adminDevice.name;
        this.serialId = adminDevice.serialId;
        this.softwareVersion = adminDevice.softwareVersion;
        this.state = adminDevice.state;
        this.stateTime = adminDevice.stateTime;
        this.unlockGesture = adminDevice.unlockGesture;
        this.ipAddress = adminDevice.ipAddress;
        this.lastOnlineTime = adminDevice.lastOnlineTime;
        this.accountId = adminDevice.accountId;
        this.mainUserEmail = adminDevice.mainUserEmail;
        this.locked = adminDevice.locked;
        this.osType = adminDevice.osType;
    }

    @XmlType(namespace="APIAdminDevice")
    public static enum ComplexState {
        OFFLINE(State.OFFLINE, SubState.DIRTY),
        ONLINE(State.ONLINE, SubState.FREE),
        OFFLINE_CLEANING(State.OFFLINE, SubState.CLEANING),
        OFFLINE_DIRTY(State.OFFLINE, SubState.DIRTY),
        OFFLINE_FREE(State.OFFLINE, SubState.FREE),
        OFFLINE_TESTING(State.OFFLINE, SubState.TESTING),
        ONLINE_CLEANING(State.ONLINE, SubState.CLEANING),
        ONLINE_DIRTY(State.ONLINE, SubState.DIRTY),
        ONLINE_FREE(State.ONLINE, SubState.FREE),
        ONLINE_TESTING(State.ONLINE, SubState.TESTING);

        private State state;
        private SubState subState;
        private static final Map<Pair<State, SubState>, ComplexState> MAP;

        private ComplexState(State state, SubState subState) {
            this.state = state;
            this.subState = subState;
        }

        public State getState() {
            return this.state;
        }

        public SubState getSubState() {
            return this.subState;
        }

        public ComplexState compute(State state) {
            return MAP.get(Pair.of((Object)((Object)state), (Object)((Object)this.subState)));
        }

        public ComplexState compute(SubState subState) {
            return MAP.get(Pair.of((Object)((Object)this.state), (Object)((Object)subState)));
        }

        static {
            MAP = new HashMap<Pair<State, SubState>, ComplexState>(ComplexState.values().length, 1.0f);
            Arrays.stream(ComplexState.values()).forEach(c -> MAP.put((Pair<State, SubState>)Pair.of((Object)((Object)c.state), (Object)((Object)c.subState)), (ComplexState)((Object)c)));
        }
    }

    @XmlType(namespace="APIAdminDevice")
    public static enum SubState {
        CLEANING,
        DIRTY,
        FREE,
        TESTING;

    }

    @XmlType(namespace="APIAdminDevice")
    public static enum State {
        ONLINE,
        OFFLINE;

    }

    @XmlType(namespace="APIAdminDevice")
    public static enum InitStep {
        SKIP,
        REBOOT,
        REBOOT_WITH_UNLOCK,
        UNLOCK_ONLY;

    }
}

