/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.testdroid.api.APIEntity;
import com.testdroid.api.model.APIAdminDevice;
import com.testdroid.api.model.APIAdminDeviceSession;
import com.testdroid.api.model.APICluster;
import com.testdroid.api.model.APIDeviceSession;
import com.testdroid.api.model.APIDeviceSessionStep;
import com.testdroid.api.util.TimeConverter;
import java.time.LocalDateTime;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class APIAdminDeviceEvent
extends APIEntity {
    private Date time;
    private DeviceEventType type;
    private APIAdminDevice.ComplexState state;
    private APIAdminDevice device;
    private APICluster cluster;
    private APIAdminDeviceSession deviceSession;

    public APIAdminDeviceEvent() {
    }

    public APIAdminDeviceEvent(Long id, LocalDateTime time, DeviceEventType type, APIAdminDevice.ComplexState state, Long deviceId, Long clusterId, String name, String url, APICluster.State clusterState, LocalDateTime stateTime, LocalDateTime stateChangeTime, Boolean enabled, Long deviceSessionId, LocalDateTime createTime, LocalDateTime startTime, LocalDateTime endTime, String startedByDisplayName, Long projectId, String projectName, Long testRunId, String testRunName, APIDeviceSession.State deviceSessionState, Integer priority, Boolean billable, Long deviceTime, APIDeviceSessionStep.Type currentStepType, String retriedFailReason) {
        super(id);
        this.time = TimeConverter.toDate(time);
        this.type = type;
        this.state = state;
        this.device = new APIAdminDevice(deviceId);
        this.cluster = new APICluster(clusterId, name, url, clusterState, stateTime, stateChangeTime, enabled);
        this.deviceSession = new APIAdminDeviceSession(deviceSessionId, createTime, startTime, endTime, startedByDisplayName, projectId, projectName, testRunId, testRunName, deviceSessionState, priority, billable, deviceTime, currentStepType, retriedFailReason);
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public DeviceEventType getType() {
        return this.type;
    }

    public void setType(DeviceEventType type) {
        this.type = type;
    }

    public APIAdminDevice getDevice() {
        return this.device;
    }

    public void setDevice(APIAdminDevice device) {
        this.device = device;
    }

    public APICluster getCluster() {
        return this.cluster;
    }

    public void setCluster(APICluster cluster) {
        this.cluster = cluster;
    }

    public APIAdminDeviceSession getDeviceSession() {
        return this.deviceSession;
    }

    public void setDeviceSession(APIAdminDeviceSession deviceSession) {
        this.deviceSession = deviceSession;
    }

    public APIAdminDevice.ComplexState getState() {
        return this.state;
    }

    public void setState(APIAdminDevice.ComplexState state) {
        this.state = state;
    }

    @Override
    protected <T extends APIEntity> void clone(T from) {
        APIAdminDeviceEvent deviceEvent = (APIAdminDeviceEvent)from;
        this.cloneBase(from);
        this.time = deviceEvent.time;
        this.state = deviceEvent.state;
        this.device = deviceEvent.device;
        this.cluster = deviceEvent.cluster;
        this.deviceSession = deviceEvent.deviceSession;
    }

    public static enum DeviceEventType {
        SESSION_START,
        SESSION_END,
        SESSION_TIMEOUT,
        STATE_CHANGE,
        CLUSTER_CHANGE;

    }
}

