/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIListResource;
import com.testdroid.api.dto.Context;
import com.testdroid.api.model.APIDevice;
import com.testdroid.api.model.APIDeviceProperty;
import java.util.Collections;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class APIDeviceGroup
extends APIEntity {
    @Deprecated
    private Long creditsPrice;
    private Long deviceCount;
    private String displayName;
    private String name;
    private APIDevice.OsType osType;
    private Long userId;
    private String userEmail;
    private boolean isShared;

    public APIDeviceGroup() {
    }

    public APIDeviceGroup(Long id, String name, String displayName, APIDevice.OsType osType, Long deviceCount, Long userId, String userEmail, boolean isShared) {
        this.id = id;
        this.name = name;
        this.displayName = displayName;
        this.creditsPrice = deviceCount;
        this.deviceCount = deviceCount;
        this.userId = userId;
        this.osType = osType;
        this.userEmail = userEmail;
        this.isShared = isShared;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Long getDeviceCount() {
        return this.deviceCount;
    }

    public void setDeviceCount(Long deviceCount) {
        this.deviceCount = deviceCount;
    }

    public Long getCreditsPrice() {
        return this.creditsPrice;
    }

    public void setCreditsPrice(Long creditsPrice) {
        this.creditsPrice = creditsPrice;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public APIDevice.OsType getOsType() {
        return this.osType;
    }

    public void setOsType(APIDevice.OsType osType) {
        this.osType = osType;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public void setShared(boolean shared) {
        this.isShared = shared;
    }

    @JsonIgnore
    public boolean isPublic() {
        return this.userId == null;
    }

    private String getIncludedDevicesURI() {
        return APIDeviceGroup.createUri(this.selfURI, "/devices");
    }

    private String getIncludedDevicesURI(Long deviceId) {
        return APIDeviceGroup.createUri(this.selfURI, "/devices/" + deviceId);
    }

    @JsonIgnore
    public APIListResource<APIDevice> getIncludedDevicesResource() throws APIException {
        return this.getListResource(this.getIncludedDevicesURI(), APIDevice.class);
    }

    @JsonIgnore
    public APIListResource<APIDevice> getIncludedDevicesResource(Context<APIDevice> context) throws APIException {
        return this.getListResource(this.getIncludedDevicesURI(), context);
    }

    public void delete() throws APIException {
        this.deleteResource(this.selfURI);
    }

    public void addDevice(APIDevice device) throws APIException {
        this.postResource(this.getIncludedDevicesURI(), Collections.singletonMap("deviceId", device.getId()), null);
    }

    public APIDeviceGroup addSelector(APIDeviceProperty deviceProperty) throws APIException {
        return this.postResource(APIDeviceGroup.createUri(this.selfURI, "/selectors"), Collections.singletonMap("selectorIds[]", deviceProperty.getId()), APIDeviceGroup.class);
    }

    public void deleteDevice(APIDevice device) throws APIException {
        this.deleteResource(this.getIncludedDevicesURI(device.getId()));
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APIDeviceGroup apiDeviceGroup = (APIDeviceGroup)from;
        this.cloneBase(from);
        this.creditsPrice = apiDeviceGroup.creditsPrice;
        this.deviceCount = apiDeviceGroup.deviceCount;
        this.name = apiDeviceGroup.name;
        this.displayName = apiDeviceGroup.displayName;
        this.userId = apiDeviceGroup.userId;
        this.osType = apiDeviceGroup.osType;
        this.userEmail = apiDeviceGroup.userEmail;
        this.isShared = apiDeviceGroup.isShared;
    }
}

