/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIListResource;
import com.testdroid.api.dto.Context;
import com.testdroid.api.model.APIDevice;
import com.testdroid.api.model.APIDeviceSessionStep;
import com.testdroid.api.model.APIScreenshot;
import com.testdroid.api.util.TimeConverter;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
public class APIDeviceSession
extends APIEntity {
    private Date createTime;
    private APIDevice device;
    private Date endTime;
    private Long launchAppDuration;
    private Date startTime;
    private Date installTime;
    private Long timeLimit;
    private Type type;
    private State state;
    @Deprecated
    private Long deviceRunId;
    private Integer testCaseAllCount;
    private Integer testCaseSuccessCount;
    private Integer testCasePassedCount;
    private Integer testCaseFailedCount;
    private Integer testCaseSkippedCount;
    private Boolean billable;
    private String excludeReason;
    private Long deviceInstanceId;
    private RetryState retryState;
    private Integer autoRetriesLeftCount;
    private Long deviceTime;
    private Long duration;
    private Long testRunId;
    private Long projectId;
    private Float successRatio;

    public APIDeviceSession() {
    }

    public APIDeviceSession(Long id, Type type, LocalDateTime createTime, LocalDateTime startTime, LocalDateTime installTime, LocalDateTime endTime, Long timeLimit, Long launchAppDuration, State state, Integer testCasePassedCount, Integer testCaseFailedCount, Integer testCaseSkippedCount, Boolean billable, Long deviceModelId, String displayName, Integer creditsPrice, String imagePrefix, Integer imageTop, Integer imageLeft, Integer imageWidth, Integer imageHeight, Integer frameExtraWidth, APIDevice.OsType osType, Boolean enabled, Long softwareVersionId, String releaseVersion, Integer apiLevel, ExcludeReason excludeReason, Long deviceInstanceId, RetryState retryState, Integer autoRetriesLeftCount, Long deviceTime, Long duration, Long projectId, Long testRunId, Float successRatio) {
        super(id);
        this.type = type;
        this.createTime = TimeConverter.toDate(createTime);
        this.startTime = TimeConverter.toDate(startTime);
        this.installTime = TimeConverter.toDate(installTime);
        this.endTime = TimeConverter.toDate(endTime);
        this.device = new APIDevice(deviceModelId, displayName, softwareVersionId, releaseVersion, apiLevel, creditsPrice, imagePrefix, imageTop, imageLeft, imageWidth, imageHeight, frameExtraWidth, osType, null, null, enabled, null, null);
        this.timeLimit = timeLimit;
        this.launchAppDuration = launchAppDuration;
        this.state = state;
        this.deviceRunId = id;
        this.billable = billable;
        this.deviceTime = deviceTime;
        this.excludeReason = excludeReason != null ? excludeReason.getDisplayName() : null;
        this.testCaseAllCount = testCasePassedCount + testCaseFailedCount + testCaseSkippedCount;
        this.testCaseSuccessCount = testCasePassedCount + testCaseFailedCount;
        this.testCasePassedCount = testCasePassedCount;
        this.testCaseFailedCount = testCaseFailedCount;
        this.testCaseSkippedCount = testCaseSkippedCount;
        this.deviceInstanceId = deviceInstanceId;
        this.retryState = retryState;
        this.autoRetriesLeftCount = autoRetriesLeftCount;
        this.duration = duration;
        this.projectId = projectId;
        this.testRunId = testRunId;
        this.successRatio = successRatio;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public APIDevice getDevice() {
        return this.device;
    }

    public void setDevice(APIDevice device) {
        this.device = device;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Long getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(Long timeLimit) {
        this.timeLimit = timeLimit;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getInstallTime() {
        return this.installTime;
    }

    public void setInstallTime(Date installTime) {
        this.installTime = installTime;
    }

    public Long getLaunchAppDuration() {
        return this.launchAppDuration;
    }

    public void setLaunchAppDuration(Long launchAppDuration) {
        this.launchAppDuration = launchAppDuration;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Long getDeviceRunId() {
        return this.deviceRunId;
    }

    public void setDeviceRunId(Long deviceRunId) {
        this.deviceRunId = deviceRunId;
    }

    public Integer getTestCaseAllCount() {
        return this.testCaseAllCount;
    }

    public void setTestCaseAllCount(Integer testCaseAllCount) {
        this.testCaseAllCount = testCaseAllCount;
    }

    public Integer getTestCaseSuccessCount() {
        return this.testCaseSuccessCount;
    }

    public void setTestCaseSuccessCount(Integer testCaseSuccessCount) {
        this.testCaseSuccessCount = testCaseSuccessCount;
    }

    public Integer getTestCasePassedCount() {
        return this.testCasePassedCount;
    }

    public void setTestCasePassedCount(Integer testCasePassedCount) {
        this.testCasePassedCount = testCasePassedCount;
    }

    public Integer getTestCaseFailedCount() {
        return this.testCaseFailedCount;
    }

    public void setTestCaseFailedCount(Integer testCaseFailedCount) {
        this.testCaseFailedCount = testCaseFailedCount;
    }

    public Integer getTestCaseSkippedCount() {
        return this.testCaseSkippedCount;
    }

    public void setTestCaseSkippedCount(Integer testCaseSkippedCount) {
        this.testCaseSkippedCount = testCaseSkippedCount;
    }

    public Boolean getBillable() {
        return this.billable;
    }

    public void setBillable(Boolean billable) {
        this.billable = billable;
    }

    public String getExcludeReason() {
        return this.excludeReason;
    }

    public void setExcludeReason(String excludeReason) {
        this.excludeReason = excludeReason;
    }

    public Long getDeviceInstanceId() {
        return this.deviceInstanceId;
    }

    public void setDeviceInstanceId(Long deviceInstanceId) {
        this.deviceInstanceId = deviceInstanceId;
    }

    public RetryState getRetryState() {
        return this.retryState;
    }

    public void setRetryState(RetryState retryState) {
        this.retryState = retryState;
    }

    public Integer getAutoRetriesLeftCount() {
        return this.autoRetriesLeftCount;
    }

    public void setAutoRetriesLeftCount(Integer autoRetriesLeftCount) {
        this.autoRetriesLeftCount = autoRetriesLeftCount;
    }

    public Long getDeviceTime() {
        return this.deviceTime;
    }

    public void setDeviceTime(Long deviceTime) {
        this.deviceTime = deviceTime;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public Long getTestRunId() {
        return this.testRunId;
    }

    public void setTestRunId(Long testRunId) {
        this.testRunId = testRunId;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Float getSuccessRatio() {
        return this.successRatio;
    }

    public void setSuccessRatio(Float successRatio) {
        this.successRatio = successRatio;
    }

    @JsonIgnore
    public APIListResource<APIDeviceSessionStep> getDeviceSessionStepsResource() throws APIException {
        return this.getListResource(APIDeviceSession.createUri(this.selfURI, "/steps"), APIDeviceSessionStep.class);
    }

    @JsonIgnore
    public APIListResource<APIScreenshot> getScreenshotsResource() throws APIException {
        return this.getListResource(this.getScreenshotsURI(), APIScreenshot.class);
    }

    @JsonIgnore
    public APIListResource<APIScreenshot> getScreenshotsResource(Context<APIScreenshot> context) throws APIException {
        return this.getListResource(this.getScreenshotsURI(), context);
    }

    @JsonIgnore
    public InputStream getOutputFiles() throws APIException {
        return this.client.get(APIDeviceSession.createUri(this.selfURI, "/output-file-set/files.zip"));
    }

    private String getScreenshotsURI() {
        return APIDeviceSession.createUri(this.selfURI, "/screenshots");
    }

    @Override
    protected <T extends APIEntity> void clone(T from) {
        APIDeviceSession apiDeviceSession = (APIDeviceSession)from;
        this.cloneBase(from);
        this.createTime = apiDeviceSession.createTime;
        this.startTime = apiDeviceSession.startTime;
        this.installTime = apiDeviceSession.installTime;
        this.endTime = apiDeviceSession.endTime;
        this.type = apiDeviceSession.type;
        this.device = apiDeviceSession.device;
        this.timeLimit = apiDeviceSession.timeLimit;
        this.launchAppDuration = apiDeviceSession.launchAppDuration;
        this.state = apiDeviceSession.state;
        this.deviceRunId = apiDeviceSession.deviceRunId;
        this.testCaseAllCount = apiDeviceSession.testCaseAllCount;
        this.testCaseSuccessCount = apiDeviceSession.testCaseSuccessCount;
        this.testCasePassedCount = apiDeviceSession.testCasePassedCount;
        this.testCaseFailedCount = apiDeviceSession.testCaseFailedCount;
        this.testCaseSkippedCount = apiDeviceSession.testCaseSkippedCount;
        this.billable = apiDeviceSession.billable;
        this.excludeReason = apiDeviceSession.excludeReason;
        this.deviceInstanceId = apiDeviceSession.deviceInstanceId;
        this.retryState = apiDeviceSession.retryState;
        this.autoRetriesLeftCount = apiDeviceSession.autoRetriesLeftCount;
        this.deviceTime = apiDeviceSession.deviceTime;
        this.duration = apiDeviceSession.duration;
        this.testRunId = apiDeviceSession.testRunId;
        this.projectId = apiDeviceSession.projectId;
        this.successRatio = apiDeviceSession.successRatio;
    }

    @XmlType(namespace="APIDeviceSession")
    public static enum State {
        ABORTED,
        EXCLUDED,
        FAILED,
        RUNNING,
        SUCCEEDED,
        TIMEOUT,
        WAITING,
        WARNING;


        public boolean isFinished() {
            switch (this) {
                case WAITING: 
                case RUNNING: {
                    return false;
                }
            }
            return true;
        }
    }

    @XmlType(namespace="APIDeviceSession")
    public static enum RetryState {
        NONE,
        MANUAL,
        AUTO;

    }

    @XmlType(namespace="APIDeviceSession")
    public static enum Type {
        AUTOMATIC,
        MANUAL,
        REMOTE;

    }

    @XmlType(namespace="APIDeviceSession")
    public static enum ExcludeReason {
        ADMIN("Test run was interrupted by user or administrator."),
        NO_DEVICE("Requested device does not exist or is busy at the moment."),
        API_LEVEL("The minimum API Level required for the application to run is higher than Device's API Level"),
        SINGLE_MODE("SINGLE mode test run - another device has started execution."),
        FRAMEWORK_NOT_SUPPORTED("The device does not support selected framework");

        private final String displayName;

        private ExcludeReason(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

