/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.util.TimeConverter;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class APIFileSet
extends APIEntity {
    private Date createTime;
    private Long fileCount;
    private String name;
    private String userEmail;
    private Long userId;
    private boolean isShared;

    public APIFileSet() {
    }

    public APIFileSet(Long id, String name, LocalDateTime createTime, Long fileCount, Long ownerEmail, String userEmail, boolean isShared) {
        super(id);
        this.name = name;
        this.createTime = TimeConverter.toDate(createTime);
        this.fileCount = fileCount;
        this.userId = ownerEmail;
        this.userEmail = userEmail;
        this.isShared = isShared;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(Long fileCount) {
        this.fileCount = fileCount;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public void setShared(boolean shared) {
        this.isShared = shared;
    }

    public void delete() throws APIException {
        this.deleteResource(this.selfURI);
    }

    public void update() throws APIException {
        APIFileSet fileSet = this.postResource(this.selfURI, Collections.singletonMap("name", this.name), APIFileSet.class);
        this.clone(fileSet);
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APIFileSet apiFileSet = (APIFileSet)from;
        this.cloneBase(from);
        this.name = apiFileSet.name;
        this.createTime = apiFileSet.createTime;
        this.fileCount = apiFileSet.fileCount;
        this.userId = apiFileSet.userId;
        this.userEmail = apiFileSet.userEmail;
        this.isShared = apiFileSet.isShared;
    }
}

