/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.testdroid.api.APIEntity;
import com.testdroid.api.util.TimeConverter;
import java.time.LocalDateTime;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.EnumUtils;

@XmlRootElement
public class APILicense
extends APIEntity {
    public static final String DISABLED_TEXT = "";
    public static final String ENABLED_TEXT = "on";
    private AndroidLicense android;
    private AppiumLicense appium;
    private CalabashLicense calabash;
    private Date expireTime;
    private Date activateTime;
    private Date closeTime;
    private DesktopLicense desktop;
    private InspectorLicense inspector;
    private IOSLicense ios;
    private boolean privateInstance;
    private boolean autoRenew;
    private Long userId;
    private RecorderLicense recorder;
    private RemoteControlLicense remoteControl;
    private SeleniumLicense selenium;
    private ServerLicense server;
    private GlobalLicense global;
    private XCTestLicense xcTest;
    private XCUITestLicense xcuiTest;
    private BuildLicense build;
    private String userEmail;
    private Status status;

    public APILicense() {
    }

    public APILicense(Long id, Long userId, String userEmail, boolean autoRenew, boolean enterprise, LocalDateTime activateTime, LocalDateTime expireTime, Integer androidDeviceLimit, Boolean androidEnabled, Boolean seleniumEnabled, Boolean serverAndroidEnabled, Boolean calabashEnabled, Boolean uiautomatorEnabled, Boolean recorderEnabled, Integer iosProjectLimit, Boolean serverIosEnabled, Integer recorderLimit, Boolean remoteControlEnabled, Boolean xcTestEnabled, Boolean xcuiTestEnabled, Boolean ctsEnabled, Integer androidProjectLimit, Boolean appiumEnabled, Boolean serverEnabled, Boolean inspectorEnabled, Boolean iosEnabled, Integer iosDeviceLimit, LocalDateTime closeTime, String status, Boolean buildEnabled, Integer buildLimit, Boolean desktopEnabled, Integer desktopDeviceLimit, Integer desktopProjectLimit, Integer globalDeviceLimit, Integer globalProjectLimit) {
        super(id);
        this.privateInstance = enterprise;
        this.activateTime = TimeConverter.toDate(activateTime);
        this.expireTime = TimeConverter.toDate(expireTime);
        this.userEmail = userEmail;
        this.userId = userId;
        this.autoRenew = autoRenew;
        this.android = new AndroidLicense(androidDeviceLimit, androidProjectLimit, new AndroidLicense.CTSLicense(ctsEnabled), new AndroidLicense.UIAutomatorLicense(uiautomatorEnabled), androidEnabled);
        this.ios = new IOSLicense(iosDeviceLimit, iosProjectLimit, iosEnabled);
        this.build = new BuildLicense(buildLimit, buildEnabled);
        this.recorder = new RecorderLicense(recorderLimit, recorderEnabled);
        this.server = new ServerLicense(serverAndroidEnabled, serverIosEnabled, serverEnabled);
        this.calabash = new CalabashLicense(calabashEnabled);
        this.appium = new AppiumLicense(appiumEnabled);
        this.selenium = new SeleniumLicense(seleniumEnabled);
        this.inspector = new InspectorLicense(inspectorEnabled);
        this.remoteControl = new RemoteControlLicense(remoteControlEnabled);
        this.xcTest = new XCTestLicense(xcTestEnabled);
        this.xcuiTest = new XCUITestLicense(xcuiTestEnabled);
        this.desktop = new DesktopLicense(desktopDeviceLimit, desktopProjectLimit, desktopEnabled);
        this.global = new GlobalLicense(globalDeviceLimit, globalProjectLimit);
        this.closeTime = TimeConverter.toDate(closeTime);
        this.status = (Status)EnumUtils.getEnum(Status.class, (String)status);
    }

    public APILicense(boolean privateInstance, LocalDateTime expireTime, String userEmail, AndroidLicense android, IOSLicense ios, RecorderLicense recorder, ServerLicense server, CalabashLicense calabash, AppiumLicense appium, SeleniumLicense selenium, InspectorLicense inspector, RemoteControlLicense remoteControl, XCTestLicense xcTest, XCUITestLicense xcuiTest, BuildLicense build, DesktopLicense desktop, GlobalLicense global) {
        this.privateInstance = privateInstance;
        this.expireTime = TimeConverter.toDate(expireTime);
        this.userEmail = userEmail;
        this.android = android;
        this.ios = ios;
        this.recorder = recorder;
        this.server = server;
        this.calabash = calabash;
        this.appium = appium;
        this.selenium = selenium;
        this.inspector = inspector;
        this.remoteControl = remoteControl;
        this.xcTest = xcTest;
        this.xcuiTest = xcuiTest;
        this.build = build;
        this.desktop = desktop;
        this.global = global;
    }

    private static String getTextValue(Integer i) {
        return i != null ? Integer.toString(i) : DISABLED_TEXT;
    }

    private static String getTextValue(boolean b) {
        return b ? ENABLED_TEXT : DISABLED_TEXT;
    }

    @Override
    protected <T extends APIEntity> void clone(T from) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isPrivateInstance() {
        return this.privateInstance;
    }

    public void setPrivateInstance(boolean privateInstance) {
        this.privateInstance = privateInstance;
    }

    public AndroidLicense getAndroid() {
        return this.android;
    }

    public void setAndroid(AndroidLicense android) {
        this.android = android;
    }

    public Date getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    @JsonIgnore
    public boolean isExpired() {
        return this.expireTime == null || new Date().after(this.expireTime);
    }

    public Date getActivateTime() {
        return this.activateTime;
    }

    public void setActivateTime(Date activateTime) {
        this.activateTime = activateTime;
    }

    public IOSLicense getIos() {
        return this.ios;
    }

    public void setIos(IOSLicense ios) {
        this.ios = ios;
    }

    public RecorderLicense getRecorder() {
        return this.recorder;
    }

    public void setRecorder(RecorderLicense recorder) {
        this.recorder = recorder;
    }

    public InspectorLicense getInspector() {
        return this.inspector;
    }

    public void setInspector(InspectorLicense inspector) {
        this.inspector = inspector;
    }

    public ServerLicense getServer() {
        return this.server;
    }

    public void setServer(ServerLicense server) {
        this.server = server;
    }

    public CalabashLicense getCalabash() {
        return this.calabash;
    }

    public void setCalabash(CalabashLicense calabash) {
        this.calabash = calabash;
    }

    public RemoteControlLicense getRemoteControl() {
        return this.remoteControl;
    }

    public void setRemoteControl(RemoteControlLicense remoteControl) {
        this.remoteControl = remoteControl;
    }

    public AppiumLicense getAppium() {
        return this.appium;
    }

    public void setAppium(AppiumLicense appium) {
        this.appium = appium;
    }

    public SeleniumLicense getSelenium() {
        return this.selenium;
    }

    public void setSelenium(SeleniumLicense selenium) {
        this.selenium = selenium;
    }

    public XCTestLicense getXcTest() {
        return this.xcTest;
    }

    public void setXcTest(XCTestLicense xcTest) {
        this.xcTest = xcTest;
    }

    public XCUITestLicense getXcuiTest() {
        return this.xcuiTest;
    }

    public void setXcuiTest(XCUITestLicense xcuiTest) {
        this.xcuiTest = xcuiTest;
    }

    public BuildLicense getBuild() {
        return this.build;
    }

    public void setBuild(BuildLicense build) {
        this.build = build;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public boolean isAutoRenew() {
        return this.autoRenew;
    }

    public void setAutoRenew(boolean autoRenew) {
        this.autoRenew = autoRenew;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Date getCloseTime() {
        return this.closeTime;
    }

    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    public DesktopLicense getDesktop() {
        return this.desktop;
    }

    public void setDesktop(DesktopLicense desktop) {
        this.desktop = desktop;
    }

    public GlobalLicense getGlobal() {
        return this.global;
    }

    public void setGlobal(GlobalLicense global) {
        this.global = global;
    }

    public String generateSignContent() {
        return String.format("%s:%s:%s%s%s%s", APILicense.getTextValue(this.privateInstance), this.getUserEmail(), this.getAndroid().generateSignContent(), this.getIos().generateSignContent(), this.getRecorder().generateSignContent(), this.getServer().generateSignContent());
    }

    public static class XCUITestLicense
    extends FeatureLicense {
        public XCUITestLicense() {
        }

        public XCUITestLicense(boolean enabled) {
            super(enabled);
        }

        @Override
        public String generateSignContent() {
            return APILicense.getTextValue(this.enabled);
        }
    }

    public static class XCTestLicense
    extends FeatureLicense {
        public XCTestLicense() {
        }

        public XCTestLicense(boolean enabled) {
            super(enabled);
        }

        @Override
        public String generateSignContent() {
            return APILicense.getTextValue(this.enabled);
        }
    }

    public static class InspectorLicense
    extends FeatureLicense {
        public InspectorLicense() {
        }

        public InspectorLicense(boolean enabled) {
            super(enabled);
        }

        @Override
        public String generateSignContent() {
            return APILicense.getTextValue(this.enabled);
        }
    }

    public static class SeleniumLicense
    extends FeatureLicense {
        public SeleniumLicense() {
        }

        public SeleniumLicense(boolean enabled) {
            super(enabled);
        }

        @Override
        public String generateSignContent() {
            return APILicense.getTextValue(this.enabled);
        }
    }

    public static class AppiumLicense
    extends FeatureLicense {
        public AppiumLicense() {
        }

        public AppiumLicense(boolean enabled) {
            super(enabled);
        }

        @Override
        public String generateSignContent() {
            return APILicense.getTextValue(this.enabled);
        }
    }

    public static class RemoteControlLicense
    extends FeatureLicense {
        public RemoteControlLicense() {
        }

        public RemoteControlLicense(boolean enabled) {
            super(enabled);
        }

        @Override
        public String generateSignContent() {
            return APILicense.getTextValue(this.enabled);
        }
    }

    public static class CalabashLicense
    extends FeatureLicense {
        public CalabashLicense() {
        }

        public CalabashLicense(boolean enabled) {
            super(enabled);
        }

        @Override
        public String generateSignContent() {
            return APILicense.getTextValue(this.enabled);
        }
    }

    public static class ServerLicense
    extends FeatureLicense {
        private boolean androidEnabled;
        private boolean iosEnabled;

        public ServerLicense() {
        }

        public ServerLicense(boolean androidEnabled, boolean iosEnabled, boolean enabled) {
            super(enabled);
            this.androidEnabled = androidEnabled;
            this.iosEnabled = iosEnabled;
        }

        public boolean isAndroidEnabled() {
            return this.androidEnabled;
        }

        public void setAndroidEnabled(boolean androidEnabled) {
            this.androidEnabled = androidEnabled;
        }

        public boolean isIosEnabled() {
            return this.iosEnabled;
        }

        public void setIosEnabled(boolean iosEnabled) {
            this.iosEnabled = iosEnabled;
        }

        @Override
        public String generateSignContent() {
            return String.format("%s%s%s", APILicense.getTextValue(this.enabled), APILicense.getTextValue(this.androidEnabled), APILicense.getTextValue(this.iosEnabled));
        }
    }

    public static class RecorderLicense
    extends FeatureLicense {
        private Integer limit;

        public RecorderLicense() {
        }

        public RecorderLicense(Integer limit, boolean enabled) {
            super(enabled);
            this.limit = limit;
        }

        public Integer getLimit() {
            return this.limit;
        }

        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        public boolean isLimited() {
            return this.limit != null;
        }

        @Override
        public String generateSignContent() {
            return String.format("%s%s", APILicense.getTextValue(this.enabled), APILicense.getTextValue(this.limit));
        }
    }

    public static class DesktopLicense
    extends FeatureLicense {
        private Integer deviceLimit;
        private Integer projectLimit;

        public DesktopLicense() {
        }

        public DesktopLicense(Integer deviceLimit, Integer projectLimit, boolean enabled) {
            super(enabled);
            this.deviceLimit = deviceLimit;
            this.projectLimit = projectLimit;
        }

        public Integer getDeviceLimit() {
            return this.deviceLimit;
        }

        public void setDeviceLimit(Integer deviceLimit) {
            this.deviceLimit = deviceLimit;
        }

        public Integer getProjectLimit() {
            return this.projectLimit;
        }

        public void setProjectLimit(Integer projectLimit) {
            this.projectLimit = projectLimit;
        }

        public boolean isDeviceLimited() {
            return this.deviceLimit != null;
        }

        public boolean isProjectLimited() {
            return this.projectLimit != null;
        }

        @Override
        public String generateSignContent() {
            return String.format("%s%s%s", APILicense.getTextValue(this.enabled), APILicense.getTextValue(this.projectLimit), APILicense.getTextValue(this.deviceLimit));
        }
    }

    public static class IOSLicense
    extends FeatureLicense {
        private Integer deviceLimit;
        private Integer projectLimit;

        public IOSLicense() {
        }

        public IOSLicense(Integer deviceLimit, Integer projectLimit, boolean enabled) {
            super(enabled);
            this.deviceLimit = deviceLimit;
            this.projectLimit = projectLimit;
        }

        public Integer getDeviceLimit() {
            return this.deviceLimit;
        }

        public void setDeviceLimit(Integer deviceLimit) {
            this.deviceLimit = deviceLimit;
        }

        public Integer getProjectLimit() {
            return this.projectLimit;
        }

        public void setProjectLimit(Integer projectLimit) {
            this.projectLimit = projectLimit;
        }

        public boolean isDeviceLimited() {
            return this.deviceLimit != null;
        }

        public boolean isProjectLimited() {
            return this.projectLimit != null;
        }

        @Override
        public String generateSignContent() {
            return String.format("%s%s%s", APILicense.getTextValue(this.enabled), APILicense.getTextValue(this.projectLimit), APILicense.getTextValue(this.deviceLimit));
        }
    }

    public static class BuildLicense
    extends FeatureLicense {
        private Integer limit;

        public BuildLicense() {
        }

        public BuildLicense(Integer limit, boolean enabled) {
            super(enabled);
            this.limit = limit;
        }

        public Integer getLimit() {
            return this.limit;
        }

        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        public boolean isLimited() {
            return this.limit != null;
        }

        @Override
        public String generateSignContent() {
            return String.format("%s%s", APILicense.getTextValue(this.enabled), APILicense.getTextValue(this.limit));
        }
    }

    public static class AndroidLicense
    extends FeatureLicense {
        private CTSLicense cts;
        private Integer deviceLimit;
        private Integer projectLimit;
        private UIAutomatorLicense uiAutomator;

        public AndroidLicense() {
        }

        public AndroidLicense(Integer deviceLimit, Integer projectLimit, CTSLicense cts, UIAutomatorLicense uiAutomator, boolean enabled) {
            super(enabled);
            this.deviceLimit = deviceLimit;
            this.projectLimit = projectLimit;
            this.cts = cts;
            this.uiAutomator = uiAutomator;
        }

        public CTSLicense getCts() {
            return this.cts;
        }

        public void setCts(CTSLicense cts) {
            this.cts = cts;
        }

        public Integer getDeviceLimit() {
            return this.deviceLimit;
        }

        public void setDeviceLimit(Integer deviceLimit) {
            this.deviceLimit = deviceLimit;
        }

        public Integer getProjectLimit() {
            return this.projectLimit;
        }

        public void setProjectLimit(Integer projectLimit) {
            this.projectLimit = projectLimit;
        }

        public UIAutomatorLicense getUiAutomator() {
            return this.uiAutomator;
        }

        public void setUiAutomator(UIAutomatorLicense uiAutomator) {
            this.uiAutomator = uiAutomator;
        }

        public boolean isDeviceLimited() {
            return this.deviceLimit != null;
        }

        public boolean isProjectLimited() {
            return this.projectLimit != null;
        }

        @Override
        public String generateSignContent() {
            return String.format("%s%s%s%s%s", APILicense.getTextValue(this.enabled), APILicense.getTextValue(this.projectLimit), APILicense.getTextValue(this.deviceLimit), this.cts.generateSignContent(), this.uiAutomator.generateSignContent());
        }

        public static class UIAutomatorLicense
        extends FeatureLicense {
            public UIAutomatorLicense() {
            }

            public UIAutomatorLicense(boolean enabled) {
                super(enabled);
            }

            @Override
            public String generateSignContent() {
                return APILicense.getTextValue(this.enabled);
            }
        }

        public static class CTSLicense
        extends FeatureLicense {
            public CTSLicense() {
            }

            public CTSLicense(boolean enabled) {
                super(enabled);
            }

            @Override
            public String generateSignContent() {
                return APILicense.getTextValue(this.enabled);
            }
        }
    }

    public static abstract class FeatureLicense {
        boolean enabled;

        FeatureLicense() {
        }

        FeatureLicense(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public abstract String generateSignContent();
    }

    public static class GlobalLicense {
        private Integer deviceLimit;
        private Integer projectLimit;

        public GlobalLicense() {
        }

        public GlobalLicense(Integer deviceLimit, Integer projectLimit) {
            this.deviceLimit = deviceLimit;
            this.projectLimit = projectLimit;
        }

        public Integer getDeviceLimit() {
            return this.deviceLimit;
        }

        public void setDeviceLimit(Integer deviceLimit) {
            this.deviceLimit = deviceLimit;
        }

        public Integer getProjectLimit() {
            return this.projectLimit;
        }

        public void setProjectLimit(Integer projectLimit) {
            this.projectLimit = projectLimit;
        }

        public boolean isDeviceLimited() {
            return this.deviceLimit != null;
        }

        public boolean isProjectLimited() {
            return this.projectLimit != null;
        }
    }

    @XmlType(namespace="APILicense")
    public static enum Status {
        ACTIVE,
        EXPIRED,
        INACTIVE,
        CLOSED;

    }
}

