/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIListResource;
import com.testdroid.api.dto.Context;
import com.testdroid.api.model.APIDevice;
import com.testdroid.api.model.APIProjectJobConfig;
import com.testdroid.api.model.APITestRun;
import com.testdroid.api.model.APITestRunConfig;
import com.testdroid.api.util.TimeConverter;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
public class APIProject
extends APIEntity {
    private Integer archivingItemCount;
    private APIArchivingStrategy archivingStrategy;
    private boolean common;
    private String description;
    private byte[] icon;
    private Map<APIProjectJobConfig.Type, APIProjectJobConfig> jobConfig;
    private String name;
    @Deprecated
    private String sharedByEmail;
    @Deprecated
    private Long sharedById;
    private APITestRunConfig testRunConfig;
    private Type type;
    private Date createTime;
    private Date archiveTime;
    private boolean isShared;
    private Double successRatio;
    private APIDevice.OsType osType;
    private boolean readOnly;
    private Long userId;
    private String userEmail;

    public APIProject() {
    }

    public APIProject(Long id, LocalDateTime createTime, LocalDateTime archiveTime, String name, String description, Type type, Long sharedById, String sharedByEmail, boolean common, APIArchivingStrategy archivingStrategy, Integer archivingItemCount, Boolean isShared, APIDevice.OsType osType, boolean readOnly) {
        super(id);
        this.createTime = TimeConverter.toDate(createTime);
        this.archiveTime = TimeConverter.toDate(archiveTime);
        this.name = name;
        this.description = description;
        this.type = type;
        this.sharedById = sharedById;
        this.sharedByEmail = sharedByEmail;
        this.common = common;
        this.archivingStrategy = archivingStrategy;
        this.archivingItemCount = archivingItemCount;
        this.isShared = isShared;
        this.jobConfig = new HashMap<APIProjectJobConfig.Type, APIProjectJobConfig>();
        this.osType = osType;
        this.readOnly = readOnly;
        this.userEmail = sharedByEmail;
        this.userId = sharedById;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isCommon() {
        return this.common;
    }

    public void setCommon(boolean common) {
        this.common = common;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getArchiveTime() {
        return this.archiveTime;
    }

    public void setArchiveTime(Date archiveTime) {
        this.archiveTime = archiveTime;
    }

    public Long getSharedById() {
        return this.sharedById;
    }

    public void setSharedById(Long sharedById) {
        this.sharedById = sharedById;
    }

    public String getSharedByEmail() {
        return this.sharedByEmail;
    }

    public void setSharedByEmail(String sharedByEmail) {
        this.sharedByEmail = sharedByEmail;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public void setShared(boolean isShared) {
        this.isShared = isShared;
    }

    public APIArchivingStrategy getArchivingStrategy() {
        return this.archivingStrategy;
    }

    public void setArchivingStrategy(APIArchivingStrategy archivingStrategy) {
        this.archivingStrategy = archivingStrategy;
    }

    public Integer getArchivingItemCount() {
        return this.archivingItemCount;
    }

    public void setArchivingItemCount(Integer archivingItemCount) {
        this.archivingItemCount = archivingItemCount;
    }

    public Double getSuccessRatio() {
        return this.successRatio;
    }

    public void setSuccessRatio(Double successRatio) {
        this.successRatio = successRatio;
    }

    public APIDevice.OsType getOsType() {
        return this.osType;
    }

    public void setOsType(APIDevice.OsType osType) {
        this.osType = osType;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    private String getRunsURI() {
        return APIProject.createUri(this.selfURI, "/runs");
    }

    private String getRunURI(Long id) {
        return APIProject.createUri(this.selfURI, "/runs/" + id);
    }

    public void delete() throws APIException {
        this.deleteResource(this.selfURI);
    }

    @JsonIgnore
    public APIListResource<APITestRun> getTestRunsResource() throws APIException {
        return this.getListResource(this.getRunsURI(), APITestRun.class);
    }

    @JsonIgnore
    public APIListResource<APITestRun> getTestRunsResource(Context<APITestRun> context) throws APIException {
        return this.getListResource(this.getRunsURI(), context);
    }

    public APITestRun getTestRun(Long id) throws APIException {
        return this.getResource(this.getRunURI(id), APITestRun.class).getEntity();
    }

    public void update() throws APIException {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("name", this.name);
        body.put("description", this.description);
        body.put("common", this.common);
        body.put("archivingStrategy", this.archivingStrategy.name());
        body.put("archivingItemCount", this.archivingItemCount);
        APIProject project = this.postResource(this.selfURI, body, APIProject.class);
        this.clone(project);
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APIProject apiProject = (APIProject)from;
        this.cloneBase(from);
        this.common = apiProject.common;
        this.createTime = apiProject.createTime;
        this.archiveTime = apiProject.archiveTime;
        this.description = apiProject.description;
        this.icon = apiProject.icon;
        this.jobConfig = apiProject.jobConfig;
        this.name = apiProject.name;
        this.sharedById = apiProject.sharedById;
        this.testRunConfig = apiProject.testRunConfig;
        this.type = apiProject.type;
        this.archivingStrategy = apiProject.archivingStrategy;
        this.archivingItemCount = apiProject.archivingItemCount;
        this.successRatio = apiProject.successRatio;
        this.osType = apiProject.osType;
        this.readOnly = apiProject.readOnly;
        this.userId = apiProject.userId;
        this.userEmail = apiProject.userEmail;
    }

    @XmlType(namespace="APIProject")
    public static enum Type {
        ANDROID(APIDevice.OsType.ANDROID, APIProjectJobConfig.Type.DEFAULT, "Android Instrumentation"),
        IOS(APIDevice.OsType.IOS, APIProjectJobConfig.Type.APPCRAWLER_IOS, "AppCrawler iOS"),
        CALABASH(APIDevice.OsType.ANDROID, APIProjectJobConfig.Type.CALABASH, "Calabash Android"),
        CALABASH_IOS(APIDevice.OsType.IOS, APIProjectJobConfig.Type.CALABASH_IOS, "Calabash iOS"),
        XCTEST(APIDevice.OsType.IOS, APIProjectJobConfig.Type.XCTEST, "XCTest"),
        XCUITEST(APIDevice.OsType.IOS, APIProjectJobConfig.Type.XCUITEST, "XCUITest"),
        APPIUM_ANDROID(APIDevice.OsType.ANDROID, APIProjectJobConfig.Type.APPIUM_ANDROID, "Appium Android client side"),
        APPIUM_ANDROID_SERVER_SIDE(APIDevice.OsType.ANDROID, APIProjectJobConfig.Type.APPIUM_ANDROID_SERVER_SIDE, "Appium Android server side"),
        APPIUM_IOS(APIDevice.OsType.IOS, APIProjectJobConfig.Type.APPIUM_IOS, "Appium iOS client side"),
        APPIUM_IOS_SERVER_SIDE(APIDevice.OsType.IOS, APIProjectJobConfig.Type.APPIUM_IOS_SERVER_SIDE, "Appium iOS server side"),
        GENERIC(APIDevice.OsType.UNDEFINED, APIProjectJobConfig.Type.GENERIC, "Generic");

        private final APIProjectJobConfig.Type jobConfigType;
        private final APIDevice.OsType osType;
        private final String title;

        private Type(APIDevice.OsType osType, APIProjectJobConfig.Type jobConfigType, String title) {
            this.osType = osType;
            this.jobConfigType = jobConfigType;
            this.title = title;
        }

        public APIDevice.OsType getOsType() {
            return this.osType;
        }

        public String getTitle() {
            return this.title;
        }

        public APIProjectJobConfig.Type getJobConfigType() {
            return this.jobConfigType;
        }
    }

    @XmlType(namespace="APIProject")
    public static enum APIArchivingStrategy {
        NEVER,
        DAYS,
        RUNS;

    }
}

